/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.v0;

import akka.http.javadsl.model.HttpHeader;
import akka.http.javadsl.model.StatusCodes;
import akka.http.javadsl.server.ExceptionHandler;
import akka.http.javadsl.server.PathMatchers;
import akka.http.javadsl.server.Route;
import io.mantisrx.master.api.akka.route.Jackson;
import io.mantisrx.master.api.akka.route.v0.BaseRoute;
import io.mantisrx.runtime.JobConstraints;
import io.mantisrx.runtime.WorkerMigrationConfig;
import io.mantisrx.runtime.descriptor.StageScalingPolicy;
import io.mantisrx.server.core.master.MasterDescription;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.config.MasterConfiguration;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterDescriptionRoute
extends BaseRoute {
    private static final Logger logger = LoggerFactory.getLogger(MasterDescriptionRoute.class);
    private static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final MasterDescription masterDesc;
    private String masterDescStr;
    private final List<Configlet> configs = new ArrayList<Configlet>();
    private static final HttpHeader ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = HttpHeader.parse((String)"Access-Control-Allow-Origin", (String)"*");
    private static final Iterable<HttpHeader> DEFAULT_RESPONSE_HEADERS = Arrays.asList(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);

    public MasterDescriptionRoute(MasterDescription masterDescription) {
        this.masterDesc = masterDescription;
        try {
            this.masterDescStr = mapper.writeValueAsString((Object)this.masterDesc);
        }
        catch (JsonProcessingException e) {
            logger.error("failed to create json for master desc {}", (Object)this.masterDesc);
            this.masterDescStr = this.masterDesc.toString();
        }
        try {
            this.configs.add(new Configlet(JobConstraints.class.getSimpleName(), mapper.writeValueAsString((Object)JobConstraints.values())));
            this.configs.add(new Configlet(StageScalingPolicy.ScalingReason.class.getSimpleName(), mapper.writeValueAsString((Object)StageScalingPolicy.ScalingReason.values())));
            this.configs.add(new Configlet(WorkerMigrationConfig.MigrationStrategyEnum.class.getSimpleName(), mapper.writeValueAsString((Object)WorkerMigrationConfig.MigrationStrategyEnum.values())));
            MasterConfiguration config = ConfigurationProvider.getConfig();
            int maxCpuCores = config.getWorkerMachineDefinitionMaxCpuCores();
            int maxMemoryMB = config.getWorkerMachineDefinitionMaxMemoryMB();
            int maxNetworkMbps = config.getWorkerMachineDefinitionMaxNetworkMbps();
            this.configs.add(new Configlet(WorkerResourceLimits.class.getSimpleName(), mapper.writeValueAsString((Object)new WorkerResourceLimits(maxCpuCores, maxMemoryMB, maxNetworkMbps))));
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<Configlet> getConfigs() {
        return this.configs;
    }

    private Route getMasterDescRoute() {
        return this.route(new Route[]{this.get(() -> this.route(new Route[]{this.path(PathMatchers.segment((String)"api").slash("masterinfo"), () -> this.completeOK(this.masterDesc, Jackson.marshaller())), this.path(PathMatchers.segment((String)"api").slash("masterinfostr"), () -> this.complete(StatusCodes.OK, this.masterDescStr)), this.path(PathMatchers.segment((String)"api").slash("masterconfig"), () -> this.completeOK(this.configs, Jackson.marshaller()))}))});
    }

    public Route createRoute(Function<Route, Route> routeFilter) {
        logger.info("creating routes");
        ExceptionHandler jsonExceptionHandler = ExceptionHandler.newBuilder().match(IOException.class, x -> {
            logger.error("got exception", (Throwable)x);
            return this.complete(StatusCodes.BAD_REQUEST, "caught exception " + x.getMessage());
        }).build();
        return this.respondWithHeaders(DEFAULT_RESPONSE_HEADERS, () -> this.handleExceptions(jsonExceptionHandler, () -> (Route)routeFilter.apply(this.getMasterDescRoute())));
    }

    static class WorkerResourceLimits {
        private final int maxCpuCores;
        private final int maxMemoryMB;
        private final int maxNetworkMbps;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public WorkerResourceLimits(@JsonProperty(value="maxCpuCores") int maxCpuCores, @JsonProperty(value="maxMemoryMB") int maxMemoryMB, @JsonProperty(value="maxNetworkMbps") int maxNetworkMbps) {
            this.maxCpuCores = maxCpuCores;
            this.maxMemoryMB = maxMemoryMB;
            this.maxNetworkMbps = maxNetworkMbps;
        }

        public int getMaxCpuCores() {
            return this.maxCpuCores;
        }

        public int getMaxMemoryMB() {
            return this.maxMemoryMB;
        }

        public int getMaxNetworkMbps() {
            return this.maxNetworkMbps;
        }
    }

    public static class Configlet {
        private final String name;
        private final String value;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public Configlet(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Configlet configlet = (Configlet)o;
            return Objects.equals(this.name, configlet.name) && Objects.equals(this.value, configlet.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        public String toString() {
            return "Configlet{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }
}

