/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.v1;

import akka.http.javadsl.server.PathMatcher0;
import akka.http.javadsl.server.PathMatchers;
import akka.http.javadsl.server.Route;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import io.mantisrx.master.api.akka.route.Jackson;
import io.mantisrx.master.api.akka.route.v1.BaseRoute;
import io.mantisrx.master.api.akka.route.v1.HttpRequestMetrics;
import io.mantisrx.runtime.JobConstraints;
import io.mantisrx.runtime.WorkerMigrationConfig;
import io.mantisrx.runtime.descriptor.StageScalingPolicy;
import io.mantisrx.server.core.master.MasterDescription;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.config.MasterConfiguration;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminMasterRoute
extends BaseRoute {
    private static final Logger logger = LoggerFactory.getLogger(AdminMasterRoute.class);
    private static final PathMatcher0 MASTER_API_PREFIX = PathMatchers.segment((String)"api").slash("v1");
    private static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final MasterDescription masterDesc;
    private final List<Configlet> configs = new ArrayList<Configlet>();

    public AdminMasterRoute(MasterDescription masterDescription) {
        this.masterDesc = new MasterDescription(masterDescription.getHostname(), masterDescription.getHostIP(), masterDescription.getApiPort(), masterDescription.getSchedInfoPort(), -1, "api/v1/jobs/actions/postJobStatus", -1, masterDescription.getCreateTime());
        try {
            this.configs.add(new Configlet(JobConstraints.class.getSimpleName(), mapper.writeValueAsString((Object)JobConstraints.values())));
            this.configs.add(new Configlet(StageScalingPolicy.ScalingReason.class.getSimpleName(), mapper.writeValueAsString((Object)StageScalingPolicy.ScalingReason.values())));
            this.configs.add(new Configlet(WorkerMigrationConfig.MigrationStrategyEnum.class.getSimpleName(), mapper.writeValueAsString((Object)WorkerMigrationConfig.MigrationStrategyEnum.values())));
            MasterConfiguration config = ConfigurationProvider.getConfig();
            int maxCpuCores = config.getWorkerMachineDefinitionMaxCpuCores();
            int maxMemoryMB = config.getWorkerMachineDefinitionMaxMemoryMB();
            int maxNetworkMbps = config.getWorkerMachineDefinitionMaxNetworkMbps();
            this.configs.add(new Configlet(WorkerResourceLimits.class.getSimpleName(), mapper.writeValueAsString((Object)new WorkerResourceLimits(maxCpuCores, maxMemoryMB, maxNetworkMbps))));
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<Configlet> getConfigs() {
        return this.configs;
    }

    @Override
    protected Route constructRoutes() {
        return this.pathPrefix(MASTER_API_PREFIX, () -> this.concat(this.path(PathMatchers.segment((String)"masterInfo"), () -> this.pathEndOrSingleSlash(() -> this.concat(this.get(this::getMasterInfo), new Route[0]))), new Route[]{this.path(PathMatchers.segment((String)"masterConfigs"), () -> this.pathEndOrSingleSlash(() -> this.concat(this.get(this::getMasterConfigs), new Route[0])))}));
    }

    @Override
    public Route createRoute(Function<Route, Route> routeFilter) {
        logger.info("creating /api/v1/masterInfo routes");
        logger.info("creating /api/v1/masterConfigs routes");
        return super.createRoute(routeFilter);
    }

    private Route getMasterInfo() {
        logger.info("GET /api/v1/masterInfo called");
        HttpRequestMetrics.getInstance().incrementEndpointMetrics("api.v1.masterInfo", new Tag[]{new BasicTag("verb", HttpRequestMetrics.HttpVerb.GET.toString()), new BasicTag("responseCode", "200")});
        return this.completeOK(this.masterDesc, Jackson.marshaller());
    }

    private Route getMasterConfigs() {
        logger.info("GET /api/v1/masterConfigs called");
        HttpRequestMetrics.getInstance().incrementEndpointMetrics("api.v1.masterConfigs", new Tag[]{new BasicTag("verb", HttpRequestMetrics.HttpVerb.GET.toString()), new BasicTag("responseCode", "200")});
        return this.completeOK(this.configs, Jackson.marshaller());
    }

    static class WorkerResourceLimits {
        private final int maxCpuCores;
        private final int maxMemoryMB;
        private final int maxNetworkMbps;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public WorkerResourceLimits(@JsonProperty(value="maxCpuCores") int maxCpuCores, @JsonProperty(value="maxMemoryMB") int maxMemoryMB, @JsonProperty(value="maxNetworkMbps") int maxNetworkMbps) {
            this.maxCpuCores = maxCpuCores;
            this.maxMemoryMB = maxMemoryMB;
            this.maxNetworkMbps = maxNetworkMbps;
        }

        public int getMaxCpuCores() {
            return this.maxCpuCores;
        }

        public int getMaxMemoryMB() {
            return this.maxMemoryMB;
        }

        public int getMaxNetworkMbps() {
            return this.maxNetworkMbps;
        }
    }

    public static class Configlet {
        private final String name;
        private final String value;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public Configlet(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Configlet configlet = (Configlet)o;
            return Objects.equals(this.name, configlet.name) && Objects.equals(this.value, configlet.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        public String toString() {
            return "Configlet{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }
}

