/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.v1;

import akka.actor.ActorSystem;
import akka.http.caching.javadsl.Cache;
import akka.http.javadsl.model.HttpResponse;
import akka.http.javadsl.model.StatusCodes;
import akka.http.javadsl.model.Uri;
import akka.http.javadsl.server.PathMatcher0;
import akka.http.javadsl.server.PathMatchers;
import akka.http.javadsl.server.Route;
import akka.http.javadsl.server.RouteResult;
import akka.http.javadsl.server.directives.CachingDirectives;
import akka.http.javadsl.unmarshalling.StringUnmarshallers;
import io.mantisrx.master.api.akka.route.Jackson;
import io.mantisrx.master.api.akka.route.handlers.JobClusterRouteHandler;
import io.mantisrx.master.api.akka.route.proto.JobClusterProtoAdapter;
import io.mantisrx.master.api.akka.route.v1.BaseRoute;
import io.mantisrx.master.api.akka.route.v1.HttpRequestMetrics;
import io.mantisrx.master.api.akka.route.v1.ParamName;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.master.jobcluster.proto.JobClusterManagerProto;
import io.mantisrx.runtime.NamedJobDefinition;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.config.MasterConfiguration;
import io.mantisrx.shaded.com.google.common.base.Strings;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.PartialFunction;

public class JobClustersRoute
extends BaseRoute {
    private static final Logger logger = LoggerFactory.getLogger(JobClustersRoute.class);
    private static final PathMatcher0 JOBCLUSTERS_API_PREFIX = PathMatchers.segment((String)"api").slash("v1").slash("jobClusters");
    private final JobClusterRouteHandler jobClusterRouteHandler;
    private final Cache<Uri, RouteResult> routeResultCache;

    public JobClustersRoute(JobClusterRouteHandler jobClusterRouteHandler, ActorSystem actorSystem) {
        this.jobClusterRouteHandler = jobClusterRouteHandler;
        MasterConfiguration config = ConfigurationProvider.getConfig();
        this.routeResultCache = this.createCache(actorSystem, config.getApiCacheMinSize(), config.getApiCacheMaxSize(), config.getApiCacheTtlMilliseconds());
    }

    @Override
    public Route constructRoutes() {
        return this.pathPrefix(JOBCLUSTERS_API_PREFIX, () -> this.concat(this.pathEndOrSingleSlash(() -> this.concat(this.get(this::getJobClustersRoute), new Route[]{this.post(this::postJobClustersRoute)})), new Route[]{this.path(PathMatchers.segment(), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.getJobClusterInstanceRoute((String)clusterName)), new Route[]{this.put(() -> this.putJobClusterInstanceRoute((String)clusterName)), this.delete(() -> this.deleteJobClusterInstanceRoute((String)clusterName))}))), this.path(PathMatchers.segment().slash("latestJobDiscoveryInfo"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.getLatestJobDiscoveryInfo((String)clusterName)), new Route[0]))), this.path(PathMatchers.segment().slash("actions").slash("updateArtifact"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.updateClusterArtifactRoute((String)clusterName)), new Route[0]))), this.path(PathMatchers.segment().slash("actions").slash("updateSchedulingInfo"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.updateClusterSchedulingInfo((String)clusterName)), new Route[0]))), this.pathPrefix(PathMatchers.segment().slash("actions").slash("updateSla"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.updateClusterSlaRoute((String)clusterName)), new Route[0]))), this.pathPrefix(PathMatchers.segment().slash("actions").slash("updateMigrationStrategy"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.updateMigrationStrategyRoute((String)clusterName)), new Route[0]))), this.pathPrefix(PathMatchers.segment().slash("actions").slash("updateLabel"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.updateJobClusterLabelRoute((String)clusterName)), new Route[0]))), this.pathPrefix(PathMatchers.segment().slash("actions").slash("enableCluster"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.updateJobClusterStateEnableRoute((String)clusterName)), new Route[0]))), this.pathPrefix(PathMatchers.segment().slash("actions").slash("disableCluster"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.updateJobClusterStateDisableRoute((String)clusterName)), new Route[0])))}));
    }

    @Override
    public Route createRoute(Function<Route, Route> routeFilter) {
        logger.info("creating /api/v1/jobClusters routes");
        return super.createRoute(routeFilter);
    }

    private Route getJobClustersRoute() {
        logger.trace("GET /api/v1/jobClusters called");
        return this.parameterMap(param -> CachingDirectives.alwaysCache(this.routeResultCache, (PartialFunction)this.getRequestUriKeyer, () -> this.extractUri(uri -> {
            logger.debug("GET all job clusters");
            return this.completeAsync(this.jobClusterRouteHandler.getAllJobClusters(new JobClusterManagerProto.ListJobClustersRequest()), resp -> this.completeOK(resp.getJobClusters(param.getOrDefault(ParamName.JOBCLUSTER_FILTER_MATCH, null), this.parseInteger(param.getOrDefault(ParamName.PAGINATION_LIMIT, null)), this.parseInteger(param.getOrDefault(ParamName.PAGINATION_OFFSET, null)), param.getOrDefault(ParamName.SORT_BY, null), this.parseBoolean(param.getOrDefault(ParamName.SORT_ASCENDING, null)), (Uri)uri), Jackson.marshaller(super.parseFilter(param.getOrDefault(ParamName.PROJECTION_FIELDS, null), null))), "api.v1.jobClusters", HttpRequestMetrics.HttpVerb.GET);
        })));
    }

    private Route postJobClustersRoute() {
        return this.entity(Jackson.unmarshaller(NamedJobDefinition.class), jobClusterDefn -> {
            CompletionStage response;
            logger.info("POST /api/v1/jobClusters called {}", jobClusterDefn);
            try {
                JobClusterManagerProto.CreateJobClusterRequest createJobClusterRequest = JobClusterProtoAdapter.toCreateJobClusterRequest(jobClusterDefn);
                response = this.jobClusterRouteHandler.create(createJobClusterRequest).thenCompose(t -> {
                    if (t.responseCode.getValue() >= 200 && t.responseCode.getValue() < 300) {
                        JobClusterManagerProto.GetJobClusterRequest request = new JobClusterManagerProto.GetJobClusterRequest(t.getJobClusterName());
                        return this.jobClusterRouteHandler.getJobClusterDetails(request);
                    }
                    CompletableFuture<JobClusterManagerProto.GetJobClusterResponse> responseCompletableFuture = new CompletableFuture<JobClusterManagerProto.GetJobClusterResponse>();
                    responseCompletableFuture.complete(new JobClusterManagerProto.GetJobClusterResponse(t.requestId, t.responseCode, t.message, Optional.empty()));
                    return responseCompletableFuture;
                });
            }
            catch (IllegalArgumentException ex) {
                CompletableFuture resp2 = new CompletableFuture();
                resp2.complete(new JobClusterManagerProto.GetJobClusterResponse(0L, BaseResponse.ResponseCode.CLIENT_ERROR, "Invalid request payload: " + ex.getMessage(), Optional.empty()));
                response = resp2;
            }
            return this.completeAsync(response, resp -> {
                HttpResponse httpResponse = this.toDefaultHttpResponse((BaseResponse)resp);
                return this.complete(httpResponse.status().equals(StatusCodes.OK) ? StatusCodes.CREATED : httpResponse.status(), resp.getJobCluster(), Jackson.marshaller());
            }, "api.v1.jobClusters", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route getLatestJobDiscoveryInfo(String clusterName) {
        logger.trace("GET /api/v1/jobClusters/{}/latestJobDiscoveryInfo called", (Object)clusterName);
        return this.parameterOptional(StringUnmarshallers.STRING, ParamName.PROJECTION_FIELDS, fields -> CachingDirectives.cache(this.routeResultCache, (PartialFunction)this.getRequestUriKeyer, () -> this.extractUri(uri -> {
            logger.debug("GET latest job discovery info for {}", (Object)clusterName);
            return this.completeAsync(this.jobClusterRouteHandler.getLatestJobDiscoveryInfo(new JobClusterManagerProto.GetLatestJobDiscoveryInfoRequest(clusterName)), resp -> {
                HttpResponse httpResponse = this.toDefaultHttpResponse((BaseResponse)resp);
                return this.complete(httpResponse.status(), resp.getDiscoveryInfo().orElse(null), Jackson.marshaller(super.parseFilter(fields.orElse(null), null)));
            }, "api.v1.jobClusters.instance.latestJobDiscoveryInfo", HttpRequestMetrics.HttpVerb.GET);
        })));
    }

    private Route getJobClusterInstanceRoute(String clusterName) {
        logger.info("GET /api/v1/jobClusters/{} called", (Object)clusterName);
        return this.parameterOptional(StringUnmarshallers.STRING, ParamName.PROJECTION_FIELDS, fields -> this.completeAsync(this.jobClusterRouteHandler.getJobClusterDetails(new JobClusterManagerProto.GetJobClusterRequest(clusterName)), resp -> {
            HttpResponse httpResponse = this.toDefaultHttpResponse((BaseResponse)resp);
            return this.complete(httpResponse.status(), resp.getJobCluster(), Jackson.marshaller(super.parseFilter(fields.orElse(null), null)));
        }, "api.v1.jobClusters.instance", HttpRequestMetrics.HttpVerb.GET));
    }

    private Route putJobClusterInstanceRoute(String clusterName) {
        return this.entity(Jackson.unmarshaller(NamedJobDefinition.class), jobClusterDefn -> {
            CompletionStage<Object> updateResponse;
            logger.info("PUT /api/v1/jobClusters/{} called {}", (Object)clusterName, jobClusterDefn);
            try {
                CompletableFuture<JobClusterManagerProto.UpdateJobClusterResponse> resp2 = new CompletableFuture<JobClusterManagerProto.UpdateJobClusterResponse>();
                JobClusterManagerProto.UpdateJobClusterRequest request = JobClusterProtoAdapter.toUpdateJobClusterRequest(jobClusterDefn);
                if (jobClusterDefn.getJobDefinition() == null) {
                    resp2.complete(new JobClusterManagerProto.UpdateJobClusterResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, "Invalid request payload."));
                    updateResponse = resp2;
                } else if (!clusterName.equals(jobClusterDefn.getJobDefinition().getName())) {
                    resp2.complete(new JobClusterManagerProto.UpdateJobClusterResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, String.format("Cluster name specified in request payload %s does not match with what specified in resource path %s", jobClusterDefn.getJobDefinition().getName(), clusterName)));
                    updateResponse = resp2;
                } else {
                    updateResponse = this.jobClusterRouteHandler.update(JobClusterProtoAdapter.toUpdateJobClusterRequest(jobClusterDefn));
                }
            }
            catch (IllegalArgumentException ex) {
                CompletableFuture<JobClusterManagerProto.UpdateJobClusterResponse> resp3 = new CompletableFuture<JobClusterManagerProto.UpdateJobClusterResponse>();
                resp3.complete(new JobClusterManagerProto.UpdateJobClusterResponse(0L, BaseResponse.ResponseCode.CLIENT_ERROR, "Invalid request payload: " + ex.getMessage()));
                updateResponse = resp3;
            }
            CompletionStage response = updateResponse.thenCompose(t -> {
                if (t.responseCode.getValue() >= 200 && t.responseCode.getValue() < 300) {
                    return this.jobClusterRouteHandler.getJobClusterDetails(new JobClusterManagerProto.GetJobClusterRequest(clusterName));
                }
                CompletableFuture<JobClusterManagerProto.GetJobClusterResponse> responseCompletableFuture = new CompletableFuture<JobClusterManagerProto.GetJobClusterResponse>();
                responseCompletableFuture.complete(new JobClusterManagerProto.GetJobClusterResponse(t.requestId, t.responseCode, t.message, Optional.empty()));
                return responseCompletableFuture;
            });
            return this.completeAsync(response, resp -> {
                HttpResponse httpResponse = this.toDefaultHttpResponse((BaseResponse)resp);
                return this.complete(httpResponse.status(), resp.getJobCluster(), Jackson.marshaller());
            }, "api.v1.jobClusters.instance", HttpRequestMetrics.HttpVerb.PUT);
        });
    }

    private Route deleteJobClusterInstanceRoute(String clusterName) {
        return this.parameterOptional("user", user -> {
            logger.info("DELETE /api/v1/jobClusters/{} called", (Object)clusterName);
            String userStr = user.orElse(null);
            if (Strings.isNullOrEmpty((String)userStr)) {
                return this.complete(StatusCodes.BAD_REQUEST, "Missing required parameter 'user'");
            }
            return this.completeAsync(this.jobClusterRouteHandler.delete(new JobClusterManagerProto.DeleteJobClusterRequest(userStr, clusterName)), resp -> this.complete(StatusCodes.ACCEPTED, ""), "api.v1.jobClusters.instance", HttpRequestMetrics.HttpVerb.DELETE);
        });
    }

    private Route updateClusterArtifactRoute(String clusterName) {
        return this.entity(Jackson.unmarshaller(JobClusterManagerProto.UpdateJobClusterArtifactRequest.class), request -> {
            CompletionStage<JobClusterManagerProto.UpdateJobClusterArtifactResponse> updateResponse;
            logger.info("POST /api/v1/jobClusters/{}/actions/updateArtifact called {}", (Object)clusterName, request);
            if (!clusterName.equals(request.getClusterName())) {
                CompletableFuture<JobClusterManagerProto.UpdateJobClusterArtifactResponse> resp2 = new CompletableFuture<JobClusterManagerProto.UpdateJobClusterArtifactResponse>();
                resp2.complete(new JobClusterManagerProto.UpdateJobClusterArtifactResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, String.format("Cluster name specified in request payload %s does not match with what specified in resource path %s", request.getClusterName(), clusterName)));
                updateResponse = resp2;
            } else {
                updateResponse = this.jobClusterRouteHandler.updateArtifact((JobClusterManagerProto.UpdateJobClusterArtifactRequest)request);
            }
            return this.completeAsync(updateResponse, resp -> this.complete(StatusCodes.NO_CONTENT, ""), "api.v1.jobClusters.instance.actions.updateArtifact", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route updateClusterSchedulingInfo(String clusterName) {
        return this.entity(Jackson.unmarshaller(JobClusterManagerProto.UpdateSchedulingInfoRequest.class), request -> {
            logger.info("POST /api/v1/jobClusters/{}/actions/updateSchedulingInfo called {}", (Object)clusterName, request);
            CompletionStage<JobClusterManagerProto.UpdateSchedulingInfoResponse> updateResponse = this.jobClusterRouteHandler.updateSchedulingInfo(clusterName, (JobClusterManagerProto.UpdateSchedulingInfoRequest)request);
            return this.completeAsync(updateResponse, resp -> this.complete(StatusCodes.NO_CONTENT, ""), "api.v1.jobClusters.instance.actions.updateArtifact", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route updateClusterSlaRoute(String clusterName) {
        return this.entity(Jackson.unmarshaller(JobClusterManagerProto.UpdateJobClusterSLARequest.class), request -> {
            CompletionStage<JobClusterManagerProto.UpdateJobClusterSLAResponse> updateResponse;
            logger.info("POST /api/v1/jobClusters/{}/actions/updateSla called {}", (Object)clusterName, request);
            if (!clusterName.equals(request.getClusterName())) {
                CompletableFuture<JobClusterManagerProto.UpdateJobClusterSLAResponse> resp2 = new CompletableFuture<JobClusterManagerProto.UpdateJobClusterSLAResponse>();
                resp2.complete(new JobClusterManagerProto.UpdateJobClusterSLAResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, String.format("Cluster name specified in request payload %s does not match with what specified in resource path %s", request.getClusterName(), clusterName)));
                updateResponse = resp2;
            } else {
                updateResponse = this.jobClusterRouteHandler.updateSLA((JobClusterManagerProto.UpdateJobClusterSLARequest)request);
            }
            return this.completeAsync(updateResponse, resp -> this.complete(StatusCodes.NO_CONTENT, ""), "api.v1.jobClusters.instance.actions.updateSla", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route updateMigrationStrategyRoute(String clusterName) {
        return this.entity(Jackson.unmarshaller(JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyRequest.class), request -> {
            CompletionStage<JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyResponse> updateResponse;
            logger.info("POST /api/v1/jobClusters/{}/actions/updateMigrationStrategy called {}", (Object)clusterName, request);
            if (!clusterName.equals(request.getClusterName())) {
                CompletableFuture<JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyResponse> resp2 = new CompletableFuture<JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyResponse>();
                resp2.complete(new JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, String.format("Cluster name specified in request payload %s does not match with what specified in resource path %s", request.getClusterName(), clusterName)));
                updateResponse = resp2;
            } else {
                updateResponse = this.jobClusterRouteHandler.updateWorkerMigrateStrategy((JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyRequest)request);
            }
            return this.completeAsync(updateResponse, resp -> this.complete(StatusCodes.NO_CONTENT, ""), "api.v1.jobClusters.instance.actions.updateMigrationStrategy", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route updateJobClusterLabelRoute(String clusterName) {
        return this.entity(Jackson.unmarshaller(JobClusterManagerProto.UpdateJobClusterLabelsRequest.class), request -> {
            CompletionStage<JobClusterManagerProto.UpdateJobClusterLabelsResponse> updateResponse;
            logger.info("POST /api/v1/jobClusters/{}/actions/updateLabel called {}", (Object)clusterName, request);
            if (!clusterName.equals(request.getClusterName())) {
                CompletableFuture<JobClusterManagerProto.UpdateJobClusterLabelsResponse> resp2 = new CompletableFuture<JobClusterManagerProto.UpdateJobClusterLabelsResponse>();
                resp2.complete(new JobClusterManagerProto.UpdateJobClusterLabelsResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, String.format("Cluster name specified in request payload %s does not match with what specified in resource path %s", request.getClusterName(), clusterName)));
                updateResponse = resp2;
            } else {
                updateResponse = this.jobClusterRouteHandler.updateLabels((JobClusterManagerProto.UpdateJobClusterLabelsRequest)request);
            }
            return this.completeAsync(updateResponse, resp -> this.complete(StatusCodes.NO_CONTENT, ""), "api.v1.jobClusters.instance.actions.updateLabel", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route updateJobClusterStateEnableRoute(String clusterName) {
        return this.entity(Jackson.unmarshaller(JobClusterManagerProto.EnableJobClusterRequest.class), request -> {
            CompletionStage<JobClusterManagerProto.EnableJobClusterResponse> updateResponse;
            logger.info("POST /api/v1/jobClusters/{}/actions/enableCluster called {}", (Object)clusterName, request);
            if (!clusterName.equals(request.getClusterName())) {
                CompletableFuture<JobClusterManagerProto.EnableJobClusterResponse> resp2 = new CompletableFuture<JobClusterManagerProto.EnableJobClusterResponse>();
                resp2.complete(new JobClusterManagerProto.EnableJobClusterResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, String.format("Cluster name specified in request payload %s does not match with what specified in resource path %s", request.getClusterName(), clusterName)));
                updateResponse = resp2;
            } else {
                updateResponse = this.jobClusterRouteHandler.enable((JobClusterManagerProto.EnableJobClusterRequest)request);
            }
            return this.completeAsync(updateResponse, resp -> this.complete(StatusCodes.NO_CONTENT, ""), "api.v1.jobClusters.instance.actions.enableCluster", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route updateJobClusterStateDisableRoute(String clusterName) {
        return this.entity(Jackson.unmarshaller(JobClusterManagerProto.DisableJobClusterRequest.class), request -> {
            CompletionStage<JobClusterManagerProto.DisableJobClusterResponse> updateResponse;
            logger.info("POST /api/v1/jobClusters/{}/actions/disableCluster called {}", (Object)clusterName, request);
            if (!clusterName.equals(request.getClusterName())) {
                CompletableFuture<JobClusterManagerProto.DisableJobClusterResponse> resp2 = new CompletableFuture<JobClusterManagerProto.DisableJobClusterResponse>();
                resp2.complete(new JobClusterManagerProto.DisableJobClusterResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, String.format("Cluster name specified in request payload %s does not match with what specified in resource path %s", request.getClusterName(), clusterName)));
                updateResponse = resp2;
            } else {
                updateResponse = this.jobClusterRouteHandler.disable((JobClusterManagerProto.DisableJobClusterRequest)request);
            }
            return this.completeAsync(updateResponse, resp -> this.complete(StatusCodes.NO_CONTENT, ""), "api.v1.jobClusters.instance.actions.disableCluster", HttpRequestMetrics.HttpVerb.POST);
        });
    }
}

