/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.events;

import io.mantisrx.master.events.AuditEventSubscriber;
import io.mantisrx.master.events.LifecycleEventPublisher;
import io.mantisrx.master.events.LifecycleEventsProto;
import io.mantisrx.master.events.StatusEventSubscriber;
import io.mantisrx.master.events.WorkerEventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleEventPublisherImpl
implements LifecycleEventPublisher {
    private static final Logger log = LoggerFactory.getLogger(LifecycleEventPublisherImpl.class);
    private final AuditEventSubscriber auditEventSubscriber;
    private final StatusEventSubscriber statusEventSubscriber;
    private final WorkerEventSubscriber workerEventSubscriber;

    public LifecycleEventPublisherImpl(AuditEventSubscriber auditEventSubscriber, StatusEventSubscriber statusEventSubscriber, WorkerEventSubscriber workerEventSubscriber) {
        this.auditEventSubscriber = auditEventSubscriber;
        this.statusEventSubscriber = statusEventSubscriber;
        this.workerEventSubscriber = workerEventSubscriber;
    }

    @Override
    public void publishAuditEvent(LifecycleEventsProto.AuditEvent auditEvent) {
        this.auditEventSubscriber.process(auditEvent);
    }

    @Override
    public void publishStatusEvent(LifecycleEventsProto.StatusEvent statusEvent) {
        try {
            this.statusEventSubscriber.process(statusEvent);
            if (statusEvent instanceof LifecycleEventsProto.JobStatusEvent) {
                LifecycleEventsProto.JobStatusEvent jobStatusEvent = (LifecycleEventsProto.JobStatusEvent)statusEvent;
                this.workerEventSubscriber.process(jobStatusEvent);
            } else if (statusEvent instanceof LifecycleEventsProto.WorkerStatusEvent) {
                this.workerEventSubscriber.process((LifecycleEventsProto.WorkerStatusEvent)statusEvent);
            }
        }
        catch (Exception e) {
            log.error("Failed to publish the event={}; Ignoring the failure as this is just a listener interface", (Object)statusEvent, (Object)e);
        }
    }

    @Override
    public void publishWorkerListChangedEvent(LifecycleEventsProto.WorkerListChangedEvent workerListChangedEvent) {
        this.workerEventSubscriber.process(workerListChangedEvent);
    }
}

