/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.events;

import akka.actor.Props;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.master.events.LifecycleEventsProto;
import io.mantisrx.master.events.WorkerEventSubscriber;
import io.mantisrx.master.jobcluster.job.JobState;
import io.mantisrx.master.jobcluster.job.worker.IMantisWorkerMetadata;
import io.mantisrx.master.jobcluster.job.worker.WorkerState;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.scheduler.WorkerRegistry;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerRegistryV2
implements WorkerRegistry,
WorkerEventSubscriber {
    private final Logger logger = LoggerFactory.getLogger(WorkerRegistryV2.class);
    private final ConcurrentMap<JobId, List<IMantisWorkerMetadata>> jobToWorkerInfoMap = new ConcurrentHashMap<JobId, List<IMantisWorkerMetadata>>();
    public static final WorkerRegistryV2 INSTANCE = new WorkerRegistryV2();
    private final Metrics metrics;
    private final Counter numStatusEvents;

    public static Props props() {
        return Props.create(WorkerRegistryV2.class, (Object[])new Object[0]);
    }

    WorkerRegistryV2() {
        this.logger.info("WorkerRegistryV2 created");
        Metrics m = new Metrics.Builder().id("WorkerRegistryMetrics", new Tag[0]).addCounter("numStatusEvents").build();
        this.metrics = MetricsRegistry.getInstance().registerAndGet(m);
        this.numStatusEvents = this.metrics.getCounter("numStatusEvents");
    }

    @Override
    public int getNumRunningWorkers(@Nullable ClusterID resourceCluster) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("In getNumRunningWorkers");
        }
        int cnt = this.jobToWorkerInfoMap.values().stream().map(workerList -> workerList.stream().filter(wm -> Optional.ofNullable(resourceCluster).equals(wm.getResourceCluster())).filter(wm -> WorkerState.isRunningState(wm.getState())).collect(Collectors.toList()).size()).reduce(0, (a, b) -> a + b);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Returning {} from getNumRunningWorkers", (Object)cnt);
        }
        return cnt;
    }

    @Override
    public Set<WorkerId> getAllRunningWorkers(@Nullable ClusterID resourceCluster) {
        return this.jobToWorkerInfoMap.values().stream().flatMap(workerList -> workerList.stream().filter(wm -> Optional.ofNullable(resourceCluster).equals(wm.getResourceCluster())).filter(wm -> WorkerState.isRunningState(wm.getState())).map(workerMeta -> workerMeta.getWorkerId())).collect(Collectors.toSet());
    }

    @Override
    public Map<WorkerId, String> getAllRunningWorkerSlaveIdMappings(@Nullable ClusterID resourceCluster) {
        return this.jobToWorkerInfoMap.values().stream().flatMap(workerList -> workerList.stream().filter(wm -> Optional.ofNullable(resourceCluster).equals(wm.getResourceCluster())).filter(wm -> WorkerState.isRunningState(wm.getState()))).collect(Collectors.toMap(IMantisWorkerMetadata::getWorkerId, IMantisWorkerMetadata::getSlaveID, (s1, s2) -> s1 != null ? s1 : s2));
    }

    @Override
    public boolean isWorkerValid(WorkerId workerId) {
        Optional<JobId> jIdOp;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("In isWorkerValid event {}", (Object)workerId);
        }
        if (!(jIdOp = JobId.fromId(workerId.getJobId())).isPresent()) {
            this.logger.warn("Invalid job Id {}", (Object)workerId.getJobId());
            return false;
        }
        List mantisWorkerMetadataList = (List)this.jobToWorkerInfoMap.get(jIdOp.get());
        boolean isValid = false;
        if (mantisWorkerMetadataList != null) {
            isValid = mantisWorkerMetadataList.stream().anyMatch(mData -> mData.getWorkerId().equals((Object)workerId));
        } else {
            this.logger.warn("No such job {} found in job To worker map ", (Object)jIdOp.get());
        }
        return isValid;
    }

    @Override
    public Optional<Long> getAcceptedAt(WorkerId workerId) {
        Optional<IMantisWorkerMetadata> mantisWorkerMetadata;
        Optional<JobId> jId;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("In getAcceptedAt for worker {}", (Object)workerId);
        }
        if (!(jId = JobId.fromId(workerId.getJobId())).isPresent()) {
            return Optional.empty();
        }
        List mantisWorkerMetadataList = (List)this.jobToWorkerInfoMap.get(jId.get());
        if (mantisWorkerMetadataList != null && (mantisWorkerMetadata = mantisWorkerMetadataList.stream().filter(mData -> mData.getWorkerId().equals((Object)workerId)).findAny()).isPresent()) {
            this.logger.info("Found worker {} return acceptedAt {}", (Object)workerId, (Object)mantisWorkerMetadata.get().getAcceptedAt());
            return Optional.of(mantisWorkerMetadata.get().getAcceptedAt());
        }
        return Optional.empty();
    }

    private boolean deregisterJob(JobId jobId) {
        this.logger.info("De-registering {}", (Object)jobId);
        return this.jobToWorkerInfoMap.remove(jobId) != null;
    }

    @Override
    public void process(LifecycleEventsProto.WorkerListChangedEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("on WorkerListChangedEvent for job {} with workers {}", (Object)event.getWorkerInfoListHolder().getJobId(), (Object)event.getWorkerInfoListHolder().getWorkerMetadataList().size());
        }
        JobId jId = event.getWorkerInfoListHolder().getJobId();
        this.jobToWorkerInfoMap.put(jId, event.getWorkerInfoListHolder().getWorkerMetadataList());
    }

    @Override
    public void process(LifecycleEventsProto.JobStatusEvent statusEvent) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("In JobStatusEvent {}", (Object)statusEvent);
        }
        this.numStatusEvents.increment();
        JobState jobState = statusEvent.getJobState();
        if (JobState.isTerminalState(jobState)) {
            JobId jobId = statusEvent.getJobId();
            this.deregisterJob(jobId);
        }
    }

    @Override
    public void process(LifecycleEventsProto.WorkerStatusEvent workerStatusEvent) {
        this.numStatusEvents.increment();
    }
}

