/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.Label;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.spectator.GaugeCallback;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import io.mantisrx.master.jobcluster.ICompletedJobsStore;
import io.mantisrx.master.jobcluster.JobClusterActor;
import io.mantisrx.master.jobcluster.job.IMantisJobMetadata;
import io.mantisrx.master.jobcluster.job.JobState;
import io.mantisrx.server.master.domain.JobClusterDefinitionImpl;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.persistence.MantisJobStore;
import io.mantisrx.shaded.com.google.common.annotations.VisibleForTesting;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.Instant;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompletedJobStore
implements ICompletedJobsStore {
    private final Logger logger = LoggerFactory.getLogger(CompletedJobStore.class);
    private final Set<JobClusterDefinitionImpl.CompletedJob> terminalSortedJobSet = new TreeSet<JobClusterDefinitionImpl.CompletedJob>(Comparator.comparingLong(JobClusterDefinitionImpl.CompletedJob::getSubmittedAt).reversed().thenComparing(JobClusterDefinitionImpl.CompletedJob::getJobId));
    private final String name;
    private final Map<JobId, CompletedJobEntry> completedJobs = new HashMap<JobId, CompletedJobEntry>();
    private final JobClusterActor.LabelCache labelsCache;
    private final MantisJobStore jobStore;
    private final int initialNumberOfJobsToCache;
    private JobId cachedUpto;
    private final Metrics metrics;

    @VisibleForTesting
    CompletedJobStore(String clusterName, JobClusterActor.LabelCache labelsCache, MantisJobStore jobStore, int initialNumberOfJobsToCache) {
        this.name = clusterName;
        this.labelsCache = labelsCache;
        this.jobStore = jobStore;
        this.initialNumberOfJobsToCache = initialNumberOfJobsToCache;
        MetricGroupId metricGroupId = this.getMetricGroupId(this.name);
        Metrics m = new Metrics.Builder().id(metricGroupId).addGauge((Gauge)new GaugeCallback(metricGroupId, "completedJobsGauge", () -> 1.0 * (double)this.getCachedSize())).build();
        this.metrics = MetricsRegistry.getInstance().registerAndGet(m);
    }

    public CompletedJobStore(String clusterName, JobClusterActor.LabelCache labelsCache, MantisJobStore jobStore) {
        this(clusterName, labelsCache, jobStore, 100);
    }

    MetricGroupId getMetricGroupId(String name) {
        return new MetricGroupId("CompletedJobStore", new Tag[]{new BasicTag("jobCluster", name)});
    }

    private int getCachedSize() {
        return this.completedJobs.size();
    }

    @Override
    public void initialize() throws IOException {
        this.logger.info("Initializing completed jobs for cluster {}", (Object)this.name);
        List<JobClusterDefinitionImpl.CompletedJob> completedJobsList = this.jobStore.loadCompletedJobsForCluster(this.name, this.initialNumberOfJobsToCache, null);
        if (completedJobsList.isEmpty()) {
            this.cachedUpto = null;
        } else {
            this.addCompletedJobsToCache(completedJobsList);
            this.cachedUpto = JobId.fromId(completedJobsList.get(completedJobsList.size() - 1).getJobId()).orElse(null);
        }
    }

    @Override
    public Optional<JobClusterDefinitionImpl.CompletedJob> getCompletedJob(JobId jId) throws IOException {
        CompletedJobEntry res = this.fetchJobId(jId);
        if (res != null) {
            return Optional.of(res.getJob());
        }
        return Optional.empty();
    }

    private CompletedJobEntry fetchJobId(JobId jId) {
        return this.completedJobs.computeIfAbsent(jId, k -> {
            Optional<IMantisJobMetadata> jobMetadata = this.jobStore.getArchivedJob(jId.getId());
            return jobMetadata.map(mantisJobMetadata -> new CompletedJobEntry(this.fromMantisJobMetadata((IMantisJobMetadata)mantisJobMetadata), (IMantisJobMetadata)mantisJobMetadata)).orElse(null);
        });
    }

    @Override
    public Optional<IMantisJobMetadata> getJobMetadata(JobId jId) throws IOException {
        CompletedJobEntry res = this.fetchJobId(jId);
        if (res != null) {
            return Optional.ofNullable(res.getJobMetadata());
        }
        return Optional.empty();
    }

    @Override
    public List<JobClusterDefinitionImpl.CompletedJob> getCompletedJobs(int limit) throws IOException {
        if (this.getCachedSize() < limit) {
            List<JobClusterDefinitionImpl.CompletedJob> completedJobsList = this.jobStore.loadCompletedJobsForCluster(this.name, limit - this.getCachedSize(), this.cachedUpto);
            this.addCompletedJobsToCache(completedJobsList);
        }
        return this.terminalSortedJobSet.stream().limit(limit).collect(Collectors.toList());
    }

    @Override
    public List<JobClusterDefinitionImpl.CompletedJob> getCompletedJobs(int limit, JobId startExclusive) throws IOException {
        List<JobClusterDefinitionImpl.CompletedJob> completedJobsList = this.jobStore.loadCompletedJobsForCluster(this.name, limit, startExclusive);
        this.addCompletedJobsToCache(completedJobsList);
        return this.terminalSortedJobSet.stream().filter(job -> JobId.fromId(job.getJobId()).get().getJobNum() < startExclusive.getJobNum()).limit(limit).collect(Collectors.toList());
    }

    public Set<JobId> getJobIdsMatchingLabels(List<Label> labelList, boolean isAnd) {
        return this.labelsCache.getJobIdsMatchingLabels(labelList, isAnd);
    }

    private JobClusterDefinitionImpl.CompletedJob fromMantisJobMetadata(IMantisJobMetadata jobMetadata) {
        return new JobClusterDefinitionImpl.CompletedJob(this.name, jobMetadata.getJobId().getId(), jobMetadata.getJobDefinition().getVersion(), jobMetadata.getState(), jobMetadata.getSubmittedAtInstant().toEpochMilli(), jobMetadata.getEndedAtInstant().orElse(Instant.ofEpochMilli(0L)).toEpochMilli(), jobMetadata.getUser(), jobMetadata.getLabels());
    }

    @Override
    public JobClusterDefinitionImpl.CompletedJob onJobCompletion(IMantisJobMetadata jobMetadata) throws IOException {
        JobId jobId = jobMetadata.getJobId();
        if (!this.completedJobs.containsKey(jobId)) {
            JobClusterDefinitionImpl.CompletedJob completedJob = this.fromMantisJobMetadata(jobMetadata);
            this.jobStore.storeCompletedJobForCluster(this.name, completedJob);
            this.addCompletedJobToCache(completedJob, jobMetadata);
            return completedJob;
        }
        this.logger.warn("Job {}  already marked completed", (Object)jobId);
        return this.completedJobs.get(jobId).getJob();
    }

    @Override
    public JobClusterDefinitionImpl.CompletedJob onJobCompletion(JobId jId, long submittedAt, long completionTime, String user, String version, JobState finalState, List<Label> labels) throws IOException {
        JobClusterDefinitionImpl.CompletedJob completedJob = new JobClusterDefinitionImpl.CompletedJob(this.name, jId.getId(), version, finalState, submittedAt, completionTime, user, labels);
        this.jobStore.storeCompletedJobForCluster(this.name, completedJob);
        this.addCompletedJobToCache(completedJob, null);
        return completedJob;
    }

    @Override
    public void onJobClusterDeletion() throws IOException {
        List<JobClusterDefinitionImpl.CompletedJob> jobs = this.jobStore.loadCompletedJobsForCluster(this.name, 100, null);
        while (!jobs.isEmpty()) {
            for (JobClusterDefinitionImpl.CompletedJob completedJob : jobs) {
                try {
                    this.jobStore.deleteJob(completedJob.getJobId());
                }
                catch (IOException e) {
                    this.logger.error("Unable to purge job", (Throwable)e);
                }
            }
            jobs = this.jobStore.loadCompletedJobsForCluster(this.name, 100, JobId.fromId(jobs.get(jobs.size() - 1).getJobId()).get());
        }
        this.jobStore.deleteCompletedJobsForCluster(this.name);
        this.completedJobs.forEach((jobId, tuple) -> {
            if (tuple.getJobMetadata() != null) {
                this.labelsCache.removeJobIdFromLabelCache(tuple.getJobMetadata().getJobId());
            }
        });
        this.completedJobs.clear();
        this.terminalSortedJobSet.clear();
        this.cachedUpto = null;
    }

    private void addCompletedJobToCache(JobClusterDefinitionImpl.CompletedJob completedJob, @Nullable IMantisJobMetadata jobMetaData) {
        JobId jobId = JobId.fromId(completedJob.getJobId()).get();
        this.labelsCache.addJobIdToLabelCache(jobId, completedJob.getLabelList());
        this.completedJobs.put(jobId, new CompletedJobEntry(completedJob, jobMetaData));
        this.terminalSortedJobSet.add(completedJob);
    }

    private void addCompletedJobsToCache(List<JobClusterDefinitionImpl.CompletedJob> completedJobsList) {
        if (!completedJobsList.isEmpty()) {
            Map<JobId, CompletedJobEntry> cache = completedJobsList.stream().flatMap(compJob -> {
                Optional<IMantisJobMetadata> jobMetadata = this.jobStore.getArchivedJob(compJob.getJobId());
                if (jobMetadata.isPresent()) {
                    return Stream.of(new CompletedJobEntry((JobClusterDefinitionImpl.CompletedJob)compJob, jobMetadata.get()));
                }
                return Stream.empty();
            }).collect(Collectors.toMap(tuple -> JobId.fromId(tuple.getJob().getJobId()).get(), tuple -> tuple, (a, b) -> a));
            this.terminalSortedJobSet.addAll(cache.values().stream().map(CompletedJobEntry::getJob).collect(Collectors.toList()));
            this.completedJobs.putAll(cache);
            cache.values().stream().map(CompletedJobEntry::getJob).forEach(compJob -> {
                Optional<JobId> jId = JobId.fromId(compJob.getJobId());
                if (jId.isPresent()) {
                    this.labelsCache.addJobIdToLabelCache(jId.get(), compJob.getLabelList());
                } else {
                    this.logger.warn("Invalid job Id {}", (Object)compJob.getJobId());
                }
            });
            Optional<JobId> lastJobId = JobId.fromId(completedJobsList.get(completedJobsList.size() - 1).getJobId());
            lastJobId.ifPresent(jobId -> {
                this.cachedUpto = jobId;
            });
        }
    }

    public boolean containsKey(JobId jobId) {
        return this.completedJobs.containsKey(jobId);
    }

    private static final class CompletedJobEntry {
        private final JobClusterDefinitionImpl.CompletedJob job;
        @Nullable
        private final IMantisJobMetadata jobMetadata;

        @ConstructorProperties(value={"job", "jobMetadata"})
        public CompletedJobEntry(JobClusterDefinitionImpl.CompletedJob job, @Nullable IMantisJobMetadata jobMetadata) {
            this.job = job;
            this.jobMetadata = jobMetadata;
        }

        public JobClusterDefinitionImpl.CompletedJob getJob() {
            return this.job;
        }

        @Nullable
        public IMantisJobMetadata getJobMetadata() {
            return this.jobMetadata;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompletedJobEntry)) {
                return false;
            }
            CompletedJobEntry other = (CompletedJobEntry)o;
            JobClusterDefinitionImpl.CompletedJob this$job = this.getJob();
            JobClusterDefinitionImpl.CompletedJob other$job = other.getJob();
            if (this$job == null ? other$job != null : !((Object)this$job).equals(other$job)) {
                return false;
            }
            IMantisJobMetadata this$jobMetadata = this.getJobMetadata();
            IMantisJobMetadata other$jobMetadata = other.getJobMetadata();
            return !(this$jobMetadata == null ? other$jobMetadata != null : !this$jobMetadata.equals(other$jobMetadata));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JobClusterDefinitionImpl.CompletedJob $job = this.getJob();
            result = result * 59 + ($job == null ? 43 : ((Object)$job).hashCode());
            IMantisJobMetadata $jobMetadata = this.getJobMetadata();
            result = result * 59 + ($jobMetadata == null ? 43 : $jobMetadata.hashCode());
            return result;
        }

        public String toString() {
            return "CompletedJobStore.CompletedJobEntry(job=" + this.getJob() + ", jobMetadata=" + this.getJobMetadata() + ")";
        }
    }
}

