/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster;

import io.mantisrx.master.jobcluster.JobClusterActor;
import io.mantisrx.server.master.domain.JobClusterDefinitionImpl;
import io.mantisrx.server.master.domain.JobId;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobListHelper {
    private static final Logger logger = LoggerFactory.getLogger(JobListHelper.class);

    public static Optional<JobId> getLastSubmittedJobId(List<JobClusterActor.JobInfo> existingJobsList, List<JobClusterDefinitionImpl.CompletedJob> completedJobs) {
        if (logger.isTraceEnabled()) {
            logger.trace("Entering getLastSubmittedJobDefinition existing jobs {} completedJobs {}", (Object)existingJobsList.size(), (Object)completedJobs.size());
        }
        long highestJobNumber = -1L;
        JobClusterActor.JobInfo jInfoWithHighestJobNumber = null;
        JobClusterDefinitionImpl.CompletedJob completedJobWithHighestJobNumber = null;
        if (logger.isDebugEnabled()) {
            logger.debug("No of active jobs: {}", (Object)existingJobsList.size());
        }
        for (JobClusterActor.JobInfo jInfo : existingJobsList) {
            if (jInfo.jobId.getJobNum() <= highestJobNumber) continue;
            highestJobNumber = jInfo.jobId.getJobNum();
            jInfoWithHighestJobNumber = jInfo;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Highest Active job number: {}", (Object)highestJobNumber);
        }
        if (highestJobNumber != -1L) {
            return Optional.ofNullable(jInfoWithHighestJobNumber.jobId);
        }
        for (JobClusterDefinitionImpl.CompletedJob cJob : completedJobs) {
            Optional<JobId> completedJobId = JobId.fromId(cJob.getJobId());
            if (!completedJobId.isPresent() || completedJobId.get().getJobNum() <= highestJobNumber) continue;
            highestJobNumber = completedJobId.get().getJobNum();
            completedJobWithHighestJobNumber = cJob;
        }
        if (highestJobNumber != -1L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Highest completed job number: {}", (Object)highestJobNumber);
            }
            return JobId.fromId(completedJobWithHighestJobNumber.getJobId());
        }
        return Optional.empty();
    }
}

