/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster;

import com.netflix.spectator.impl.Preconditions;
import io.mantisrx.common.Label;
import io.mantisrx.runtime.JobOwner;
import io.mantisrx.runtime.WorkerMigrationConfig;
import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.server.master.domain.DataFormatAdapter;
import io.mantisrx.server.master.domain.JobClusterConfig;
import io.mantisrx.server.master.domain.SLA;
import io.mantisrx.server.master.store.NamedJob;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonFilter;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;

@JsonFilter(value="topLevelFilter")
public class MantisJobClusterMetadataView {
    private final String name;
    private final List<NamedJob.Jar> jars;
    private final NamedJob.SLA sla;
    private final List<Parameter> parameters;
    private final JobOwner owner;
    private final long lastJobCount;
    private final boolean disabled;
    private final boolean isReadyForJobMaster;
    private final WorkerMigrationConfig migrationConfig;
    private final List<Label> labels;
    private final boolean cronActive;
    @JsonIgnore
    private final String latestVersion;

    @JsonCreator
    public MantisJobClusterMetadataView(@JsonProperty(value="name") String name, @JsonProperty(value="jars") List<NamedJob.Jar> jars, @JsonProperty(value="sla") NamedJob.SLA sla, @JsonProperty(value="parameters") List<Parameter> parameters, @JsonProperty(value="owner") JobOwner owner, @JsonProperty(value="lastJobCount") long lastJobCount, @JsonProperty(value="disabled") boolean disabled, @JsonProperty(value="isReadyForJobMaster") boolean isReadyForJobMaster, @JsonProperty(value="migrationConfig") WorkerMigrationConfig migrationConfig, @JsonProperty(value="labels") List<Label> labels, @JsonProperty(value="cronActive") boolean cronActive, @JsonProperty(value="latestVersion") String latestVersion) {
        this.name = name;
        this.jars = jars;
        this.sla = sla;
        this.parameters = parameters;
        this.owner = owner;
        this.lastJobCount = lastJobCount;
        this.disabled = disabled;
        this.isReadyForJobMaster = isReadyForJobMaster;
        this.migrationConfig = migrationConfig;
        this.labels = labels;
        this.cronActive = cronActive;
        this.latestVersion = latestVersion;
    }

    public String getName() {
        return this.name;
    }

    public List<NamedJob.Jar> getJars() {
        return this.jars;
    }

    public NamedJob.SLA getSla() {
        return this.sla;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public JobOwner getOwner() {
        return this.owner;
    }

    public long getLastJobCount() {
        return this.lastJobCount;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean getIsReadyForJobMaster() {
        return this.isReadyForJobMaster;
    }

    public WorkerMigrationConfig getMigrationConfig() {
        return this.migrationConfig;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public boolean isCronActive() {
        return this.cronActive;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MantisJobClusterMetadataView that = (MantisJobClusterMetadataView)o;
        return this.lastJobCount == that.lastJobCount && this.disabled == that.disabled && this.isReadyForJobMaster == that.isReadyForJobMaster && this.cronActive == that.cronActive && Objects.equals(this.name, that.name) && Objects.equals(this.jars, that.jars) && Objects.equals(this.sla, that.sla) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.owner, that.owner) && Objects.equals(this.migrationConfig, that.migrationConfig) && Objects.equals(this.labels, that.labels) && Objects.equals(this.latestVersion, that.latestVersion);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.jars, this.sla, this.parameters, this.owner, this.lastJobCount, this.disabled, this.isReadyForJobMaster, this.migrationConfig, this.labels, this.cronActive, this.latestVersion);
    }

    public String toString() {
        return "MantisJobClusterMetadataView{name='" + this.name + '\'' + ", jars=" + this.jars + ", sla=" + this.sla + ", parameters=" + this.parameters + ", owner=" + this.owner + ", lastJobCount=" + this.lastJobCount + ", disabled=" + this.disabled + ", isReadyForJobMaster=" + this.isReadyForJobMaster + ", migrationConfig=" + this.migrationConfig + ", labels=" + this.labels + ", cronActive=" + this.cronActive + ", latestVersion='" + this.latestVersion + '\'' + '}';
    }

    public static class Builder {
        private String name;
        private List<NamedJob.Jar> jars = Lists.newArrayList();
        private NamedJob.SLA sla;
        private List<Parameter> parameters = Lists.newArrayList();
        private JobOwner owner;
        private long lastJobCount;
        private boolean disabled = false;
        private boolean isReadyForJobMaster = true;
        private WorkerMigrationConfig migrationConfig;
        private List<Label> labels = Lists.newArrayList();
        private boolean cronActive = false;
        private String latestVersion;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withJars(List<JobClusterConfig> jars) {
            this.jars = DataFormatAdapter.convertJobClusterConfigsToJars(jars);
            return this;
        }

        public Builder withSla(SLA sla) {
            this.sla = DataFormatAdapter.convertSLAToNamedJobSLA(sla);
            return this;
        }

        public Builder withParameters(List<Parameter> params) {
            this.parameters = params;
            return this;
        }

        public Builder withJobOwner(JobOwner owner) {
            this.owner = owner;
            return this;
        }

        public Builder withLastJobCount(long cnt) {
            this.lastJobCount = cnt;
            return this;
        }

        public Builder withDisabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder withIsReadyForJobMaster(boolean isReadyForJobMaster) {
            this.isReadyForJobMaster = isReadyForJobMaster;
            return this;
        }

        public Builder withMigrationConfig(WorkerMigrationConfig config) {
            this.migrationConfig = config;
            return this;
        }

        public Builder withLabels(List<Label> labels) {
            this.labels = labels;
            return this;
        }

        public Builder isCronActive(boolean cronActive) {
            this.cronActive = cronActive;
            return this;
        }

        public Builder withLatestVersion(String version) {
            this.latestVersion = version;
            return this;
        }

        public MantisJobClusterMetadataView build() {
            Preconditions.checkNotNull((Object)this.name, (String)"name cannot be null");
            Preconditions.checkNotNull(this.jars, (String)"Jars cannot be null");
            Preconditions.checkArg((!this.jars.isEmpty() ? 1 : 0) != 0, (String)"Jars cannot be empty");
            Preconditions.checkNotNull((Object)this.latestVersion, (String)"version cannot be null");
            return new MantisJobClusterMetadataView(this.name, this.jars, this.sla, this.parameters, this.owner, this.lastJobCount, this.disabled, this.isReadyForJobMaster, this.migrationConfig, this.labels, this.cronActive, this.latestVersion);
        }
    }
}

