/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster.job;

import java.util.HashMap;
import java.util.Map;

public enum JobState {
    Accepted,
    Launched,
    Terminating_abnormal,
    Terminating_normal,
    Failed,
    Completed,
    Noop;

    private static final Map<JobState, JobState[]> VALID_CHANGES;
    private static final Map<JobState, MetaState> META_STATES;

    public static MetaState toMetaState(JobState state) {
        return META_STATES.get((Object)state);
    }

    public boolean isValidStateChgTo(JobState newState) {
        for (JobState validState : VALID_CHANGES.get((Object)this)) {
            if (validState != newState) continue;
            return true;
        }
        return false;
    }

    public static boolean isTerminalState(JobState state) {
        switch (state) {
            case Failed: 
            case Completed: 
            case Terminating_normal: 
            case Terminating_abnormal: {
                return true;
            }
        }
        return false;
    }

    public boolean isTerminal() {
        return JobState.isTerminalState(this);
    }

    public static boolean isErrorState(JobState started) {
        switch (started) {
            case Failed: 
            case Terminating_abnormal: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRunningState(JobState state) {
        switch (state) {
            case Launched: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAcceptedState(JobState state) {
        switch (state) {
            case Accepted: {
                return true;
            }
        }
        return false;
    }

    static {
        VALID_CHANGES = new HashMap<JobState, JobState[]>();
        VALID_CHANGES.put(Accepted, new JobState[]{Accepted, Launched, Terminating_abnormal, Terminating_normal, Failed, Completed});
        VALID_CHANGES.put(Launched, new JobState[]{Launched, Terminating_abnormal, Terminating_normal, Failed, Completed});
        VALID_CHANGES.put(Terminating_abnormal, new JobState[]{Terminating_abnormal, Failed});
        VALID_CHANGES.put(Terminating_normal, new JobState[]{Terminating_normal, Completed});
        VALID_CHANGES.put(Failed, new JobState[0]);
        VALID_CHANGES.put(Completed, new JobState[0]);
        META_STATES = new HashMap<JobState, MetaState>();
        META_STATES.put(Accepted, MetaState.Active);
        META_STATES.put(Launched, MetaState.Active);
        META_STATES.put(Failed, MetaState.Terminal);
        META_STATES.put(Completed, MetaState.Terminal);
        META_STATES.put(Terminating_abnormal, MetaState.Terminal);
        META_STATES.put(Terminating_normal, MetaState.Terminal);
    }

    public static enum MetaState {
        Active,
        Terminal;

    }
}

