/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster.job;

import com.netflix.spectator.impl.Preconditions;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.config.ConfigurationProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkerResubmitRateLimiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkerResubmitRateLimiter.class);
    private static final String DEFAULT_WORKER_RESUBMIT_INTERVAL_SECS_STR = "5:10:20";
    private final Map<String, ResubmitRecord> resubmitRecords = new HashMap<String, ResubmitRecord>();
    private static final long DEFAULT_EXPIRE_RESUBMIT_DELAY_SECS = 300L;
    private static final long DEFAULT_EXPIRE_RESUBMIT_DELAY_EXECUTION_INTERVAL_SECS = 120L;
    private static final long DEFAULT_RESUBMISSION_INTERVAL_SECS = 10L;
    private final long expireResubmitDelaySecs;
    private final long[] resubmitIntervalSecs;

    WorkerResubmitRateLimiter(String workerResubmitIntervalSecs, long expireResubmitDelaySecs) {
        StringTokenizer tokenizer;
        Preconditions.checkArg((expireResubmitDelaySecs > 0L ? 1 : 0) != 0, (String)"Expire Resubmit Delay cannot be 0 or less");
        if (workerResubmitIntervalSecs == null || workerResubmitIntervalSecs.isEmpty()) {
            workerResubmitIntervalSecs = DEFAULT_WORKER_RESUBMIT_INTERVAL_SECS_STR;
        }
        if ((tokenizer = new StringTokenizer(workerResubmitIntervalSecs, ":")).countTokens() == 0) {
            this.resubmitIntervalSecs = new long[2];
            this.resubmitIntervalSecs[0] = 0L;
            this.resubmitIntervalSecs[1] = 10L;
        } else {
            this.resubmitIntervalSecs = new long[tokenizer.countTokens() + 1];
            this.resubmitIntervalSecs[0] = 0L;
            for (int i = 1; i < this.resubmitIntervalSecs.length; ++i) {
                String s = tokenizer.nextToken();
                try {
                    this.resubmitIntervalSecs[i] = Long.parseLong(s);
                    continue;
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Invalid number for resubmit interval " + s + ": using default " + 10L);
                    this.resubmitIntervalSecs[i] = 10L;
                }
            }
        }
        this.expireResubmitDelaySecs = expireResubmitDelaySecs;
    }

    WorkerResubmitRateLimiter() {
        this(ConfigurationProvider.getConfig().getWorkerResubmitIntervalSecs(), ConfigurationProvider.getConfig().getExpireWorkerResubmitDelaySecs());
    }

    public void expireResubmitRecords(long currentTime) {
        Iterator<ResubmitRecord> it = this.resubmitRecords.values().iterator();
        while (it.hasNext()) {
            ResubmitRecord record = it.next();
            if (record.getResubmitAt() - record.getDelayedBy() >= currentTime - this.expireResubmitDelaySecs * 1000L) continue;
            it.remove();
        }
    }

    long evalDelay(ResubmitRecord resubmitRecord) {
        long delay = this.resubmitIntervalSecs[0];
        if (resubmitRecord != null) {
            int index;
            long prevDelay = resubmitRecord.getDelayedBy();
            for (index = 0; index < this.resubmitIntervalSecs.length && prevDelay > this.resubmitIntervalSecs[index]; ++index) {
            }
            if (++index >= this.resubmitIntervalSecs.length) {
                index = this.resubmitIntervalSecs.length - 1;
            }
            delay = this.resubmitIntervalSecs[index];
        }
        return delay;
    }

    long getWorkerResubmitTime(WorkerId workerId, int stageNum, long currentTime) {
        String workerKey = this.generateWorkerIndexStageKey(workerId, stageNum);
        ResubmitRecord prevResubmitRecord = this.resubmitRecords.get(workerKey);
        long delay = this.evalDelay(prevResubmitRecord);
        long resubmitAt = currentTime + delay * 1000L;
        ResubmitRecord currResubmitRecord = new ResubmitRecord(workerKey, resubmitAt, delay);
        this.resubmitRecords.put(workerKey, currResubmitRecord);
        return resubmitAt;
    }

    public long getWorkerResubmitTime(WorkerId workerId, int stageNum) {
        return this.getWorkerResubmitTime(workerId, stageNum, System.currentTimeMillis());
    }

    String generateWorkerIndexStageKey(WorkerId workerId, int stageNum) {
        return stageNum + "_" + workerId.getWorkerIndex();
    }

    void shutdown() {
        this.resubmitRecords.clear();
    }

    List<ResubmitRecord> getResubmitRecords() {
        HashMap copy = new HashMap(this.resubmitRecords.size());
        List<ResubmitRecord> resubmitRecordList = this.resubmitRecords.values().stream().collect(Collectors.toList());
        return resubmitRecordList;
    }

    long getExpireResubmitDelaySecs() {
        return this.expireResubmitDelaySecs;
    }

    public long[] getResubmitIntervalSecs() {
        return this.resubmitIntervalSecs;
    }

    static final class ResubmitRecord {
        private final String workerKey;
        private final long resubmitAt;
        private final long delayedBy;

        private ResubmitRecord(String workerKey, long resubmitAt, long delayedBy) {
            this.workerKey = workerKey;
            this.resubmitAt = resubmitAt;
            this.delayedBy = delayedBy;
        }

        public long getDelayedBy() {
            return this.delayedBy;
        }

        public String getWorkerKey() {
            return this.workerKey;
        }

        public long getResubmitAt() {
            return this.resubmitAt;
        }
    }
}

