/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster.job.worker;

import io.mantisrx.common.WorkerPorts;
import io.mantisrx.master.jobcluster.job.worker.IMantisWorkerMetadata;
import io.mantisrx.master.jobcluster.job.worker.WorkerState;
import io.mantisrx.server.core.JobCompletedReason;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.persistence.exceptions.InvalidWorkerStateChangeException;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonFilter;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonFilter(value="topLevelFilter")
public class MantisWorkerMetadataImpl
implements IMantisWorkerMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(MantisWorkerMetadataImpl.class);
    @JsonIgnore
    public static final int MANTIS_SYSTEM_ALLOCATED_NUM_PORTS = 4;
    private final int workerIndex;
    private int workerNumber;
    private String jobId;
    @JsonIgnore
    private JobId jobIdObj;
    private final int stageNum;
    private final int numberOfPorts;
    @JsonIgnore
    private final WorkerId workerId;
    private WorkerPorts workerPorts;
    private volatile WorkerState state;
    private volatile String slave;
    private volatile String slaveID;
    private volatile long acceptedAt = 0L;
    private volatile long launchedAt = 0L;
    private volatile long startingAt = 0L;
    private volatile long startedAt = 0L;
    private volatile long completedAt = 0L;
    private volatile JobCompletedReason reason;
    private volatile int resubmitOf = -1;
    private volatile int totalResubmitCount = 0;
    @JsonIgnore
    private volatile Optional<Instant> lastHeartbeatAt = Optional.empty();
    private volatile boolean subscribed;
    private volatile Optional<String> preferredCluster;
    private volatile Optional<ClusterID> resourceCluster;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public MantisWorkerMetadataImpl(@JsonProperty(value="workerIndex") int workerIndex, @JsonProperty(value="workerNumber") int workerNumber, @JsonProperty(value="jobId") String jobId, @JsonProperty(value="stageNum") int stageNum, @JsonProperty(value="numberOfPorts") int numberOfPorts, @JsonProperty(value="workerPorts") WorkerPorts workerPorts, @JsonProperty(value="state") WorkerState state, @JsonProperty(value="slave") String slave, @JsonProperty(value="slaveID") String slaveID, @JsonProperty(value="acceptedAt") long acceptedAt, @JsonProperty(value="launchedAt") long launchedAt, @JsonProperty(value="startingAt") long startingAt, @JsonProperty(value="startedAt") long startedAt, @JsonProperty(value="completedAt") long completedAt, @JsonProperty(value="reason") JobCompletedReason reason, @JsonProperty(value="resubmitOf") int resubmitOf, @JsonProperty(value="totalResubmitCount") int totalResubmitCount, @JsonProperty(value="preferredCluster") Optional<String> preferredCluster, @JsonProperty(value="resourceCluster") Optional<ClusterID> resourceCluster) {
        this.workerIndex = workerIndex;
        this.workerNumber = workerNumber;
        this.jobId = jobId;
        this.jobIdObj = JobId.fromId(jobId).orElseThrow(() -> new IllegalArgumentException("jobId format is invalid" + jobId));
        this.workerId = new WorkerId(jobId, workerIndex, workerNumber);
        this.stageNum = stageNum;
        this.numberOfPorts = numberOfPorts;
        this.workerPorts = workerPorts;
        this.state = state;
        this.slave = slave;
        this.slaveID = slaveID;
        this.state = state;
        this.acceptedAt = acceptedAt;
        this.launchedAt = launchedAt;
        this.completedAt = completedAt;
        this.startedAt = startedAt;
        this.startingAt = startingAt;
        this.reason = reason;
        this.resubmitOf = resubmitOf;
        this.totalResubmitCount = totalResubmitCount;
        this.preferredCluster = preferredCluster;
        this.resourceCluster = resourceCluster;
        this.totalResubmitCount = totalResubmitCount;
    }

    @Override
    public int getWorkerIndex() {
        return this.workerIndex;
    }

    @Override
    public int getWorkerNumber() {
        return this.workerNumber;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public JobId getJobIdObject() {
        return this.jobIdObj;
    }

    @Override
    public WorkerId getWorkerId() {
        return this.workerId;
    }

    @Override
    public int getStageNum() {
        return this.stageNum;
    }

    @Override
    public int getNumberOfPorts() {
        return this.numberOfPorts;
    }

    @Override
    public Optional<WorkerPorts> getPorts() {
        return Optional.ofNullable(this.workerPorts);
    }

    @Override
    public WorkerPorts getWorkerPorts() {
        return this.workerPorts;
    }

    void addPorts(WorkerPorts ports) {
        this.workerPorts = ports;
    }

    @Override
    public int getTotalResubmitCount() {
        return this.totalResubmitCount;
    }

    @Override
    public int getMetricsPort() {
        return this.workerPorts == null ? -1 : this.workerPorts.getMetricsPort();
    }

    @Override
    public int getDebugPort() {
        return this.workerPorts == null ? -1 : this.workerPorts.getDebugPort();
    }

    @Override
    public int getConsolePort() {
        return this.workerPorts == null ? -1 : this.workerPorts.getConsolePort();
    }

    @Override
    public int getCustomPort() {
        return this.workerPorts == null ? -1 : this.workerPorts.getCustomPort();
    }

    @Override
    public int getSinkPort() {
        return this.workerPorts == null ? -1 : this.workerPorts.getSinkPort();
    }

    @Override
    public int getResubmitOf() {
        return this.resubmitOf;
    }

    @JsonIgnore
    private void setResubmitInfo(int resubmitOf, int totalCount) {
        this.resubmitOf = resubmitOf;
        this.totalResubmitCount = totalCount;
    }

    @Override
    @JsonIgnore
    public Optional<Instant> getLastHeartbeatAt() {
        return this.lastHeartbeatAt;
    }

    @JsonIgnore
    void setLastHeartbeatAt(long lastHeartbeatAt) {
        this.lastHeartbeatAt = Optional.of(Instant.ofEpochMilli(lastHeartbeatAt));
    }

    private void validateStateChange(WorkerState newState) throws InvalidWorkerStateChangeException {
        if (!WorkerState.isValidStateChgTo(this.state, newState)) {
            throw new InvalidWorkerStateChangeException(this.jobId, this.workerId, this.state, newState);
        }
    }

    void setState(WorkerState newState, long when, JobCompletedReason reason) throws InvalidWorkerStateChangeException {
        WorkerState previousState = this.state;
        this.validateStateChange(newState);
        this.state = newState;
        LOGGER.info("Worker {} State changed from {} to {}", new Object[]{this.workerId, previousState, this.state});
        switch (this.state) {
            case Accepted: {
                this.acceptedAt = when;
                break;
            }
            case Launched: {
                this.launchedAt = when;
                break;
            }
            case StartInitiated: {
                this.startingAt = when;
                break;
            }
            case Started: {
                this.startedAt = when;
                break;
            }
            case Failed: {
                this.completedAt = when;
                LOGGER.info("Worker {} failedAt  {}", (Object)this.workerId, (Object)when);
                this.reason = reason == null ? JobCompletedReason.Lost : reason;
                break;
            }
            case Completed: {
                this.completedAt = when;
                LOGGER.info("Worker {} completedAt  {}", (Object)this.workerId, (Object)when);
                this.reason = reason == null ? JobCompletedReason.Normal : reason;
                break;
            }
            default: {
                assert (false) : "Unexpected job state to set";
                break;
            }
        }
    }

    @Override
    public WorkerState getState() {
        return this.state;
    }

    void setSlave(String slave) {
        this.slave = slave;
    }

    @Override
    public String getSlave() {
        return this.slave;
    }

    void setSlaveID(String slaveID) {
        this.slaveID = slaveID;
    }

    void setCluster(Optional<String> cluster) {
        this.preferredCluster = cluster;
    }

    void setResourceCluster(ClusterID resourceCluster) {
        this.resourceCluster = Optional.of(resourceCluster);
    }

    @Override
    public String getSlaveID() {
        return this.slaveID;
    }

    @Override
    public long getAcceptedAt() {
        return this.acceptedAt;
    }

    @Override
    public long getLaunchedAt() {
        return this.launchedAt;
    }

    @Override
    public long getStartingAt() {
        return this.startingAt;
    }

    @Override
    public long getStartedAt() {
        return this.startedAt;
    }

    @Override
    public long getCompletedAt() {
        return this.completedAt;
    }

    void setIsSubscribed(boolean isSub) {
        this.subscribed = isSub;
    }

    @Override
    public boolean getIsSubscribed() {
        return this.subscribed;
    }

    @Override
    public JobCompletedReason getReason() {
        return this.reason;
    }

    @Override
    public Optional<String> getPreferredClusterOptional() {
        return this.preferredCluster;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MantisWorkerMetadataImpl that = (MantisWorkerMetadataImpl)o;
        return this.workerIndex == that.workerIndex && this.workerNumber == that.workerNumber && this.stageNum == that.stageNum && this.numberOfPorts == that.numberOfPorts && this.acceptedAt == that.acceptedAt && this.launchedAt == that.launchedAt && this.startingAt == that.startingAt && this.startedAt == that.startedAt && this.completedAt == that.completedAt && this.resubmitOf == that.resubmitOf && this.totalResubmitCount == that.totalResubmitCount && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.workerId, that.workerId) && Objects.equals(this.workerPorts, that.workerPorts) && this.state == that.state && Objects.equals(this.slave, that.slave) && Objects.equals(this.slaveID, that.slaveID) && this.reason == that.reason && Objects.equals(this.preferredCluster, that.preferredCluster) && Objects.equals(this.resourceCluster, that.resourceCluster);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.workerIndex, this.workerNumber, this.jobId, this.stageNum, this.numberOfPorts, this.workerId, this.workerPorts, this.state, this.slave, this.slaveID, this.acceptedAt, this.launchedAt, this.startingAt, this.startedAt, this.completedAt, this.reason, this.resubmitOf, this.totalResubmitCount, this.preferredCluster});
    }

    public String toString() {
        return "MantisWorkerMetadataImpl{workerIndex=" + this.workerIndex + ", workerNumber=" + this.workerNumber + ", jobId=" + this.jobId + ", stageNum=" + this.stageNum + ", numberOfPorts=" + this.numberOfPorts + ", workerId=" + this.workerId + ", workerPorts=" + this.workerPorts + ", state=" + (Object)((Object)this.state) + ", slave='" + this.slave + '\'' + ", slaveID='" + this.slaveID + '\'' + ", acceptedAt=" + this.acceptedAt + ", launchedAt=" + this.launchedAt + ", startingAt=" + this.startingAt + ", startedAt=" + this.startedAt + ", completedAt=" + this.completedAt + ", reason=" + this.reason + ", resubmitOf=" + this.resubmitOf + ", totalResubmitCount=" + this.totalResubmitCount + ", lastHeartbeatAt=" + this.lastHeartbeatAt + ", subscribed=" + this.subscribed + ", preferredCluster=" + this.preferredCluster + ", resourceCluster=" + this.resourceCluster + '}';
    }

    @Override
    public Optional<String> getCluster() {
        return this.preferredCluster;
    }

    @Override
    public Optional<ClusterID> getResourceCluster() {
        return this.resourceCluster;
    }
}

