/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster.job.worker;

import io.mantisrx.master.jobcluster.job.worker.WorkerState;
import io.mantisrx.runtime.MantisJobState;
import io.mantisrx.server.core.Status;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.scheduler.WorkerEvent;
import java.time.Instant;

public class WorkerHeartbeat
implements WorkerEvent {
    private final WorkerId workerId;
    private final Status heartBeat;
    private final WorkerState workerState;
    private final long time;

    public WorkerHeartbeat(Status hb) {
        this(hb, Instant.ofEpochMilli(hb.getTimestamp()));
    }

    public WorkerHeartbeat(Status hb, Instant time) {
        this.heartBeat = hb;
        this.time = time.toEpochMilli();
        this.workerId = (WorkerId)hb.getWorkerId().get();
        this.workerState = this.setWorkerState(this.heartBeat.getState());
    }

    private WorkerState setWorkerState(MantisJobState state) {
        switch (state) {
            case Launched: {
                return WorkerState.Launched;
            }
            case Started: {
                return WorkerState.Started;
            }
            case StartInitiated: {
                return WorkerState.StartInitiated;
            }
            case Completed: {
                return WorkerState.Completed;
            }
            case Failed: {
                return WorkerState.Failed;
            }
            case Noop: {
                return WorkerState.Noop;
            }
        }
        return WorkerState.Unknown;
    }

    @Override
    public WorkerId getWorkerId() {
        return this.workerId;
    }

    public Status getStatus() {
        return this.heartBeat;
    }

    public WorkerState getState() {
        return this.workerState;
    }

    @Override
    public long getEventTimeMs() {
        return this.time;
    }

    public String toString() {
        return "WorkerHeartbeat [workerId=" + this.workerId + ", heartBeat=" + this.heartBeat + ", workerState=" + (Object)((Object)this.workerState) + ", time=" + this.time + "]";
    }
}

