/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster.proto;

import akka.actor.ActorRef;
import akka.http.javadsl.model.Uri;
import com.mantisrx.common.utils.LabelUtils;
import com.netflix.spectator.impl.Preconditions;
import io.mantisrx.common.Label;
import io.mantisrx.master.api.akka.route.pagination.ListObject;
import io.mantisrx.master.api.akka.route.proto.JobClusterProtoAdapter;
import io.mantisrx.master.jobcluster.MantisJobClusterMetadataView;
import io.mantisrx.master.jobcluster.job.IMantisJobMetadata;
import io.mantisrx.master.jobcluster.job.JobState;
import io.mantisrx.master.jobcluster.job.MantisJobMetadataView;
import io.mantisrx.master.jobcluster.job.worker.IMantisWorkerMetadata;
import io.mantisrx.master.jobcluster.job.worker.WorkerState;
import io.mantisrx.master.jobcluster.proto.BaseRequest;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.runtime.WorkerMigrationConfig;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.server.core.JobSchedulingInfo;
import io.mantisrx.server.master.domain.IJobClusterDefinition;
import io.mantisrx.server.master.domain.JobClusterDefinitionImpl;
import io.mantisrx.server.master.domain.JobDefinition;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.scheduler.MantisSchedulerFactory;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.google.common.base.Strings;
import io.mantisrx.shaded.com.google.common.collect.Lists;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import rx.subjects.BehaviorSubject;

public class JobClusterManagerProto {

    public static final class ResubmitWorkerResponse
    extends BaseResponse {
        public ResubmitWorkerResponse(long requestId, BaseResponse.ResponseCode responseCode, String message) {
            super(requestId, responseCode, message);
        }

        public String toString() {
            return "ResubmitWorkerResponse [requestId=" + this.requestId + ", respCode=" + (Object)((Object)this.responseCode) + ", message=" + this.message + "]";
        }
    }

    public static final class V1ResubmitWorkerRequest
    extends BaseRequest {
        private final String user;
        private final int workerNum;
        private final Optional<String> reason;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public V1ResubmitWorkerRequest(@JsonProperty(value="workerNumber") Integer workerNum, @JsonProperty(value="user") String user, @JsonProperty(value="reason") Optional<String> reason) {
            Preconditions.checkNotNull((Object)workerNum, (String)"workerNumber");
            Preconditions.checkArg((workerNum > 0 ? 1 : 0) != 0, (String)"Worker number must be greater than 0");
            this.workerNum = workerNum;
            this.user = user;
            this.reason = reason;
        }

        public int getWorkerNum() {
            return this.workerNum;
        }

        public String getUser() {
            return this.user;
        }

        public Optional<String> getReason() {
            return this.reason;
        }

        public String toString() {
            return "ResubmitWorkerRequest{user='" + this.user + '\'' + ", workerNum=" + this.workerNum + ", reason=" + this.reason + '}';
        }
    }

    public static final class ResubmitWorkerRequest
    extends BaseRequest {
        private final String user;
        private final JobId jobId;
        private final int workerNum;
        private final Optional<String> reason;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public ResubmitWorkerRequest(@JsonProperty(value="JobId") String jobIdStr, @JsonProperty(value="workerNumber") Integer workerNum, @JsonProperty(value="user") String user, @JsonProperty(value="reason") Optional<String> reason) {
            Preconditions.checkArg((boolean)(jobIdStr != null & !jobIdStr.isEmpty()), (String)"Must provide job ID in request");
            Preconditions.checkNotNull((Object)workerNum, (String)"workerNumber");
            Preconditions.checkArg((workerNum > 0 ? 1 : 0) != 0, (String)"Worker number must be greater than 0");
            this.jobId = JobId.fromId(jobIdStr).orElseThrow(() -> new IllegalArgumentException("invalid JobID in resubmit worker request " + jobIdStr));
            this.workerNum = workerNum;
            this.user = user;
            this.reason = reason;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public int getWorkerNum() {
            return this.workerNum;
        }

        public String getUser() {
            return this.user;
        }

        public Optional<String> getReason() {
            return this.reason;
        }

        public String toString() {
            return "ResubmitWorkerRequest{user='" + this.user + '\'' + ", jobId=" + this.jobId + ", workerNum=" + this.workerNum + ", reason=" + this.reason + '}';
        }
    }

    public static final class ScaleStageResponse
    extends BaseResponse {
        private final int actualNumWorkers;

        public ScaleStageResponse(long requestId, BaseResponse.ResponseCode responseCode, String message, int actualNumWorkers) {
            super(requestId, responseCode, message);
            this.actualNumWorkers = actualNumWorkers;
        }

        public int getActualNumWorkers() {
            return this.actualNumWorkers;
        }

        public String toString() {
            return "ScaleStageResponse{actualNumWorkers=" + this.actualNumWorkers + '}';
        }
    }

    public static final class ScaleStageRequest
    extends BaseRequest {
        private final int stageNum;
        private final int numWorkers;
        private final String user;
        private final String reason;
        private final JobId jobId;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public ScaleStageRequest(@JsonProperty(value="JobId") String jobId, @JsonProperty(value="StageNumber") Integer stageNo, @JsonProperty(value="NumWorkers") Integer numWorkers, @JsonProperty(value="User") String user, @JsonProperty(value="Reason") String reason) {
            Preconditions.checkArg((boolean)(jobId != null & !jobId.isEmpty()), (String)"Must provide job ID in request");
            Preconditions.checkArg((stageNo > 0 ? 1 : 0) != 0, (String)("Invalid stage Number " + stageNo));
            Preconditions.checkArg((numWorkers != null && numWorkers > 0 ? 1 : 0) != 0, (String)"NumWorkers must be greater than 0");
            this.stageNum = stageNo;
            this.numWorkers = numWorkers;
            this.user = Optional.ofNullable(user).orElse("UserNotKnown");
            this.reason = Optional.ofNullable(reason).orElse("");
            this.jobId = JobId.fromId(jobId).get();
        }

        public int getStageNum() {
            return this.stageNum;
        }

        public int getNumWorkers() {
            return this.numWorkers;
        }

        public String getUser() {
            return this.user;
        }

        public String getReason() {
            return this.reason;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public String toString() {
            return "ScaleStageRequest{stageNum=" + this.stageNum + ", numWorkers=" + this.numWorkers + ", user='" + this.user + '\'' + ", reason='" + this.reason + '\'' + ", jobId=" + this.jobId + '}';
        }
    }

    public static final class KillJobResponse
    extends BaseResponse {
        private final JobId jobId;
        private final JobState state;
        private final String user;

        public KillJobResponse(long requestId, BaseResponse.ResponseCode responseCode, JobState state, String message, JobId jobId, String user) {
            super(requestId, responseCode, message);
            this.jobId = jobId;
            this.state = state;
            this.user = user;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public JobState getState() {
            return this.state;
        }

        public String getUser() {
            return this.user;
        }

        public String toString() {
            return "KillJobResponse [jobId=" + this.jobId + ", state=" + (Object)((Object)this.state) + ", user=" + this.user + "]";
        }
    }

    public static final class KillJobRequest
    extends BaseRequest {
        private final JobId jobId;
        private final String reason;
        private final String user;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public KillJobRequest(@JsonProperty(value="JobId") String jobId, @JsonProperty(value="reason") String reason, @JsonProperty(value="user") String user) {
            Preconditions.checkArg((boolean)(user != null & !user.isEmpty()), (String)"Must provide user in request");
            Preconditions.checkArg((boolean)(jobId != null & !jobId.isEmpty()), (String)"Must provide job ID in request");
            this.jobId = JobId.fromId(jobId).get();
            this.reason = Optional.ofNullable(reason).orElse("");
            this.user = user;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public String getReason() {
            return this.reason;
        }

        public String getUser() {
            return this.user;
        }

        public String toString() {
            return "KillJobRequest [jobId=" + this.jobId + ", reason=" + this.reason + ", user=" + this.user + "]";
        }
    }

    public static final class GetLastSubmittedJobIdStreamResponse
    extends BaseResponse {
        private final Optional<BehaviorSubject<JobId>> jobIdBehaviorSubject;

        public GetLastSubmittedJobIdStreamResponse(long requestId, BaseResponse.ResponseCode code, String msg, Optional<BehaviorSubject<JobId>> jobIdBehaviorSubject) {
            super(requestId, code, msg);
            this.jobIdBehaviorSubject = jobIdBehaviorSubject;
        }

        public Optional<BehaviorSubject<JobId>> getjobIdBehaviorSubject() {
            return this.jobIdBehaviorSubject;
        }
    }

    public static final class GetLastSubmittedJobIdStreamRequest
    extends BaseRequest {
        private final String clusterName;

        public GetLastSubmittedJobIdStreamRequest(String clusterName) {
            Preconditions.checkArg((boolean)(clusterName != null & !clusterName.isEmpty()), (String)"Must provide job cluster name in request");
            this.clusterName = clusterName;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GetLastSubmittedJobIdStreamRequest that = (GetLastSubmittedJobIdStreamRequest)o;
            return Objects.equals(this.clusterName, that.clusterName);
        }

        public int hashCode() {
            return Objects.hash(this.clusterName);
        }

        public String toString() {
            return "GetLastSubmittedJobIdStreamRequest{clusterName='" + this.clusterName + '\'' + '}';
        }
    }

    public static final class GetJobSchedInfoResponse
    extends BaseResponse {
        private final Optional<BehaviorSubject<JobSchedulingInfo>> jobStatusSubject;

        public GetJobSchedInfoResponse(long requestId, BaseResponse.ResponseCode code, String msg, Optional<BehaviorSubject<JobSchedulingInfo>> statusSubject) {
            super(requestId, code, msg);
            this.jobStatusSubject = statusSubject;
        }

        public Optional<BehaviorSubject<JobSchedulingInfo>> getJobSchedInfoSubject() {
            return this.jobStatusSubject;
        }
    }

    public static final class GetJobSchedInfoRequest
    extends BaseRequest {
        private final JobId jobId;

        public GetJobSchedInfoRequest(JobId jobId) {
            this.jobId = jobId;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GetJobSchedInfoRequest that = (GetJobSchedInfoRequest)o;
            return Objects.equals(this.jobId, that.jobId);
        }

        public int hashCode() {
            return Objects.hash(this.jobId);
        }

        public String toString() {
            return "GetJobStatusSubjectRequest{jobId=" + this.jobId + '}';
        }
    }

    public static final class GetLatestJobDiscoveryInfoResponse
    extends BaseResponse {
        private final Optional<JobSchedulingInfo> jobSchedulingInfo;

        public GetLatestJobDiscoveryInfoResponse(long requestId, BaseResponse.ResponseCode code, String msg, Optional<JobSchedulingInfo> jobSchedulingInfo) {
            super(requestId, code, msg);
            this.jobSchedulingInfo = jobSchedulingInfo;
        }

        public Optional<JobSchedulingInfo> getDiscoveryInfo() {
            return this.jobSchedulingInfo;
        }
    }

    public static final class GetLatestJobDiscoveryInfoRequest
    extends BaseRequest {
        private final String jobCluster;

        public GetLatestJobDiscoveryInfoRequest(String jobCluster) {
            Preconditions.checkNotNull((Object)jobCluster, (String)"jobCluster");
            this.jobCluster = jobCluster;
        }

        public String getJobCluster() {
            return this.jobCluster;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GetLatestJobDiscoveryInfoRequest that = (GetLatestJobDiscoveryInfoRequest)o;
            return Objects.equals(this.jobCluster, that.jobCluster);
        }

        public int hashCode() {
            return Objects.hash(this.jobCluster);
        }

        public String toString() {
            return "GetLatestJobDiscoveryInfoRequest{jobCluster='" + this.jobCluster + '\'' + '}';
        }
    }

    public static final class GetJobDefinitionUpdatedFromJobActorResponse
    extends BaseResponse {
        private final String user;
        private final JobDefinition jobDefinition;
        private final boolean isAutoResubmit;
        private final boolean isQuickSubmitMode;
        private final ActorRef originalSender;

        public GetJobDefinitionUpdatedFromJobActorResponse(long requestId, BaseResponse.ResponseCode responseCode, String message, String user, JobDefinition jobDefn, boolean isAutoResubmit, boolean isQuickSubmitMode, ActorRef originalSender) {
            super(requestId, responseCode, message);
            Preconditions.checkNotNull((Object)user, (String)"user");
            Preconditions.checkNotNull((Object)originalSender, (String)"originalSender");
            this.user = user;
            this.jobDefinition = jobDefn;
            this.isAutoResubmit = isAutoResubmit;
            this.isQuickSubmitMode = isQuickSubmitMode;
            this.originalSender = originalSender;
        }

        public String toString() {
            return "JobClusterManagerProto.GetJobDefinitionUpdatedFromJobActorResponse(user=" + this.getUser() + ", jobDefinition=" + this.getJobDefinition() + ", isAutoResubmit=" + this.isAutoResubmit() + ", isQuickSubmitMode=" + this.isQuickSubmitMode() + ", originalSender=" + this.getOriginalSender() + ")";
        }

        public String getUser() {
            return this.user;
        }

        public JobDefinition getJobDefinition() {
            return this.jobDefinition;
        }

        public boolean isAutoResubmit() {
            return this.isAutoResubmit;
        }

        public boolean isQuickSubmitMode() {
            return this.isQuickSubmitMode;
        }

        public ActorRef getOriginalSender() {
            return this.originalSender;
        }
    }

    public static final class GetJobDetailsResponse
    extends BaseResponse {
        private final Optional<IMantisJobMetadata> jobMetadata;

        public GetJobDetailsResponse(long requestId, BaseResponse.ResponseCode responseCode, String message, Optional<IMantisJobMetadata> jobMetadata) {
            super(requestId, responseCode, message);
            this.jobMetadata = jobMetadata;
        }

        public Optional<IMantisJobMetadata> getJobMetadata() {
            return this.jobMetadata;
        }

        public String toString() {
            return "GetJobDetailsResponse [jobMetadata=" + this.jobMetadata + "]";
        }
    }

    public static final class GetJobDefinitionUpdatedFromJobActorRequest
    extends BaseRequest {
        private final String user;
        private final JobId jobId;
        private final JobDefinition jobDefinition;
        private final boolean isQuickSubmit;
        private final boolean isAutoResubmit;
        private final ActorRef originalSender;

        public GetJobDefinitionUpdatedFromJobActorRequest(String user, JobId jobId, JobDefinition jobDefinition, boolean isQuickSubmit, boolean isAutoResubmit, ActorRef originalSender) {
            Preconditions.checkNotNull((Object)user, (String)"user");
            Preconditions.checkNotNull((Object)jobId, (String)"jobId");
            Preconditions.checkNotNull((Object)originalSender, (String)"originalSender");
            Preconditions.checkNotNull((Object)jobDefinition, (String)"jobDefinition");
            this.jobId = jobId;
            this.user = user;
            this.jobDefinition = jobDefinition;
            this.isQuickSubmit = isQuickSubmit;
            this.isAutoResubmit = isAutoResubmit;
            this.originalSender = originalSender;
        }

        public String getUser() {
            return this.user;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public JobDefinition getJobDefinition() {
            return this.jobDefinition;
        }

        public boolean isQuickSubmit() {
            return this.isQuickSubmit;
        }

        public boolean isAutoResubmit() {
            return this.isAutoResubmit;
        }

        public ActorRef getOriginalSender() {
            return this.originalSender;
        }

        public String toString() {
            return "JobClusterManagerProto.GetJobDefinitionUpdatedFromJobActorRequest(user=" + this.getUser() + ", jobId=" + this.getJobId() + ", jobDefinition=" + this.getJobDefinition() + ", isQuickSubmit=" + this.isQuickSubmit() + ", isAutoResubmit=" + this.isAutoResubmit() + ", originalSender=" + this.getOriginalSender() + ")";
        }
    }

    public static final class GetJobDetailsRequest
    extends BaseRequest {
        private final String user;
        private final JobId jobId;

        public GetJobDetailsRequest(String user, JobId jobId) {
            this.jobId = jobId;
            this.user = user;
        }

        public GetJobDetailsRequest(String user, String jobId) {
            Preconditions.checkNotNull((Object)user, (String)"user");
            Preconditions.checkArg((jobId != null && !jobId.isEmpty() ? 1 : 0) != 0, (String)"Must provide job ID in request");
            Optional<JobId> jOp = JobId.fromId(jobId);
            if (!jOp.isPresent()) {
                throw new IllegalArgumentException(String.format("Invalid jobId %s. JobId must be in the format [JobCLusterName-NumericID]", jobId));
            }
            this.jobId = jOp.get();
            this.user = user;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public String getUser() {
            return this.user;
        }

        public String toString() {
            return "GetJobDetailsRequest [jobId=" + this.jobId + ", user=" + this.user + "]";
        }
    }

    public static final class SubmitJobResponse
    extends BaseResponse {
        private final Optional<JobId> jobId;

        public SubmitJobResponse(long requestId, BaseResponse.ResponseCode responseCode, String message, Optional<JobId> jobId) {
            super(requestId, responseCode, message);
            this.jobId = jobId;
        }

        public Optional<JobId> getJobId() {
            return this.jobId;
        }

        public String toString() {
            return "SubmitJobResponse{jobId=" + this.jobId + ", requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class SubmitJobRequest
    extends BaseRequest {
        private final Optional<JobDefinition> jobDefinition;
        private final String submitter;
        private final String clusterName;
        private final boolean isAutoResubmit;
        private final boolean submitLatest;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public SubmitJobRequest(@JsonProperty(value="name") String clusterName, @JsonProperty(value="user") String user, @JsonProperty(value="jobDefinition") Optional<JobDefinition> jobDefinition, @JsonProperty(value="submitLatestJobCluster") boolean submitLatest) {
            Preconditions.checkArg((user != null && !user.isEmpty() ? 1 : 0) != 0, (String)"Must provide user in request");
            Preconditions.checkArg((clusterName != null && !clusterName.isEmpty() ? 1 : 0) != 0, (String)"Must provide job cluster name in request");
            Preconditions.checkNotNull(jobDefinition, (String)"jobDefinition");
            this.jobDefinition = jobDefinition;
            this.submitter = user;
            this.clusterName = clusterName;
            this.isAutoResubmit = false;
            this.submitLatest = submitLatest;
        }

        public SubmitJobRequest(String clusterName, String submitter, JobDefinition jobDefinition) {
            this(clusterName, submitter, false, Optional.of(jobDefinition));
        }

        public SubmitJobRequest(String clusterName, String user) {
            this(clusterName, user, false, Optional.empty());
        }

        public SubmitJobRequest(String clusterName, String user, boolean isAutoResubmit, Optional<JobDefinition> jobDefinition) {
            Preconditions.checkArg((user != null && !user.isEmpty() ? 1 : 0) != 0, (String)"Must provide user in request");
            Preconditions.checkArg((clusterName != null && !clusterName.isEmpty() ? 1 : 0) != 0, (String)"Must provide job cluster name in request");
            this.jobDefinition = jobDefinition;
            this.submitter = user;
            this.clusterName = clusterName;
            this.isAutoResubmit = isAutoResubmit;
            this.submitLatest = false;
        }

        public Optional<JobDefinition> getJobDefinition() {
            return this.jobDefinition;
        }

        public String getSubmitter() {
            return this.submitter;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public boolean isAutoResubmit() {
            return this.isAutoResubmit;
        }

        public boolean isSubmitLatest() {
            return this.submitLatest;
        }

        public String toString() {
            return "JobClusterManagerProto.SubmitJobRequest(jobDefinition=" + this.getJobDefinition() + ", submitter=" + this.getSubmitter() + ", clusterName=" + this.getClusterName() + ", isAutoResubmit=" + this.isAutoResubmit() + ", submitLatest=" + this.isSubmitLatest() + ")";
        }
    }

    public static final class ListCompletedJobsInClusterResponse
    extends BaseResponse {
        private final List<JobClusterDefinitionImpl.CompletedJob> completedJobs;

        public ListCompletedJobsInClusterResponse(long requestId, BaseResponse.ResponseCode responseCode, String message, List<JobClusterDefinitionImpl.CompletedJob> completedJobs) {
            super(requestId, responseCode, message);
            this.completedJobs = completedJobs;
        }

        public List<JobClusterDefinitionImpl.CompletedJob> getCompletedJobs() {
            return this.completedJobs;
        }

        public String toString() {
            return "ListCompletedJobsInClusterResponse [completedJobs=" + this.completedJobs + "]";
        }
    }

    public static final class ListCompletedJobsInClusterRequest
    extends BaseRequest {
        private final String clusterName;
        private final int limit;

        public ListCompletedJobsInClusterRequest(String name) {
            this(name, 100);
        }

        public ListCompletedJobsInClusterRequest(String name, int limit) {
            Preconditions.checkArg((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"Jobcluster name cannot be null or empty");
            this.clusterName = name;
            this.limit = limit;
        }

        public int getLimit() {
            return this.limit;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public String toString() {
            return "ListCompletedJobsInClusterRequest{clusterName='" + this.clusterName + '\'' + ", limit=" + this.limit + ", requestId=" + this.requestId + '}';
        }
    }

    public static final class ListWorkersResponse
    extends BaseResponse {
        private final List<IMantisWorkerMetadata> mantisWorkerMetadata;

        public ListWorkersResponse(long requestId, BaseResponse.ResponseCode responseCode, String message, List<IMantisWorkerMetadata> list) {
            super(requestId, responseCode, message);
            Preconditions.checkNotNull(list, (String)"worker metadata list cannot be null");
            this.mantisWorkerMetadata = list;
        }

        public List<IMantisWorkerMetadata> getWorkerMetadata() {
            return this.mantisWorkerMetadata;
        }

        public String toString() {
            return "ListWorkersResponse{mantisWorkerMetadata=" + this.mantisWorkerMetadata + ", requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class ListWorkersRequest
    extends BaseRequest {
        public static final int DEFAULT_LIST_WORKERS_LIMIT = 100;
        private final JobId jobId;
        private final int limit;

        public ListWorkersRequest(JobId jobId) {
            this(jobId, 100);
        }

        public ListWorkersRequest(JobId jobId, int limit) {
            this.jobId = jobId;
            this.limit = limit;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public int getLimit() {
            return this.limit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListWorkersRequest that = (ListWorkersRequest)o;
            return this.limit == that.limit && Objects.equals(this.jobId, that.jobId);
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.limit);
        }

        public String toString() {
            return "ListWorkersRequest{jobId=" + this.jobId + ", limit=" + this.limit + ", requestId=" + this.requestId + '}';
        }
    }

    public static final class ListArchivedWorkersResponse
    extends BaseResponse {
        private final List<IMantisWorkerMetadata> mantisWorkerMetadata;

        public ListArchivedWorkersResponse(long requestId, BaseResponse.ResponseCode responseCode, String message, List<IMantisWorkerMetadata> list) {
            super(requestId, responseCode, message);
            Preconditions.checkNotNull(list, (String)"worker metadata list cannot be null");
            this.mantisWorkerMetadata = list;
        }

        public List<IMantisWorkerMetadata> getWorkerMetadata() {
            return this.mantisWorkerMetadata;
        }

        public ListObject<IMantisWorkerMetadata> getWorkerMetadata(Integer pageSize, Integer offset, String sortField, Boolean sortAscending, Uri uri) {
            return this.getTransformedWorkerMetadata(this.mantisWorkerMetadata, IMantisWorkerMetadata.class, pageSize, offset, sortField, sortAscending, uri);
        }

        public <R> ListObject<R> getWorkerMetadata(Function<IMantisWorkerMetadata, R> func, Class<R> classType, Integer pageSize, Integer offset, String sortField, Boolean sortAscending, Uri uri) {
            List mappedList = this.mantisWorkerMetadata.stream().map(func).collect(Collectors.toList());
            return this.getTransformedWorkerMetadata(mappedList, classType, pageSize, offset, sortField, sortAscending, uri);
        }

        private <T> ListObject<T> getTransformedWorkerMetadata(List<T> list, Class<T> classType, Integer pageSize, Integer offset, String sortField, Boolean sortAscending, Uri uri) {
            ListObject.Builder builder = new ListObject.Builder<T>().withObjects(list, classType);
            if (pageSize != null) {
                builder = builder.withLimit(pageSize);
            }
            if (offset != null) {
                builder = builder.withOffset(offset);
            }
            if (sortField != null) {
                builder = builder.withSortField(sortField);
            }
            if (sortAscending != null) {
                builder = builder.withSortAscending(sortAscending);
            }
            if (uri != null) {
                builder = builder.withUri(uri);
            }
            return builder.build();
        }

        public String toString() {
            return "ListArchivedWorkersResponse{mantisWorkerMetadata=" + this.mantisWorkerMetadata + ", requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class ListArchivedWorkersRequest
    extends BaseRequest {
        public static final int DEFAULT_LIST_ARCHIVED_WORKERS_LIMIT = 100;
        private final JobId jobId;
        private final int limit;

        public ListArchivedWorkersRequest(JobId jobId) {
            this(jobId, 100);
        }

        public ListArchivedWorkersRequest(JobId jobId, int limit) {
            Preconditions.checkNotNull((Object)jobId, (String)"JobId");
            this.jobId = jobId;
            this.limit = limit;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public int getLimit() {
            return this.limit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListArchivedWorkersRequest that = (ListArchivedWorkersRequest)o;
            return this.limit == that.limit && Objects.equals(this.jobId, that.jobId);
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.limit);
        }

        public String toString() {
            return "ListArchivedWorkersRequest{jobId=" + this.jobId + ", limit=" + this.limit + ", requestId=" + this.requestId + '}';
        }
    }

    public static final class ListJobIdsResponse
    extends BaseResponse {
        private final List<JobClusterProtoAdapter.JobIdInfo> jobIds;

        public ListJobIdsResponse(long requestId, BaseResponse.ResponseCode responseCode, String message, List<JobClusterProtoAdapter.JobIdInfo> list) {
            super(requestId, responseCode, message);
            Preconditions.checkNotNull(list, (String)"job ids list cannot be null");
            this.jobIds = list;
        }

        public List<JobClusterProtoAdapter.JobIdInfo> getJobIds() {
            return this.jobIds;
        }

        public String toString() {
            return "ListJobIdsResponse{jobIds=" + this.jobIds + ", requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class ListJobIdsRequest
    extends BaseRequest {
        public final ListJobCriteria filters;

        public ListJobIdsRequest(Optional<Integer> limit, Optional<JobState.MetaState> jobState, Optional<Boolean> activeOnly, Optional<String> matchingRegex, Optional<String> matchingLabels, Optional<String> labelsOperand, Optional<JobId> startJobIdExclusive) {
            this.filters = new ListJobCriteria(limit, jobState, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), activeOnly, matchingRegex, matchingLabels, labelsOperand, startJobIdExclusive);
        }

        public ListJobIdsRequest() {
            this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }

        public ListJobCriteria getCriteria() {
            return this.filters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListJobIdsRequest that = (ListJobIdsRequest)o;
            return Objects.equals(this.filters, that.filters);
        }

        public int hashCode() {
            return Objects.hash(this.filters);
        }

        public String toString() {
            return "ListJobIdsRequest{filters=" + this.filters + ", requestId=" + this.requestId + '}';
        }
    }

    public static final class ListJobsResponse
    extends BaseResponse {
        private final List<MantisJobMetadataView> jobs;

        public ListJobsResponse(long requestId, BaseResponse.ResponseCode responseCode, String message, List<MantisJobMetadataView> list) {
            super(requestId, responseCode, message);
            Preconditions.checkNotNull(list, (String)"job ids list cannot be null");
            this.jobs = list;
        }

        public List<MantisJobMetadataView> getJobList() {
            return this.jobs;
        }

        public <R> ListObject<R> getJobList(Function<MantisJobMetadataView, R> func, Class<R> classType, Integer pageSize, Integer offset, String sortField, Boolean sortAscending, Uri uri) {
            List mappedList = this.jobs.stream().map(func).collect(Collectors.toList());
            return this.getTransformedJobList(mappedList, classType, pageSize, offset, sortField, sortAscending, uri);
        }

        public ListObject<MantisJobMetadataView> getJobList(Integer pageSize, Integer offset, String sortField, Boolean sortAscending, Uri uri) {
            return this.getTransformedJobList(this.jobs, MantisJobMetadataView.class, pageSize, offset, sortField, sortAscending, uri);
        }

        private <T> ListObject<T> getTransformedJobList(List<T> list, Class<T> classType, Integer pageSize, Integer offset, String sortField, Boolean sortAscending, Uri uri) {
            ListObject.Builder builder = new ListObject.Builder<T>().withObjects(list, classType);
            if (uri != null) {
                builder = builder.withUri(uri);
            }
            if (pageSize != null) {
                builder = builder.withLimit(pageSize);
            }
            if (offset != null) {
                builder = builder.withOffset(offset);
            }
            if (sortAscending != null) {
                builder = builder.withSortAscending(sortAscending);
            }
            if (sortField != null) {
                builder = builder.withSortField(sortField);
            }
            return builder.build();
        }

        public String toString() {
            return "ListJobsResponse{jobs=" + this.jobs + ", requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static class ListJobsRequest
    extends BaseRequest {
        private final ListJobCriteria filters;

        public ListJobsRequest(ListJobCriteria filters) {
            this.filters = filters;
        }

        public ListJobsRequest() {
            this(new ListJobCriteria());
        }

        public ListJobsRequest(String clusterName) {
            this(new ListJobCriteria(Optional.empty(), Optional.empty(), Lists.newArrayList(), Lists.newArrayList(), Lists.newArrayList(), Lists.newArrayList(), Optional.empty(), Optional.ofNullable(clusterName), Optional.empty(), Optional.empty(), Optional.empty()));
        }

        public ListJobCriteria getCriteria() {
            return this.filters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListJobsRequest that = (ListJobsRequest)o;
            return Objects.equals(this.filters, that.filters);
        }

        public int hashCode() {
            return Objects.hash(this.filters);
        }

        public String toString() {
            return "ListJobsRequest{filters=" + this.filters + ", requestId=" + this.requestId + '}';
        }
    }

    public static final class ListJobCriteria {
        private final Optional<Integer> limit;
        private final Optional<JobState.MetaState> jobState;
        private final List<Integer> stageNumberList;
        private final List<Integer> workerIndexList;
        private final List<Integer> workerNumberList;
        private final List<WorkerState.MetaState> workerStateList;
        private final Optional<Boolean> activeOnly;
        private final Optional<String> matchingRegex;
        private final List<Label> matchingLabels;
        private final Optional<String> labelsOperand;
        private final Optional<JobId> startJobIdExclusive;

        public ListJobCriteria(Optional<Integer> limit, Optional<JobState.MetaState> jobState, List<Integer> stageNumber, List<Integer> workerIndex, List<Integer> workerNumber, List<WorkerState.MetaState> workerState, Optional<Boolean> activeOnly, Optional<String> matchingRegex, Optional<String> matchingLabels, Optional<String> labelsOperand, Optional<JobId> startJobIdExclusive) {
            this.limit = limit;
            this.jobState = jobState;
            this.stageNumberList = stageNumber;
            this.workerIndexList = workerIndex;
            this.workerNumberList = workerNumber;
            this.workerStateList = workerState;
            this.activeOnly = activeOnly;
            this.matchingRegex = matchingRegex;
            this.matchingLabels = matchingLabels.map(query -> LabelUtils.generatePairs((String)query)).orElse(Collections.emptyList());
            this.labelsOperand = labelsOperand;
            this.startJobIdExclusive = startJobIdExclusive;
        }

        public ListJobCriteria() {
            this(Optional.empty(), Optional.empty(), Lists.newArrayList(), Lists.newArrayList(), Lists.newArrayList(), Lists.newArrayList(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }

        public Optional<Integer> getLimit() {
            return this.limit;
        }

        public Optional<JobState.MetaState> getJobState() {
            return this.jobState;
        }

        public List<Integer> getStageNumberList() {
            return this.stageNumberList;
        }

        public List<Integer> getWorkerIndexList() {
            return this.workerIndexList;
        }

        public List<Integer> getWorkerNumberList() {
            return this.workerNumberList;
        }

        public List<WorkerState.MetaState> getWorkerStateList() {
            return this.workerStateList;
        }

        public Optional<Boolean> getActiveOnly() {
            return this.activeOnly;
        }

        public Optional<String> getMatchingRegex() {
            return this.matchingRegex;
        }

        public List<Label> getMatchingLabels() {
            return this.matchingLabels;
        }

        public Optional<String> getLabelsOperand() {
            return this.labelsOperand;
        }

        public Optional<JobId> getStartJobIdExclusive() {
            return this.startJobIdExclusive;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListJobCriteria that = (ListJobCriteria)o;
            return Objects.equals(this.limit, that.limit) && Objects.equals(this.jobState, that.jobState) && Objects.equals(this.stageNumberList, that.stageNumberList) && Objects.equals(this.workerIndexList, that.workerIndexList) && Objects.equals(this.workerNumberList, that.workerNumberList) && Objects.equals(this.workerStateList, that.workerStateList) && Objects.equals(this.activeOnly, that.activeOnly) && Objects.equals(this.matchingRegex, that.matchingRegex) && Objects.equals(this.matchingLabels, that.matchingLabels) && Objects.equals(this.labelsOperand, that.labelsOperand);
        }

        public int hashCode() {
            return Objects.hash(this.limit, this.jobState, this.stageNumberList, this.workerIndexList, this.workerNumberList, this.workerStateList, this.activeOnly, this.matchingRegex, this.matchingLabels, this.labelsOperand);
        }

        public String toString() {
            return "ListJobCriteria{limit=" + this.limit + ", jobState=" + this.jobState + ", stageNumberList=" + this.stageNumberList + ", workerIndexList=" + this.workerIndexList + ", workerNumberList=" + this.workerNumberList + ", workerStateList=" + this.workerStateList + ", activeOnly=" + this.activeOnly + ", matchingRegex=" + this.matchingRegex + ", matchingLabels=" + this.matchingLabels + ", labelsOperand=" + this.labelsOperand + '}';
        }
    }

    public static final class GetJobClusterResponse
    extends BaseResponse {
        private final Optional<MantisJobClusterMetadataView> jobClusterOp;

        public GetJobClusterResponse(long requestId, BaseResponse.ResponseCode responseCode, String message, Optional<MantisJobClusterMetadataView> jobClusterOp) {
            super(requestId, responseCode, message);
            Preconditions.checkNotNull(jobClusterOp, (String)"Job cluster cannot be null");
            this.jobClusterOp = jobClusterOp;
        }

        public Optional<MantisJobClusterMetadataView> getJobCluster() {
            return this.jobClusterOp;
        }

        public String toString() {
            return "GetJobClusterResponse{jobClusterOp=" + this.jobClusterOp + ", requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class GetJobClusterRequest
    extends BaseRequest {
        private final String jobClusterName;

        public GetJobClusterRequest(String name) {
            Preconditions.checkArg((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"Jobcluster name cannot be null or empty");
            this.jobClusterName = name;
        }

        public String getJobClusterName() {
            return this.jobClusterName;
        }

        public String toString() {
            return "GetJobClusterRequest{jobClusterName='" + this.jobClusterName + '\'' + ", requestId=" + this.requestId + '}';
        }
    }

    public static final class EnableJobClusterResponse
    extends BaseResponse {
        public EnableJobClusterResponse(long requestId, BaseResponse.ResponseCode responseCode, String message) {
            super(requestId, responseCode, message);
        }

        public String toString() {
            return "EnableJobClusterResponse{requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class EnableJobClusterRequest
    extends BaseRequest {
        private final String user;
        private final String clusterName;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public EnableJobClusterRequest(@JsonProperty(value="name") String clusterName, @JsonProperty(value="user") String user) {
            Preconditions.checkArg((boolean)(user != null & !user.isEmpty()), (String)"Must provide user in request");
            Preconditions.checkArg((boolean)(clusterName != null & !clusterName.isEmpty()), (String)"Must provide job cluster name in request");
            this.user = user;
            this.clusterName = clusterName;
        }

        public String getUser() {
            return this.user;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public String toString() {
            return "EnableJobClusterRequest{user='" + this.user + '\'' + ", clusterName='" + this.clusterName + '\'' + ", requestId=" + this.requestId + '}';
        }
    }

    public static final class DisableJobClusterResponse
    extends BaseResponse {
        public DisableJobClusterResponse(long requestId, BaseResponse.ResponseCode responseCode, String message) {
            super(requestId, responseCode, message);
        }

        public String toString() {
            return "DisableJobClusterResponse{requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class DisableJobClusterRequest
    extends BaseRequest {
        private final String user;
        private final String clusterName;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public DisableJobClusterRequest(@JsonProperty(value="name") String clusterName, @JsonProperty(value="user") String user) {
            Preconditions.checkArg((boolean)(user != null & !user.isEmpty()), (String)"Must provide user in request");
            Preconditions.checkArg((boolean)(clusterName != null & !clusterName.isEmpty()), (String)"Must provide job cluster name in request");
            this.user = user;
            this.clusterName = clusterName;
        }

        public String getUser() {
            return this.user;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public String toString() {
            return "DisableJobClusterRequest{user='" + this.user + '\'' + ", clusterName='" + this.clusterName + '\'' + ", requestId=" + this.requestId + '}';
        }
    }

    public static final class UpdateJobClusterWorkerMigrationStrategyResponse
    extends BaseResponse {
        public UpdateJobClusterWorkerMigrationStrategyResponse(long requestId, BaseResponse.ResponseCode responseCode, String message) {
            super(requestId, responseCode, message);
        }

        public String toString() {
            return "UpdateJobClusterWorkerMigrationStrategyResponse{requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class UpdateJobClusterWorkerMigrationStrategyRequest
    extends BaseRequest {
        private final WorkerMigrationConfig migrationConfig;
        private final String clusterName;
        private final String user;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public UpdateJobClusterWorkerMigrationStrategyRequest(@JsonProperty(value="name") String clusterName, @JsonProperty(value="migrationConfig") WorkerMigrationConfig config, @JsonProperty(value="user") String user) {
            Preconditions.checkArg((boolean)(user != null & !user.isEmpty()), (String)"Must provide user in request");
            Preconditions.checkArg((boolean)(clusterName != null & !clusterName.isEmpty()), (String)"Must provide job cluster name in request");
            Preconditions.checkNotNull((Object)config, (String)"migrationConfig");
            this.migrationConfig = config;
            this.clusterName = clusterName;
            this.user = user;
        }

        public WorkerMigrationConfig getMigrationConfig() {
            return this.migrationConfig;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public String getUser() {
            return this.user;
        }

        public String toString() {
            return "UpdateJobClusterWorkerMigrationStrategyRequest{migrationConfig=" + this.migrationConfig + ", clusterName='" + this.clusterName + '\'' + ", user='" + this.user + '\'' + ", requestId=" + this.requestId + '}';
        }
    }

    public static final class UpdateJobClusterArtifactResponse
    extends BaseResponse {
        public UpdateJobClusterArtifactResponse(long requestId, BaseResponse.ResponseCode responseCode, String message) {
            super(requestId, responseCode, message);
        }

        public String toString() {
            return "UpdateJobClusterArtifactResponse{requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class UpdateSchedulingInfoResponse
    extends BaseResponse {
        public UpdateSchedulingInfoResponse(long requestId, BaseResponse.ResponseCode responseCode, String message) {
            super(requestId, responseCode, message);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateSchedulingInfoResponse)) {
                return false;
            }
            UpdateSchedulingInfoResponse other = (UpdateSchedulingInfoResponse)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateSchedulingInfoResponse;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public String toString() {
            return "JobClusterManagerProto.UpdateSchedulingInfoResponse()";
        }
    }

    public static final class UpdateJobClusterArtifactRequest
    extends BaseRequest {
        private final String artifactName;
        private final String version;
        private final boolean skipSubmit;
        private final String user;
        private final String clusterName;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public UpdateJobClusterArtifactRequest(@JsonProperty(value="name") String clusterName, @JsonProperty(value="url") String artifact, @JsonProperty(value="version") String version, @JsonProperty(value="skipsubmit") boolean skipSubmit, @JsonProperty(value="user") String user) {
            Preconditions.checkArg((boolean)(user != null & !user.isEmpty()), (String)"Must provide user in request");
            Preconditions.checkArg((boolean)(clusterName != null & !clusterName.isEmpty()), (String)"Must provide job cluster name in request");
            Preconditions.checkArg((artifact != null && !artifact.isEmpty() ? 1 : 0) != 0, (String)"Artifact cannot be null or empty");
            Preconditions.checkArg((version != null && !version.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null or empty");
            this.clusterName = clusterName;
            this.artifactName = artifact;
            this.version = version;
            this.skipSubmit = skipSubmit;
            this.user = user;
        }

        public String getArtifactName() {
            return this.artifactName;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isSkipSubmit() {
            return this.skipSubmit;
        }

        public String getUser() {
            return this.user;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public String toString() {
            return "UpdateJobClusterArtifactRequest{artifactName='" + this.artifactName + '\'' + ", version='" + this.version + '\'' + ", skipSubmit=" + this.skipSubmit + ", user='" + this.user + '\'' + ", clusterName='" + this.clusterName + '\'' + ", requestId=" + this.requestId + '}';
        }
    }

    public static final class UpdateSchedulingInfoRequest
    extends BaseRequest {
        private final SchedulingInfo schedulingInfo;
        private final String version;

        public UpdateSchedulingInfoRequest(@JsonProperty(value="schedulingInfo") SchedulingInfo schedulingInfo, @JsonProperty(value="version") String version) {
            this.schedulingInfo = schedulingInfo;
            this.version = version;
        }

        public String toString() {
            return "JobClusterManagerProto.UpdateSchedulingInfoRequest(schedulingInfo=" + this.getSchedulingInfo() + ", version=" + this.getVersion() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateSchedulingInfoRequest)) {
                return false;
            }
            UpdateSchedulingInfoRequest other = (UpdateSchedulingInfoRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SchedulingInfo this$schedulingInfo = this.getSchedulingInfo();
            SchedulingInfo other$schedulingInfo = other.getSchedulingInfo();
            if (this$schedulingInfo == null ? other$schedulingInfo != null : !this$schedulingInfo.equals(other$schedulingInfo)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateSchedulingInfoRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SchedulingInfo $schedulingInfo = this.getSchedulingInfo();
            result = result * 59 + ($schedulingInfo == null ? 43 : $schedulingInfo.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public SchedulingInfo getSchedulingInfo() {
            return this.schedulingInfo;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public static final class UpdateJobClusterLabelsResponse
    extends BaseResponse {
        public UpdateJobClusterLabelsResponse(long requestId, BaseResponse.ResponseCode responseCode, String message) {
            super(requestId, responseCode, message);
        }

        public String toString() {
            return "UpdateJobClusterLabelsResponse{requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class UpdateJobClusterLabelsRequest
    extends BaseRequest {
        private final List<Label> labels;
        private final String user;
        private final String clusterName;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public UpdateJobClusterLabelsRequest(@JsonProperty(value="name") String clusterName, @JsonProperty(value="labels") List<Label> labels, @JsonProperty(value="user") String user) {
            Preconditions.checkNotNull(labels, (String)"labels");
            Preconditions.checkArg((boolean)(user != null & !user.isEmpty()), (String)"Must provide user in request");
            Preconditions.checkArg((boolean)(clusterName != null & !clusterName.isEmpty()), (String)"Must provide job cluster name in request");
            this.labels = labels;
            this.user = user;
            this.clusterName = clusterName;
        }

        public List<Label> getLabels() {
            return this.labels;
        }

        public String getUser() {
            return this.user;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public String toString() {
            return "UpdateJobClusterLabelsRequest{labels=" + this.labels + ", user='" + this.user + '\'' + ", clusterName='" + this.clusterName + '\'' + ", requestId=" + this.requestId + '}';
        }
    }

    public static final class UpdateJobClusterSLAResponse
    extends BaseResponse {
        public UpdateJobClusterSLAResponse(long requestId, BaseResponse.ResponseCode responseCode, String message) {
            super(requestId, responseCode, message);
        }

        public String toString() {
            return "UpdateJobClusterSLAResponse{requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class UpdateJobClusterSLARequest
    extends BaseRequest {
        private final String clusterName;
        private final int min;
        private final int max;
        private final String cronSpec;
        private final IJobClusterDefinition.CronPolicy cronPolicy;
        private final boolean forceEnable;
        private final String user;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public UpdateJobClusterSLARequest(@JsonProperty(value="name") String name, @JsonProperty(value="min") Integer min, @JsonProperty(value="max") Integer max, @JsonProperty(value="cronspec") String cronSpec, @JsonProperty(value="cronpolicy") IJobClusterDefinition.CronPolicy cronPolicy, @JsonProperty(value="forceenable", defaultValue="false") boolean forceEnable, @JsonProperty(value="user") String user) {
            Preconditions.checkNotNull((Object)min, (String)"min");
            Preconditions.checkNotNull((Object)max, (String)"max");
            Preconditions.checkArg((boolean)(user != null & !user.isEmpty()), (String)"Must provide user in request");
            Preconditions.checkArg((boolean)(name != null & !name.isEmpty()), (String)"Must provide job cluster name in request");
            this.clusterName = name;
            this.max = max;
            this.min = min;
            this.cronSpec = cronSpec;
            this.cronPolicy = cronPolicy;
            this.forceEnable = forceEnable;
            this.user = user;
        }

        public UpdateJobClusterSLARequest(String name, int min, int max, String user) {
            this(name, min, max, null, null, false, user);
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public String getCronSpec() {
            return this.cronSpec;
        }

        public IJobClusterDefinition.CronPolicy getCronPolicy() {
            return this.cronPolicy;
        }

        public boolean isForceEnable() {
            return this.forceEnable;
        }

        public String getUser() {
            return this.user;
        }

        public String toString() {
            return "UpdateJobClusterSLARequest{clusterName='" + this.clusterName + '\'' + ", min=" + this.min + ", max=" + this.max + ", cronSpec='" + this.cronSpec + '\'' + ", cronPolicy=" + (Object)((Object)this.cronPolicy) + ", forceEnable=" + this.forceEnable + ", user='" + this.user + '\'' + ", requestId=" + this.requestId + '}';
        }
    }

    public static final class UpdateJobClusterResponse
    extends BaseResponse {
        public UpdateJobClusterResponse(long requestId, BaseResponse.ResponseCode responseCode, String message) {
            super(requestId, responseCode, message);
        }

        public String toString() {
            return "UpdateJobClusterResponse{requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class UpdateJobClusterRequest
    extends BaseRequest {
        private final JobClusterDefinitionImpl jobClusterDefinition;
        private final String user;

        public UpdateJobClusterRequest(JobClusterDefinitionImpl jobClusterDefinition, String user) {
            Preconditions.checkNotNull((Object)jobClusterDefinition, (String)"JobClusterDefinition cannot be null");
            Preconditions.checkArg((boolean)(user != null & !user.isEmpty()), (String)"Must provide user in request");
            this.jobClusterDefinition = jobClusterDefinition;
            this.user = user;
        }

        public JobClusterDefinitionImpl getJobClusterDefinition() {
            return this.jobClusterDefinition;
        }

        public String getUser() {
            return this.user;
        }

        public String toString() {
            return "UpdateJobClusterRequest{jobClusterDefinition=" + this.jobClusterDefinition + ", user='" + this.user + '\'' + ", requestId=" + this.requestId + '}';
        }
    }

    public static final class ListJobClustersResponse
    extends BaseResponse {
        private final List<MantisJobClusterMetadataView> jobClusters;

        public ListJobClustersResponse(long requestId, BaseResponse.ResponseCode responseCode, String message, List<MantisJobClusterMetadataView> jobClusters) {
            super(requestId, responseCode, message);
            this.jobClusters = jobClusters;
        }

        public List<MantisJobClusterMetadataView> getJobClusters() {
            return this.jobClusters;
        }

        public ListObject<MantisJobClusterMetadataView> getJobClusters(String regexMatcher, Integer limit, Integer offset, String sortField, Boolean sortAscending, Uri uri) {
            List<MantisJobClusterMetadataView> targetJobClusters = this.jobClusters;
            if (!Strings.isNullOrEmpty((String)regexMatcher)) {
                Pattern matcher = Pattern.compile(regexMatcher, 2);
                targetJobClusters = targetJobClusters.stream().filter(jobCluster -> matcher.matcher(jobCluster.getName()).find()).collect(Collectors.toList());
            }
            ListObject.Builder<MantisJobClusterMetadataView> builder = new ListObject.Builder<MantisJobClusterMetadataView>().withObjects(targetJobClusters, MantisJobClusterMetadataView.class);
            if (limit != null) {
                builder = builder.withLimit(limit);
            }
            if (offset != null) {
                builder = builder.withOffset(offset);
            }
            if (sortField != null) {
                builder = builder.withSortField(sortField);
            }
            if (sortAscending != null) {
                builder = builder.withSortAscending(sortAscending);
            }
            if (uri != null) {
                builder = builder.withUri(uri);
            }
            return builder.build();
        }

        public String toString() {
            return "ListJobClustersResponse{jobClusters=" + this.jobClusters + ", requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class ListJobClustersRequest
    extends BaseRequest {
    }

    public static final class JobClustersManagerInitializeResponse
    extends BaseResponse {
        public JobClustersManagerInitializeResponse(long requestId, BaseResponse.ResponseCode responseCode, String message) {
            super(requestId, responseCode, message);
        }

        public String toString() {
            return "JobClustersManagerInitializeResponse{requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class JobClustersManagerInitialize
    extends BaseRequest {
        private final MantisSchedulerFactory schedulerFactory;
        private final boolean loadJobsFromStore;

        public JobClustersManagerInitialize(MantisSchedulerFactory schedulerFactory, boolean loadJobsFromStore) {
            Preconditions.checkNotNull((Object)schedulerFactory, (String)"MantisScheduler cannot be null");
            this.schedulerFactory = schedulerFactory;
            this.loadJobsFromStore = loadJobsFromStore;
        }

        public MantisSchedulerFactory getScheduler() {
            return this.schedulerFactory;
        }

        public boolean isLoadJobsFromStore() {
            return this.loadJobsFromStore;
        }
    }

    public static final class DeleteJobClusterResponse
    extends BaseResponse {
        public DeleteJobClusterResponse(long requestId, BaseResponse.ResponseCode responseCode, String message) {
            super(requestId, responseCode, message);
        }
    }

    public static final class DeleteJobClusterRequest
    extends BaseRequest {
        private final String name;
        private final String user;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public DeleteJobClusterRequest(@JsonProperty(value="user") String user, @JsonProperty(value="name") String name) {
            Preconditions.checkArg((boolean)(user != null & !user.isEmpty()), (String)"Must provide user in request");
            Preconditions.checkArg((boolean)(name != null & !name.isEmpty()), (String)"Must provide job cluster name in request");
            this.user = user;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getUser() {
            return this.user;
        }
    }

    public static final class CreateJobClusterResponse
    extends BaseResponse {
        private final String jobClusterName;

        public CreateJobClusterResponse(long requestId, BaseResponse.ResponseCode responseCode, String message, String jobClusterName) {
            super(requestId, responseCode, message);
            this.jobClusterName = jobClusterName;
        }

        public String getJobClusterName() {
            return this.jobClusterName;
        }

        public String toString() {
            return "CreateJobClusterResponse{jobClusterName='" + this.jobClusterName + '\'' + ", requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message='" + this.message + '\'' + '}';
        }
    }

    public static final class ReconcileJobCluster {
        public final Instant timeOfEnforcement;

        public ReconcileJobCluster(Instant now) {
            this.timeOfEnforcement = now;
        }

        public ReconcileJobCluster() {
            this.timeOfEnforcement = Instant.now();
        }
    }

    public static final class CreateJobClusterRequest
    extends BaseRequest {
        private final JobClusterDefinitionImpl jobClusterDefinition;
        private final String user;

        public CreateJobClusterRequest(JobClusterDefinitionImpl jobClusterDefinition, String user) {
            Preconditions.checkNotNull((Object)jobClusterDefinition, (String)"JobClusterDefn cannot be null");
            this.jobClusterDefinition = jobClusterDefinition;
            this.user = user;
        }

        public JobClusterDefinitionImpl getJobClusterDefinition() {
            return this.jobClusterDefinition;
        }

        public String getUser() {
            return this.user;
        }
    }
}

