/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster;

import io.mantisrx.master.resourcecluster.ResourceClusterActor;
import io.mantisrx.master.resourcecluster.TaskExecutorState;
import io.mantisrx.master.resourcecluster.proto.GetClusterIdleInstancesRequest;
import io.mantisrx.master.resourcecluster.proto.GetClusterUsageResponse;
import io.mantisrx.server.master.resourcecluster.ResourceCluster;
import io.mantisrx.server.master.resourcecluster.TaskExecutorID;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;

interface ExecutorStateManager {
    public static final Predicate<Map.Entry<TaskExecutorID, TaskExecutorState>> isRegistered = e -> ((TaskExecutorState)e.getValue()).isRegistered();
    public static final Predicate<Map.Entry<TaskExecutorID, TaskExecutorState>> isBusy = e -> ((TaskExecutorState)e.getValue()).isRunningTask();
    public static final Predicate<Map.Entry<TaskExecutorID, TaskExecutorState>> unregistered = e -> ((TaskExecutorState)e.getValue()).isDisconnected();
    public static final Predicate<Map.Entry<TaskExecutorID, TaskExecutorState>> isAvailable = e -> ((TaskExecutorState)e.getValue()).isAvailable();
    public static final Predicate<Map.Entry<TaskExecutorID, TaskExecutorState>> isDisabled = e -> ((TaskExecutorState)e.getValue()).isDisabled();
    public static final Predicate<Map.Entry<TaskExecutorID, TaskExecutorState>> isAssigned = e -> ((TaskExecutorState)e.getValue()).isAssigned();

    public void trackIfAbsent(TaskExecutorID var1, TaskExecutorState var2);

    public boolean tryMarkAvailable(TaskExecutorID var1);

    public boolean tryMarkUnavailable(TaskExecutorID var1);

    @Nullable
    public TaskExecutorState get(TaskExecutorID var1);

    @Nullable
    public TaskExecutorState getIncludeArchived(TaskExecutorID var1);

    @Nullable
    public TaskExecutorState archive(TaskExecutorID var1);

    public ResourceCluster.ResourceOverview getResourceOverview();

    public GetClusterUsageResponse getClusterUsage(ResourceClusterActor.GetClusterUsageRequest var1);

    public List<TaskExecutorID> getIdleInstanceList(GetClusterIdleInstancesRequest var1);

    public List<TaskExecutorID> getTaskExecutors(Predicate<Map.Entry<TaskExecutorID, TaskExecutorState>> var1);

    public List<String> getActiveJobs(ResourceClusterActor.GetActiveJobsRequest var1);

    public Optional<Map.Entry<TaskExecutorID, TaskExecutorState>> findFirst(Predicate<Map.Entry<TaskExecutorID, TaskExecutorState>> var1);

    public Optional<ResourceClusterActor.BestFit> findBestFit(ResourceClusterActor.TaskExecutorBatchAssignmentRequest var1);

    public Set<Map.Entry<TaskExecutorID, TaskExecutorState>> getActiveExecutorEntry();
}

