/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster;

import akka.actor.AbstractActor;
import akka.actor.AbstractActorWithTimers;
import akka.actor.ActorRef;
import akka.actor.OneForOneStrategy;
import akka.actor.Props;
import akka.actor.Status;
import akka.actor.SupervisorStrategy;
import akka.japi.pf.DeciderBuilder;
import akka.japi.pf.ReceiveBuilder;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.TagList;
import io.mantisrx.common.Ack;
import io.mantisrx.master.resourcecluster.DisableTaskExecutorsRequest;
import io.mantisrx.master.resourcecluster.ExecutorStateManager;
import io.mantisrx.master.resourcecluster.ExecutorStateManagerImpl;
import io.mantisrx.master.resourcecluster.ResourceClusterActorMetrics;
import io.mantisrx.master.resourcecluster.TaskExecutorState;
import io.mantisrx.master.resourcecluster.proto.GetClusterIdleInstancesRequest;
import io.mantisrx.master.resourcecluster.proto.GetClusterIdleInstancesResponse;
import io.mantisrx.master.scheduler.FitnessCalculator;
import io.mantisrx.server.core.CacheJobArtifactsRequest;
import io.mantisrx.server.core.domain.ArtifactID;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.core.scheduler.SchedulingConstraints;
import io.mantisrx.server.master.persistence.MantisJobStore;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ContainerSkuID;
import io.mantisrx.server.master.resourcecluster.PagedActiveJobOverview;
import io.mantisrx.server.master.resourcecluster.ResourceCluster;
import io.mantisrx.server.master.resourcecluster.TaskExecutorAllocationRequest;
import io.mantisrx.server.master.resourcecluster.TaskExecutorDisconnection;
import io.mantisrx.server.master.resourcecluster.TaskExecutorHeartbeat;
import io.mantisrx.server.master.resourcecluster.TaskExecutorID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorRegistration;
import io.mantisrx.server.master.resourcecluster.TaskExecutorReport;
import io.mantisrx.server.master.resourcecluster.TaskExecutorStatusChange;
import io.mantisrx.server.master.scheduler.JobMessageRouter;
import io.mantisrx.server.worker.TaskExecutorGateway;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.collect.Comparators;
import io.mantisrx.shaded.com.google.common.collect.ImmutableList;
import io.mantisrx.shaded.com.google.common.collect.ImmutableMap;
import io.vavr.Tuple;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.runtime.rpc.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceClusterActor
extends AbstractActorWithTimers {
    private static final Logger log = LoggerFactory.getLogger(ResourceClusterActor.class);
    private static SupervisorStrategy resourceClusterActorStrategy = new OneForOneStrategy(3, Duration.ofSeconds(60L), DeciderBuilder.match(Exception.class, e -> SupervisorStrategy.restart()).build());
    private final Duration heartbeatTimeout;
    private final Duration assignmentTimeout;
    private final Duration disabledTaskExecutorsCheckInterval;
    private final ExecutorStateManager executorStateManager;
    private final Clock clock;
    private final RpcService rpcService;
    private final ClusterID clusterID;
    private final MantisJobStore mantisJobStore;
    private final Set<DisableTaskExecutorsRequest> activeDisableTaskExecutorsByAttributesRequests;
    private final Set<TaskExecutorID> disabledTaskExecutors;
    private final JobMessageRouter jobMessageRouter;
    private final ResourceClusterActorMetrics metrics;
    private final HashSet<ArtifactID> jobArtifactsToCache = new HashSet();
    private final int maxJobArtifactsToCache;
    private final String jobClustersWithArtifactCachingEnabled;
    private final boolean isJobArtifactCachingEnabled;

    public SupervisorStrategy supervisorStrategy() {
        return resourceClusterActorStrategy;
    }

    static Props props(ClusterID clusterID, Duration heartbeatTimeout, Duration assignmentTimeout, Duration disabledTaskExecutorsCheckInterval, Clock clock, RpcService rpcService, MantisJobStore mantisJobStore, JobMessageRouter jobMessageRouter, int maxJobArtifactsToCache, String jobClustersWithArtifactCachingEnabled, boolean isJobArtifactCachingEnabled, Map<String, String> schedulingAttributes, FitnessCalculator fitnessCalculator) {
        return Props.create(ResourceClusterActor.class, (Object[])new Object[]{clusterID, heartbeatTimeout, assignmentTimeout, disabledTaskExecutorsCheckInterval, clock, rpcService, mantisJobStore, jobMessageRouter, maxJobArtifactsToCache, jobClustersWithArtifactCachingEnabled, isJobArtifactCachingEnabled, schedulingAttributes, fitnessCalculator}).withMailbox("akka.actor.metered-mailbox");
    }

    ResourceClusterActor(ClusterID clusterID, Duration heartbeatTimeout, Duration assignmentTimeout, Duration disabledTaskExecutorsCheckInterval, Clock clock, RpcService rpcService, MantisJobStore mantisJobStore, JobMessageRouter jobMessageRouter, int maxJobArtifactsToCache, String jobClustersWithArtifactCachingEnabled, boolean isJobArtifactCachingEnabled, Map<String, String> schedulingAttributes, FitnessCalculator fitnessCalculator) {
        this.clusterID = clusterID;
        this.heartbeatTimeout = heartbeatTimeout;
        this.assignmentTimeout = assignmentTimeout;
        this.disabledTaskExecutorsCheckInterval = disabledTaskExecutorsCheckInterval;
        this.isJobArtifactCachingEnabled = isJobArtifactCachingEnabled;
        this.clock = clock;
        this.rpcService = rpcService;
        this.jobMessageRouter = jobMessageRouter;
        this.mantisJobStore = mantisJobStore;
        this.activeDisableTaskExecutorsByAttributesRequests = new HashSet<DisableTaskExecutorsRequest>();
        this.disabledTaskExecutors = new HashSet<TaskExecutorID>();
        this.maxJobArtifactsToCache = maxJobArtifactsToCache;
        this.jobClustersWithArtifactCachingEnabled = jobClustersWithArtifactCachingEnabled;
        this.executorStateManager = new ExecutorStateManagerImpl(schedulingAttributes, fitnessCalculator);
        this.metrics = new ResourceClusterActorMetrics();
    }

    public void preStart() throws Exception {
        super.preStart();
        this.metrics.incrementCounter("resourceClusterActorRestart", (Iterable<Tag>)TagList.create((Map)ImmutableMap.of((Object)"resourceCluster", (Object)this.clusterID.getResourceID())));
        this.fetchJobArtifactsToCache();
        List<DisableTaskExecutorsRequest> activeRequests = this.mantisJobStore.loadAllDisableTaskExecutorsRequests(this.clusterID);
        for (DisableTaskExecutorsRequest request : activeRequests) {
            this.onNewDisableTaskExecutorsRequest(request);
        }
        this.timers().startTimerWithFixedDelay((Object)String.format("periodic-disabled-task-executors-test-for-%s", this.clusterID.getResourceID()), (Object)new CheckDisabledTaskExecutors("periodic"), this.disabledTaskExecutorsCheckInterval);
        this.timers().startTimerWithFixedDelay((Object)"periodic-resource-overview-metrics-publisher", (Object)new PublishResourceOverviewMetricsRequest(), Duration.ofMinutes(1L));
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(GetRegisteredTaskExecutorsRequest.class, req -> this.sender().tell((Object)this.getTaskExecutors(this.filterByAttrs((HasAttributes)req).and(ExecutorStateManager.isRegistered)), this.self())).match(GetBusyTaskExecutorsRequest.class, req -> this.sender().tell((Object)this.getTaskExecutors(this.filterByAttrs((HasAttributes)req).and(ExecutorStateManager.isBusy)), this.self())).match(GetAvailableTaskExecutorsRequest.class, req -> this.sender().tell((Object)this.getTaskExecutors(this.filterByAttrs((HasAttributes)req).and(ExecutorStateManager.isAvailable)), this.self())).match(GetDisabledTaskExecutorsRequest.class, req -> this.sender().tell((Object)this.getTaskExecutors(this.filterByAttrs((HasAttributes)req).and(ExecutorStateManager.isDisabled)), this.self())).match(GetUnregisteredTaskExecutorsRequest.class, req -> this.sender().tell((Object)this.getTaskExecutors(this.filterByAttrs((HasAttributes)req).and(ExecutorStateManager.unregistered)), this.self())).match(GetActiveJobsRequest.class, this::getActiveJobs).match(GetTaskExecutorStatusRequest.class, this::getTaskExecutorStatus).match(GetClusterUsageRequest.class, this.metrics.withTracking(req -> this.sender().tell((Object)this.executorStateManager.getClusterUsage((GetClusterUsageRequest)req), this.self()))).match(GetClusterIdleInstancesRequest.class, this.metrics.withTracking(req -> this.sender().tell((Object)this.onGetClusterIdleInstancesRequest((GetClusterIdleInstancesRequest)req), this.self()))).match(GetAssignedTaskExecutorRequest.class, this::onAssignedTaskExecutorRequest).match(Ack.class, ack -> log.info("Received ack from {}", (Object)this.sender())).match(TaskExecutorAssignmentTimeout.class, this::onTaskExecutorAssignmentTimeout).match(TaskExecutorRegistration.class, this.metrics.withTracking(this::onTaskExecutorRegistration)).match(InitializeTaskExecutorRequest.class, this.metrics.withTracking(this::onTaskExecutorInitialization)).match(TaskExecutorHeartbeat.class, this.metrics.withTracking(this::onHeartbeat)).match(TaskExecutorStatusChange.class, this::onTaskExecutorStatusChange).match(TaskExecutorDisconnection.class, this.metrics.withTracking(this::onTaskExecutorDisconnection)).match(HeartbeatTimeout.class, this.metrics.withTracking(this::onTaskExecutorHeartbeatTimeout)).match(TaskExecutorBatchAssignmentRequest.class, this.metrics.withTracking(this::onTaskExecutorBatchAssignmentRequest)).match(ResourceOverviewRequest.class, this::onResourceOverviewRequest).match(TaskExecutorInfoRequest.class, this::onTaskExecutorInfoRequest).match(TaskExecutorGatewayRequest.class, this.metrics.withTracking(this::onTaskExecutorGatewayRequest)).match(DisableTaskExecutorsRequest.class, this::onNewDisableTaskExecutorsRequest).match(CheckDisabledTaskExecutors.class, this::findAndMarkDisabledTaskExecutors).match(ExpireDisableTaskExecutorsRequest.class, this::onDisableTaskExecutorsRequestExpiry).match(GetTaskExecutorWorkerMappingRequest.class, req -> this.sender().tell(this.getTaskExecutorWorkerMapping(req.getAttributes()), this.self())).match(PublishResourceOverviewMetricsRequest.class, this::onPublishResourceOverviewMetricsRequest).match(CacheJobArtifactsOnTaskExecutorRequest.class, this.metrics.withTracking(this::onCacheJobArtifactsOnTaskExecutorRequest)).match(AddNewJobArtifactsToCacheRequest.class, this::onAddNewJobArtifactsToCacheRequest).match(RemoveJobArtifactsToCacheRequest.class, this::onRemoveJobArtifactsToCacheRequest).match(GetJobArtifactsToCacheRequest.class, req -> this.sender().tell((Object)new ArtifactList(new ArrayList<ArtifactID>(this.jobArtifactsToCache)), this.self())).build();
    }

    private void onAddNewJobArtifactsToCacheRequest(AddNewJobArtifactsToCacheRequest req) {
        try {
            HashSet newArtifacts = new HashSet(req.artifacts);
            newArtifacts.removeAll(this.jobArtifactsToCache);
            if (!newArtifacts.isEmpty()) {
                if (this.jobArtifactsToCache.size() < this.maxJobArtifactsToCache) {
                    log.info("Storing and caching new artifacts: {}", newArtifacts);
                    this.jobArtifactsToCache.addAll(newArtifacts);
                    this.mantisJobStore.addNewJobArtifactsToCache(req.getClusterID(), (List<ArtifactID>)ImmutableList.copyOf(this.jobArtifactsToCache));
                    this.refreshTaskExecutorJobArtifactCache();
                } else {
                    log.warn("Cannot enable caching for artifacts {}. Max number ({}) of job artifacts to cache reached.", newArtifacts, (Object)this.maxJobArtifactsToCache);
                    this.metrics.incrementCounter("maxJobArtifactsToCacheReached", (Iterable<Tag>)TagList.create((Map)ImmutableMap.of((Object)"resourceCluster", (Object)this.clusterID.getResourceID())));
                }
            }
            this.sender().tell((Object)Ack.getInstance(), this.self());
        }
        catch (IOException e) {
            log.warn("Cannot add new job artifacts {} to cache in cluster: {}", new Object[]{req.getArtifacts(), req.getClusterID(), e});
        }
    }

    private void refreshTaskExecutorJobArtifactCache() {
        this.getTaskExecutors(ExecutorStateManager.isAvailable).getTaskExecutors().forEach(taskExecutorID -> this.self().tell((Object)new CacheJobArtifactsOnTaskExecutorRequest((TaskExecutorID)taskExecutorID, this.clusterID), this.self()));
    }

    private void onRemoveJobArtifactsToCacheRequest(RemoveJobArtifactsToCacheRequest req) {
        try {
            this.mantisJobStore.removeJobArtifactsToCache(req.getClusterID(), req.getArtifacts());
            req.artifacts.forEach(this.jobArtifactsToCache::remove);
            this.sender().tell((Object)Ack.getInstance(), this.self());
        }
        catch (IOException e) {
            log.warn("Cannot remove job artifacts {} to cache in cluster: {}", new Object[]{req.getArtifacts(), req.getClusterID(), e});
        }
    }

    private void fetchJobArtifactsToCache() {
        try {
            this.mantisJobStore.getJobArtifactsToCache(this.clusterID).stream().map(ArtifactID::of).forEach(this.jobArtifactsToCache::add);
        }
        catch (IOException e) {
            log.warn("Cannot refresh job artifacts to cache in cluster: {}", (Object)this.clusterID, (Object)e);
        }
    }

    private GetClusterIdleInstancesResponse onGetClusterIdleInstancesRequest(GetClusterIdleInstancesRequest req) {
        log.info("Computing idle instance list: {}", (Object)req);
        if (!req.getClusterID().equals((Object)this.clusterID)) {
            throw new RuntimeException(String.format("Mismatch cluster ids %s, %s", req.getClusterID(), this.clusterID));
        }
        List<TaskExecutorID> instanceList = this.executorStateManager.getIdleInstanceList(req);
        GetClusterIdleInstancesResponse res = GetClusterIdleInstancesResponse.builder().instanceIds(instanceList).clusterId(this.clusterID).skuId(req.getSkuId()).build();
        log.info("Return idle instance list: {}", (Object)res);
        return res;
    }

    private TaskExecutorsList getTaskExecutors(Predicate<Map.Entry<TaskExecutorID, TaskExecutorState>> predicate) {
        return new TaskExecutorsList(this.executorStateManager.getTaskExecutors(predicate));
    }

    private void getActiveJobs(GetActiveJobsRequest req) {
        List<String> pagedList = this.executorStateManager.getActiveJobs(req);
        PagedActiveJobOverview res = new PagedActiveJobOverview(pagedList, req.getStartingIndex().orElse(0) + pagedList.size());
        log.info("Returning getActiveJobs res starting at {}: {}", req.getStartingIndex(), (Object)res.getActiveJobs().size());
        this.sender().tell((Object)res, this.self());
    }

    private void onTaskExecutorInfoRequest(TaskExecutorInfoRequest request) {
        if (request.getTaskExecutorID() != null) {
            TaskExecutorState state = this.executorStateManager.getIncludeArchived(request.getTaskExecutorID());
            if (state != null && state.getRegistration() != null) {
                this.sender().tell((Object)state.getRegistration(), this.self());
            } else {
                this.sender().tell((Object)new Status.Failure((Throwable)new Exception(String.format("No task executor state for %s", request.getTaskExecutorID()))), this.self());
            }
        } else {
            Optional<TaskExecutorRegistration> taskExecutorRegistration = this.executorStateManager.findFirst(kv -> ((TaskExecutorState)kv.getValue()).getRegistration() != null && ((TaskExecutorState)kv.getValue()).getRegistration().getHostname().equals(request.getHostName())).map(Map.Entry::getValue).map(TaskExecutorState::getRegistration);
            if (taskExecutorRegistration.isPresent()) {
                this.sender().tell((Object)taskExecutorRegistration.get(), this.self());
            } else {
                this.sender().tell((Object)new Status.Failure((Throwable)new Exception(String.format("Unknown task executor for hostname %s", request.getHostName()))), this.self());
            }
        }
    }

    private void onAssignedTaskExecutorRequest(GetAssignedTaskExecutorRequest request) {
        Optional<TaskExecutorID> matchedTaskExecutor = this.executorStateManager.findFirst(e -> ((TaskExecutorState)e.getValue()).isRunningOrAssigned(request.getWorkerId())).map(Map.Entry::getKey);
        if (matchedTaskExecutor.isPresent()) {
            this.sender().tell((Object)matchedTaskExecutor.get(), this.self());
        } else {
            this.sender().tell((Object)new Status.Failure((Throwable)new TaskExecutorGateway.TaskNotFoundException(request.getWorkerId())), this.self());
        }
    }

    private void onTaskExecutorGatewayRequest(TaskExecutorGatewayRequest request) {
        TaskExecutorState state = this.executorStateManager.get(request.getTaskExecutorID());
        if (state == null) {
            this.sender().tell((Object)new NullPointerException("Null TaskExecutorState for: " + request.getTaskExecutorID()), this.self());
        } else {
            try {
                if (state.isRegistered()) {
                    this.sender().tell(state.getGatewayAsync(), this.self());
                } else {
                    this.sender().tell((Object)new Status.Failure((Throwable)new IllegalStateException("Unregistered TaskExecutor: " + request.getTaskExecutorID())), this.self());
                }
            }
            catch (Exception e) {
                log.error("onTaskExecutorGatewayRequest error: {}", (Object)request, (Object)e);
                this.metrics.incrementCounter("taskExecutorConnectionFailure", (Iterable<Tag>)TagList.create((Map)ImmutableMap.of((Object)"resourceCluster", (Object)this.clusterID.getResourceID(), (Object)"taskExecutor", (Object)request.getTaskExecutorID().getResourceId())));
            }
        }
    }

    private boolean addNewDisableTaskExecutorsRequest(DisableTaskExecutorsRequest newRequest) {
        if (newRequest.isRequestByAttributes()) {
            log.info("Req with attributes {}", (Object)newRequest);
            for (DisableTaskExecutorsRequest existing : this.activeDisableTaskExecutorsByAttributesRequests) {
                if (!existing.targetsSameTaskExecutorsAs(newRequest)) continue;
                return false;
            }
            Preconditions.checkState((boolean)this.activeDisableTaskExecutorsByAttributesRequests.add(newRequest), (String)"activeDisableTaskExecutorRequests cannot contain %s", (Object)newRequest);
            return true;
        }
        if (newRequest.getTaskExecutorID().isPresent() && !this.disabledTaskExecutors.contains(newRequest.getTaskExecutorID().get())) {
            log.info("Req with id {}", (Object)newRequest);
            this.disabledTaskExecutors.add(newRequest.getTaskExecutorID().get());
            return true;
        }
        log.info("No Req {}", (Object)newRequest);
        return false;
    }

    private void onNewDisableTaskExecutorsRequest(DisableTaskExecutorsRequest request) {
        ActorRef sender = this.sender();
        if (this.addNewDisableTaskExecutorsRequest(request)) {
            try {
                log.info("New req to add {}", (Object)request);
                this.mantisJobStore.storeNewDisabledTaskExecutorsRequest(request);
                Duration toExpiry = (Duration)Comparators.max((Comparable)Duration.between(this.clock.instant(), request.getExpiry()), (Comparable)Duration.ZERO);
                this.getTimers().startSingleTimer((Object)this.getExpiryKeyFor(request), (Object)new ExpireDisableTaskExecutorsRequest(request), toExpiry);
                this.findAndMarkDisabledTaskExecutorsFor(request);
                sender.tell((Object)Ack.getInstance(), this.self());
            }
            catch (IOException e) {
                this.sender().tell((Object)new Status.Failure((Throwable)e), this.self());
            }
        } else {
            sender.tell((Object)Ack.getInstance(), this.self());
        }
    }

    private String getExpiryKeyFor(DisableTaskExecutorsRequest request) {
        return "ExpireDisableTaskExecutorsRequest-" + request;
    }

    private void findAndMarkDisabledTaskExecutorsFor(DisableTaskExecutorsRequest request) {
        if (request.isRequestByAttributes()) {
            this.findAndMarkDisabledTaskExecutors(new CheckDisabledTaskExecutors("new_request"));
        } else if (request.getTaskExecutorID().isPresent()) {
            TaskExecutorID taskExecutorID = request.getTaskExecutorID().get();
            TaskExecutorState state = this.executorStateManager.get(taskExecutorID);
            if (state == null) {
                this.disabledTaskExecutors.remove(taskExecutorID);
                this.self().tell((Object)new ExpireDisableTaskExecutorsRequest(request), this.self());
            } else {
                log.info("Marking task executor {} as disabled", (Object)taskExecutorID);
                state.onNodeDisabled();
            }
        }
    }

    private void findAndMarkDisabledTaskExecutors(CheckDisabledTaskExecutors r) {
        log.info("Checking disabled task executors for Cluster {} because of {}. Current disabled request size: {}", new Object[]{this.clusterID.getResourceID(), r.getReason(), this.activeDisableTaskExecutorsByAttributesRequests.size()});
        Instant now = this.clock.instant();
        for (DisableTaskExecutorsRequest request : this.activeDisableTaskExecutorsByAttributesRequests) {
            if (request.isExpired(now)) {
                this.self().tell((Object)new ExpireDisableTaskExecutorsRequest(request), this.self());
                continue;
            }
            this.executorStateManager.getActiveExecutorEntry().forEach(idAndState -> {
                if (request.covers(((TaskExecutorState)idAndState.getValue()).getRegistration()) && ((TaskExecutorState)idAndState.getValue()).onNodeDisabled()) {
                    log.info("Marking task executor {} as disabled", idAndState.getKey());
                }
            });
        }
    }

    private void onDisableTaskExecutorsRequestExpiry(ExpireDisableTaskExecutorsRequest request) {
        try {
            log.info("Expiring Disable Task Executors Request {}", (Object)request.getRequest());
            this.getTimers().cancel((Object)this.getExpiryKeyFor(request.getRequest()));
            if (this.activeDisableTaskExecutorsByAttributesRequests.remove(request.getRequest()) || request.getRequest().getTaskExecutorID().isPresent() && this.disabledTaskExecutors.remove(request.getRequest().getTaskExecutorID().get())) {
                this.mantisJobStore.deleteExpiredDisableTaskExecutorsRequest(request.getRequest());
            }
        }
        catch (Exception e) {
            log.error("Failed to delete expired {}", (Object)request.getRequest());
        }
    }

    private Map<TaskExecutorID, WorkerId> getTaskExecutorWorkerMapping(Map<String, String> attributes) {
        HashMap<TaskExecutorID, WorkerId> result = new HashMap<TaskExecutorID, WorkerId>();
        this.executorStateManager.getActiveExecutorEntry().forEach(idAndState -> {
            if (((TaskExecutorState)idAndState.getValue()).getRegistration() != null && ((TaskExecutorState)idAndState.getValue()).getRegistration().containsAttributes(attributes) && ((TaskExecutorState)idAndState.getValue()).isRunningTask()) {
                result.put((TaskExecutorID)idAndState.getKey(), ((TaskExecutorState)idAndState.getValue()).getWorkerId());
            }
        });
        return result;
    }

    private void onTaskExecutorInitialization(InitializeTaskExecutorRequest request) {
        log.info("Initializing taskExecutor {} for the resource cluster {}", (Object)request.getTaskExecutorID(), (Object)this);
        ActorRef sender = this.sender();
        try {
            TaskExecutorRegistration registration = this.mantisJobStore.getTaskExecutor(request.getTaskExecutorID());
            this.setupTaskExecutorStateIfNecessary(request.getTaskExecutorID());
            this.self().tell((Object)registration, this.self());
            this.self().tell((Object)new TaskExecutorStatusChange(registration.getTaskExecutorID(), registration.getClusterID(), (TaskExecutorReport)TaskExecutorReport.occupied((WorkerId)request.getWorkerId())), this.self());
            sender.tell((Object)Ack.getInstance(), this.self());
        }
        catch (Exception e) {
            log.error("Failed to initialize taskExecutor {}; all retries exhausted", (Object)request.getTaskExecutorID(), (Object)e);
            sender.tell((Object)new Status.Failure((Throwable)e), this.self());
        }
    }

    private void onTaskExecutorRegistration(TaskExecutorRegistration registration) {
        this.setupTaskExecutorStateIfNecessary(registration.getTaskExecutorID());
        log.info("Request for registering on resource cluster {}: {}.", (Object)this, (Object)registration);
        try {
            TaskExecutorID taskExecutorID = registration.getTaskExecutorID();
            TaskExecutorState state = this.executorStateManager.get(taskExecutorID);
            boolean stateChange = state.onRegistration(registration);
            this.mantisJobStore.storeNewTaskExecutor(registration);
            if (stateChange) {
                if (state.isAvailable()) {
                    this.executorStateManager.tryMarkAvailable(taskExecutorID);
                }
                if (this.isTaskExecutorDisabled(registration)) {
                    log.info("Newly registered task executor {} was already marked for disabling.", (Object)registration.getTaskExecutorID());
                    state.onNodeDisabled();
                }
                this.updateHeartbeatTimeout(registration.getTaskExecutorID());
            }
            log.info("Successfully registered {} with the resource cluster {}", (Object)registration.getTaskExecutorID(), (Object)this);
            if (!this.jobArtifactsToCache.isEmpty() && this.isJobArtifactCachingEnabled) {
                this.self().tell((Object)new CacheJobArtifactsOnTaskExecutorRequest(taskExecutorID, this.clusterID), this.self());
            }
            this.sender().tell((Object)Ack.getInstance(), this.self());
        }
        catch (Exception e) {
            this.sender().tell((Object)new Status.Failure((Throwable)e), this.self());
        }
    }

    private boolean isTaskExecutorDisabled(TaskExecutorRegistration registration) {
        for (DisableTaskExecutorsRequest request : this.activeDisableTaskExecutorsByAttributesRequests) {
            if (!request.covers(registration)) continue;
            return true;
        }
        return this.disabledTaskExecutors.contains(registration.getTaskExecutorID());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onHeartbeat(TaskExecutorHeartbeat heartbeat) {
        log.debug("Received heartbeat {} from task executor {}", (Object)heartbeat, (Object)heartbeat.getTaskExecutorID());
        this.setupTaskExecutorStateIfNecessary(heartbeat.getTaskExecutorID());
        try {
            TaskExecutorID taskExecutorID = heartbeat.getTaskExecutorID();
            TaskExecutorState state = this.executorStateManager.get(taskExecutorID);
            if (state.getRegistration() == null || !state.isRegistered()) {
                TaskExecutorRegistration registration = this.mantisJobStore.getTaskExecutor(heartbeat.getTaskExecutorID());
                if (registration == null) {
                    log.warn("Received heartbeat from unknown task executor {}", (Object)heartbeat.getTaskExecutorID());
                    this.sender().tell((Object)new Status.Failure((Throwable)new ResourceCluster.TaskExecutorNotFoundException(taskExecutorID)), this.self());
                    return;
                }
                log.debug("Found registration {} for task executor {}", (Object)registration, (Object)heartbeat.getTaskExecutorID());
                Preconditions.checkState((boolean)state.onRegistration(registration));
                if (this.isTaskExecutorDisabled(registration)) {
                    log.info("Reconnected task executor {} was already marked for disabling.", (Object)registration.getTaskExecutorID());
                    state.onNodeDisabled();
                }
            } else {
                log.debug("Found registration {} for registered task executor {}", (Object)state.getRegistration(), (Object)heartbeat.getTaskExecutorID());
            }
            boolean stateChange = state.onHeartbeat(heartbeat);
            if (stateChange && state.isAvailable()) {
                this.executorStateManager.tryMarkAvailable(taskExecutorID);
            }
            this.updateHeartbeatTimeout(heartbeat.getTaskExecutorID());
            log.debug("Successfully processed heartbeat {} from task executor {}", (Object)heartbeat, (Object)heartbeat.getTaskExecutorID());
            this.sender().tell((Object)Ack.getInstance(), this.self());
            return;
        }
        catch (Exception e) {
            this.sender().tell((Object)new Status.Failure((Throwable)e), this.self());
        }
    }

    private void onTaskExecutorStatusChange(TaskExecutorStatusChange statusChange) {
        this.setupTaskExecutorStateIfNecessary(statusChange.getTaskExecutorID());
        try {
            TaskExecutorID taskExecutorID = statusChange.getTaskExecutorID();
            TaskExecutorState state = this.executorStateManager.get(taskExecutorID);
            boolean stateChange = state.onTaskExecutorStatusChange(statusChange);
            if (stateChange) {
                if (state.isAvailable()) {
                    this.executorStateManager.tryMarkAvailable(taskExecutorID);
                } else {
                    this.executorStateManager.tryMarkUnavailable(taskExecutorID);
                }
            }
            this.updateHeartbeatTimeout(statusChange.getTaskExecutorID());
            this.sender().tell((Object)Ack.getInstance(), this.self());
        }
        catch (IllegalStateException e) {
            this.sender().tell((Object)new Status.Failure((Throwable)e), this.self());
        }
    }

    private void onTaskExecutorBatchAssignmentRequest(TaskExecutorBatchAssignmentRequest request) {
        Optional<BestFit> matchedExecutors = this.executorStateManager.findBestFit(request);
        if (matchedExecutors.isPresent()) {
            log.info("Matched all executors {} for request {}", (Object)matchedExecutors.get(), (Object)request);
            matchedExecutors.get().getBestFit().forEach((allocationRequest, taskExecutorToState) -> this.assignTaskExecutor((TaskExecutorAllocationRequest)allocationRequest, (TaskExecutorID)taskExecutorToState.getLeft(), (TaskExecutorState)taskExecutorToState.getRight(), request));
            this.sender().tell((Object)new TaskExecutorsAllocation(matchedExecutors.get().getRequestToTaskExecutorMap()), this.self());
        } else {
            request.allocationRequests.forEach(req -> this.metrics.incrementCounter("noResourcesAvailable", this.createTagListFrom((TaskExecutorAllocationRequest)req)));
            this.sender().tell((Object)new Status.Failure((Throwable)new ResourceCluster.NoResourceAvailableException(String.format("No resource available for request %s: resource overview: %s", request, this.getResourceOverview()))), this.self());
        }
    }

    private void assignTaskExecutor(TaskExecutorAllocationRequest allocationRequest, TaskExecutorID taskExecutorID, TaskExecutorState taskExecutorState, TaskExecutorBatchAssignmentRequest request) {
        if (this.shouldCacheJobArtifacts(allocationRequest)) {
            this.self().tell((Object)new AddNewJobArtifactsToCacheRequest(this.clusterID, Collections.singletonList(allocationRequest.getJobMetadata().getJobArtifact())), this.self());
        }
        taskExecutorState.onAssignment(allocationRequest.getWorkerId());
        this.getTimers().startSingleTimer((Object)("Assignment-" + taskExecutorID.toString()), (Object)new TaskExecutorAssignmentTimeout(taskExecutorID), this.assignmentTimeout);
    }

    private void onTaskExecutorAssignmentTimeout(TaskExecutorAssignmentTimeout request) {
        TaskExecutorState state = this.executorStateManager.get(request.getTaskExecutorID());
        if (state == null) {
            log.error("TaskExecutor lost during task assignment: {}", (Object)request);
        } else if (state.isRunningTask()) {
            log.debug("TaskExecutor {} entered running state already; no need to act", (Object)request.getTaskExecutorID());
        } else {
            try {
                boolean stateChange = state.onUnassignment();
                if (stateChange) {
                    this.executorStateManager.tryMarkAvailable(request.getTaskExecutorID());
                }
            }
            catch (IllegalStateException e) {
                if (state.isRegistered()) {
                    log.error("Failed to un-assign registered taskExecutor {}", (Object)request.getTaskExecutorID(), (Object)e);
                }
                log.debug("Failed to un-assign unRegistered taskExecutor {}", (Object)request.getTaskExecutorID(), (Object)e);
            }
        }
    }

    private void onResourceOverviewRequest(ResourceOverviewRequest request) {
        this.sender().tell((Object)this.getResourceOverview(), this.self());
    }

    private void onPublishResourceOverviewMetricsRequest(PublishResourceOverviewMetricsRequest request) {
        this.publishResourceClusterMetricBySKU(this.getTaskExecutors(ExecutorStateManager.isRegistered), "numRegisteredTaskExecutors");
        this.publishResourceClusterMetricBySKU(this.getTaskExecutors(ExecutorStateManager.isBusy), "numBusyTaskExecutors");
        this.publishResourceClusterMetricBySKU(this.getTaskExecutors(ExecutorStateManager.isAvailable), "numAvailableTaskExecutors");
        this.publishResourceClusterMetricBySKU(this.getTaskExecutors(ExecutorStateManager.isDisabled), "numDisabledTaskExecutors");
        this.publishResourceClusterMetricBySKU(this.getTaskExecutors(ExecutorStateManager.unregistered), "numUnregisteredTaskExecutors");
        this.publishResourceClusterMetricBySKU(this.getTaskExecutors(ExecutorStateManager.isAssigned), "numAssignedTaskExecutors");
    }

    private void publishResourceClusterMetricBySKU(TaskExecutorsList taskExecutorsList, String metricName) {
        try {
            taskExecutorsList.getTaskExecutors().stream().map(this::getTaskExecutorState).filter(Objects::nonNull).map(TaskExecutorState::getRegistration).filter(Objects::nonNull).filter(registration -> registration.getTaskExecutorContainerDefinitionId().isPresent() && registration.getAttributeByKey("NETFLIX_AUTO_SCALE_GROUP").isPresent()).collect(Collectors.groupingBy(registration -> Tuple.of(registration.getTaskExecutorContainerDefinitionId().get(), registration.getAttributeByKey("NETFLIX_AUTO_SCALE_GROUP").get()), Collectors.counting())).forEach((keys, count) -> this.metrics.setGauge(metricName, (long)count, (Iterable<Tag>)TagList.create((Map)ImmutableMap.of((Object)"resourceCluster", (Object)this.clusterID.getResourceID(), (Object)"sku", (Object)((ContainerSkuID)keys._1).getResourceID(), (Object)"autoScaleGroup", (Object)keys._2))));
        }
        catch (Exception e) {
            log.warn("Error while publishing resource cluster metrics by sku. RC: {}, Metric: {}.", new Object[]{this.clusterID.getResourceID(), metricName, e});
        }
    }

    private ResourceCluster.ResourceOverview getResourceOverview() {
        return this.executorStateManager.getResourceOverview();
    }

    private void getTaskExecutorStatus(GetTaskExecutorStatusRequest req) {
        TaskExecutorID taskExecutorID = req.getTaskExecutorID();
        TaskExecutorState state = this.executorStateManager.get(taskExecutorID);
        if (state == null) {
            log.info("Unknown executorID: {}", (Object)taskExecutorID);
            this.getSender().tell((Object)new Status.Failure((Throwable)new ResourceCluster.TaskExecutorNotFoundException(taskExecutorID)), this.self());
        } else {
            this.getSender().tell((Object)new ResourceCluster.TaskExecutorStatus(state.getRegistration(), state.isRegistered(), state.isRunningTask(), state.isAssigned(), state.isDisabled(), state.getWorkerId(), state.getLastActivity().toEpochMilli()), this.self());
        }
    }

    @Nullable
    private TaskExecutorState getTaskExecutorState(TaskExecutorID taskExecutorID) {
        return this.executorStateManager.get(taskExecutorID);
    }

    private void onTaskExecutorDisconnection(TaskExecutorDisconnection disconnection) {
        this.setupTaskExecutorStateIfNecessary(disconnection.getTaskExecutorID());
        try {
            this.disconnectTaskExecutor(disconnection.getTaskExecutorID());
            this.sender().tell((Object)Ack.getInstance(), this.self());
        }
        catch (IllegalStateException e) {
            this.sender().tell((Object)new Status.Failure((Throwable)e), this.self());
        }
    }

    private void disconnectTaskExecutor(TaskExecutorID taskExecutorID) {
        TaskExecutorState state = this.executorStateManager.get(taskExecutorID);
        boolean stateChange = state.onDisconnection();
        if (stateChange) {
            this.executorStateManager.archive(taskExecutorID);
            this.getTimers().cancel((Object)this.getHeartbeatTimerFor(taskExecutorID));
        }
    }

    private String getHeartbeatTimerFor(TaskExecutorID taskExecutorID) {
        return "Heartbeat-" + taskExecutorID.toString();
    }

    private void onTaskExecutorHeartbeatTimeout(HeartbeatTimeout timeout) {
        this.setupTaskExecutorStateIfNecessary(timeout.getTaskExecutorID());
        try {
            this.metrics.incrementCounter("taskExecutorHeartbeatTimeout", (Iterable<Tag>)TagList.create((Map)ImmutableMap.of((Object)"resourceCluster", (Object)this.clusterID.getResourceID(), (Object)"taskExecutorID", (Object)timeout.getTaskExecutorID().getResourceId())));
            log.info("heartbeat timeout received for {}", (Object)timeout.getTaskExecutorID());
            TaskExecutorID taskExecutorID = timeout.getTaskExecutorID();
            TaskExecutorState state = this.executorStateManager.get(taskExecutorID);
            if (state.getLastActivity().compareTo(timeout.getLastActivity()) <= 0) {
                log.info("Disconnecting task executor {}", (Object)timeout.getTaskExecutorID());
                this.disconnectTaskExecutor(timeout.getTaskExecutorID());
            }
        }
        catch (IllegalStateException e) {
            this.sender().tell((Object)new Status.Failure((Throwable)e), this.self());
        }
    }

    private void setupTaskExecutorStateIfNecessary(TaskExecutorID taskExecutorID) {
        this.executorStateManager.trackIfAbsent(taskExecutorID, TaskExecutorState.of(this.clock, this.rpcService, this.jobMessageRouter));
    }

    private void updateHeartbeatTimeout(TaskExecutorID taskExecutorID) {
        TaskExecutorState state = this.executorStateManager.get(taskExecutorID);
        this.getTimers().startSingleTimer((Object)this.getHeartbeatTimerFor(taskExecutorID), (Object)new HeartbeatTimeout(taskExecutorID, state.getLastActivity()), this.heartbeatTimeout);
    }

    private void onCacheJobArtifactsOnTaskExecutorRequest(CacheJobArtifactsOnTaskExecutorRequest request) {
        TaskExecutorState state = this.executorStateManager.get(request.getTaskExecutorID());
        if (state != null && state.isRegistered()) {
            try {
                ((CompletableFuture)state.getGatewayAsync().thenComposeAsync(taskExecutorGateway -> taskExecutorGateway.cacheJobArtifacts(new CacheJobArtifactsRequest(this.jobArtifactsToCache.stream().map(artifactID -> URI.create(artifactID.getResourceID())).collect(Collectors.toList()))))).whenComplete((res, throwable) -> {
                    if (throwable != null) {
                        log.error("failed to cache artifact on {}", (Object)request.getTaskExecutorID(), throwable);
                    } else {
                        log.debug("Acked from cacheJobArtifacts for {}", (Object)request.getTaskExecutorID());
                    }
                });
            }
            catch (Exception ex) {
                log.warn("Failed to cache job artifacts in task executor {}", (Object)request.getTaskExecutorID(), (Object)ex);
            }
        } else {
            log.debug("no valid TE state for CacheJobArtifactsOnTaskExecutorRequest: {}", (Object)request);
        }
    }

    private boolean shouldCacheJobArtifacts(TaskExecutorAllocationRequest allocationRequest) {
        boolean isFirstWorkerOfFirstStage;
        WorkerId workerId = allocationRequest.getWorkerId();
        boolean bl = isFirstWorkerOfFirstStage = allocationRequest.getStageNum() == 1 && workerId.getWorkerIndex() == 0;
        if (isFirstWorkerOfFirstStage) {
            Set<String> jobClusters = this.getJobClustersWithArtifactCachingEnabled();
            return jobClusters.contains(workerId.getJobCluster());
        }
        return false;
    }

    private Set<String> getJobClustersWithArtifactCachingEnabled() {
        return new HashSet<String>(Arrays.asList(this.jobClustersWithArtifactCachingEnabled.split(",")));
    }

    private Iterable<Tag> createTagListFrom(TaskExecutorAllocationRequest req) {
        ImmutableMap.Builder tagsBuilder = ImmutableMap.builder().put((Object)"resourceCluster", (Object)this.clusterID.getResourceID()).put((Object)"workerId", (Object)req.getWorkerId().getId()).put((Object)"jobCluster", (Object)req.getWorkerId().getJobCluster());
        if (req.getConstraints().getSizeName().isPresent()) {
            tagsBuilder.put((Object)"sizeName", req.getConstraints().getSizeName().get());
        } else {
            tagsBuilder.put((Object)"cpuCores", (Object)String.valueOf(req.getConstraints().getMachineDefinition().getCpuCores())).put((Object)"memoryMB", (Object)String.valueOf(req.getConstraints().getMachineDefinition().getMemoryMB()));
        }
        return TagList.create((Map)tagsBuilder.build());
    }

    private Predicate<Map.Entry<TaskExecutorID, TaskExecutorState>> filterByAttrs(HasAttributes hasAttributes) {
        if (hasAttributes.getAttributes().isEmpty()) {
            return e -> true;
        }
        return e -> ((TaskExecutorState)e.getValue()).containsAttributes(hasAttributes.getAttributes());
    }

    public String toString() {
        return "ResourceClusterActor(clusterID=" + this.clusterID + ")";
    }

    static final class Running
    implements AvailabilityState {
        private final WorkerId workerId;

        @Override
        public AvailabilityState onAssignment(WorkerId workerId) {
            return (AvailabilityState)this.throwInvalidTransition(workerId);
        }

        @Override
        public AvailabilityState onUnassignment() {
            return (AvailabilityState)this.throwInvalidTransition();
        }

        @Override
        public AvailabilityState onTaskExecutorStatusChange(TaskExecutorReport report) {
            if (report instanceof TaskExecutorReport.Available) {
                return AvailabilityState.pending();
            }
            if (report instanceof TaskExecutorReport.Occupied) {
                return this;
            }
            return (AvailabilityState)this.throwInvalidTransition(report);
        }

        @ConstructorProperties(value={"workerId"})
        public Running(WorkerId workerId) {
            this.workerId = workerId;
        }

        @Override
        public WorkerId getWorkerId() {
            return this.workerId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Running)) {
                return false;
            }
            Running other = (Running)o;
            WorkerId this$workerId = this.getWorkerId();
            WorkerId other$workerId = other.getWorkerId();
            return !(this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WorkerId $workerId = this.getWorkerId();
            result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.Running(workerId=" + this.getWorkerId() + ")";
        }
    }

    static final class Assigned
    implements AvailabilityState {
        private final WorkerId workerId;

        @Override
        public AvailabilityState onAssignment(WorkerId workerId) {
            if (this.workerId.equals((Object)workerId)) {
                return this;
            }
            return (AvailabilityState)this.throwInvalidTransition(workerId);
        }

        @Override
        public AvailabilityState onUnassignment() {
            return AvailabilityState.pending();
        }

        @Override
        public AvailabilityState onTaskExecutorStatusChange(TaskExecutorReport report) {
            if (report instanceof TaskExecutorReport.Available) {
                return this;
            }
            if (report instanceof TaskExecutorReport.Occupied) {
                return AvailabilityState.running(this.workerId);
            }
            return (AvailabilityState)this.throwInvalidTransition(report);
        }

        @ConstructorProperties(value={"workerId"})
        public Assigned(WorkerId workerId) {
            this.workerId = workerId;
        }

        @Override
        public WorkerId getWorkerId() {
            return this.workerId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assigned)) {
                return false;
            }
            Assigned other = (Assigned)o;
            WorkerId this$workerId = this.getWorkerId();
            WorkerId other$workerId = other.getWorkerId();
            return !(this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WorkerId $workerId = this.getWorkerId();
            result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.Assigned(workerId=" + this.getWorkerId() + ")";
        }
    }

    static final class Pending
    implements AvailabilityState {
        @Override
        public WorkerId getWorkerId() {
            return null;
        }

        @Override
        public AvailabilityState onAssignment(WorkerId workerId) {
            return AvailabilityState.assigned(workerId);
        }

        @Override
        public AvailabilityState onUnassignment() {
            return this;
        }

        @Override
        public AvailabilityState onTaskExecutorStatusChange(TaskExecutorReport report) {
            if (report instanceof TaskExecutorReport.Available) {
                return this;
            }
            if (report instanceof TaskExecutorReport.Occupied) {
                return AvailabilityState.running(((TaskExecutorReport.Occupied)report).getWorkerId());
            }
            return (AvailabilityState)this.throwInvalidTransition(report);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Pending;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public String toString() {
            return "ResourceClusterActor.Pending()";
        }
    }

    static interface AvailabilityState {
        public static final Pending PENDING = new Pending();

        @Nullable
        public WorkerId getWorkerId();

        public AvailabilityState onAssignment(WorkerId var1);

        public AvailabilityState onUnassignment();

        public AvailabilityState onTaskExecutorStatusChange(TaskExecutorReport var1);

        public static AvailabilityState pending() {
            return PENDING;
        }

        public static AvailabilityState assigned(WorkerId workerId) {
            return new Assigned(workerId);
        }

        public static AvailabilityState running(WorkerId workerId) {
            return new Running(workerId);
        }

        default public <T> T throwInvalidTransition() throws IllegalStateException {
            throw new IllegalStateException(String.format("availability state was %s when worker was unassigned", this));
        }

        default public <T> T throwInvalidTransition(WorkerId workerId) throws IllegalStateException {
            throw new IllegalStateException(String.format("availability state was %s when workerId %s was assigned", this, workerId));
        }

        default public <T> T throwInvalidTransition(TaskExecutorReport report) throws IllegalStateException {
            throw new IllegalStateException(String.format("availability state was %s when report %s was received", this, report));
        }
    }

    static final class BestFit {
        private final Map<TaskExecutorAllocationRequest, Pair<TaskExecutorID, TaskExecutorState>> bestFit = new HashMap<TaskExecutorAllocationRequest, Pair<TaskExecutorID, TaskExecutorState>>();
        private final Set<TaskExecutorID> taskExecutorIDSet = new HashSet<TaskExecutorID>();

        public void add(TaskExecutorAllocationRequest request, Pair<TaskExecutorID, TaskExecutorState> taskExecutorStatePair) {
            this.bestFit.put(request, taskExecutorStatePair);
            this.taskExecutorIDSet.add((TaskExecutorID)taskExecutorStatePair.getLeft());
        }

        public boolean contains(TaskExecutorID taskExecutorID) {
            return this.taskExecutorIDSet.contains(taskExecutorID);
        }

        public Map<TaskExecutorAllocationRequest, TaskExecutorID> getRequestToTaskExecutorMap() {
            return this.bestFit.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (TaskExecutorID)((Pair)e.getValue()).getKey()));
        }

        public Map<TaskExecutorAllocationRequest, Pair<TaskExecutorID, TaskExecutorState>> getBestFit() {
            return this.bestFit;
        }

        public Set<TaskExecutorID> getTaskExecutorIDSet() {
            return this.taskExecutorIDSet;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BestFit)) {
                return false;
            }
            BestFit other = (BestFit)o;
            Map<TaskExecutorAllocationRequest, Pair<TaskExecutorID, TaskExecutorState>> this$bestFit = this.getBestFit();
            Map<TaskExecutorAllocationRequest, Pair<TaskExecutorID, TaskExecutorState>> other$bestFit = other.getBestFit();
            if (this$bestFit == null ? other$bestFit != null : !((Object)this$bestFit).equals(other$bestFit)) {
                return false;
            }
            Set<TaskExecutorID> this$taskExecutorIDSet = this.getTaskExecutorIDSet();
            Set<TaskExecutorID> other$taskExecutorIDSet = other.getTaskExecutorIDSet();
            return !(this$taskExecutorIDSet == null ? other$taskExecutorIDSet != null : !((Object)this$taskExecutorIDSet).equals(other$taskExecutorIDSet));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<TaskExecutorAllocationRequest, Pair<TaskExecutorID, TaskExecutorState>> $bestFit = this.getBestFit();
            result = result * 59 + ($bestFit == null ? 43 : ((Object)$bestFit).hashCode());
            Set<TaskExecutorID> $taskExecutorIDSet = this.getTaskExecutorIDSet();
            result = result * 59 + ($taskExecutorIDSet == null ? 43 : ((Object)$taskExecutorIDSet).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.BestFit(bestFit=" + this.getBestFit() + ", taskExecutorIDSet=" + this.getTaskExecutorIDSet() + ")";
        }
    }

    static final class GetJobArtifactsToCacheRequest {
        private final ClusterID clusterID;

        @ConstructorProperties(value={"clusterID"})
        GetJobArtifactsToCacheRequest(ClusterID clusterID) {
            this.clusterID = clusterID;
        }

        public static GetJobArtifactsToCacheRequestBuilder builder() {
            return new GetJobArtifactsToCacheRequestBuilder();
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetJobArtifactsToCacheRequest)) {
                return false;
            }
            GetJobArtifactsToCacheRequest other = (GetJobArtifactsToCacheRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            return !(this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.GetJobArtifactsToCacheRequest(clusterID=" + this.getClusterID() + ")";
        }

        public static class GetJobArtifactsToCacheRequestBuilder {
            private ClusterID clusterID;

            GetJobArtifactsToCacheRequestBuilder() {
            }

            public GetJobArtifactsToCacheRequestBuilder clusterID(ClusterID clusterID) {
                this.clusterID = clusterID;
                return this;
            }

            public GetJobArtifactsToCacheRequest build() {
                return new GetJobArtifactsToCacheRequest(this.clusterID);
            }

            public String toString() {
                return "ResourceClusterActor.GetJobArtifactsToCacheRequest.GetJobArtifactsToCacheRequestBuilder(clusterID=" + this.clusterID + ")";
            }
        }
    }

    static final class RemoveJobArtifactsToCacheRequest {
        private final ClusterID clusterID;
        private final List<ArtifactID> artifacts;

        @ConstructorProperties(value={"clusterID", "artifacts"})
        RemoveJobArtifactsToCacheRequest(ClusterID clusterID, List<ArtifactID> artifacts) {
            this.clusterID = clusterID;
            this.artifacts = artifacts;
        }

        public static RemoveJobArtifactsToCacheRequestBuilder builder() {
            return new RemoveJobArtifactsToCacheRequestBuilder();
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public List<ArtifactID> getArtifacts() {
            return this.artifacts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveJobArtifactsToCacheRequest)) {
                return false;
            }
            RemoveJobArtifactsToCacheRequest other = (RemoveJobArtifactsToCacheRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            if (this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID)) {
                return false;
            }
            List<ArtifactID> this$artifacts = this.getArtifacts();
            List<ArtifactID> other$artifacts = other.getArtifacts();
            return !(this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            List<ArtifactID> $artifacts = this.getArtifacts();
            result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.RemoveJobArtifactsToCacheRequest(clusterID=" + this.getClusterID() + ", artifacts=" + this.getArtifacts() + ")";
        }

        public static class RemoveJobArtifactsToCacheRequestBuilder {
            private ClusterID clusterID;
            private List<ArtifactID> artifacts;

            RemoveJobArtifactsToCacheRequestBuilder() {
            }

            public RemoveJobArtifactsToCacheRequestBuilder clusterID(ClusterID clusterID) {
                this.clusterID = clusterID;
                return this;
            }

            public RemoveJobArtifactsToCacheRequestBuilder artifacts(List<ArtifactID> artifacts) {
                this.artifacts = artifacts;
                return this;
            }

            public RemoveJobArtifactsToCacheRequest build() {
                return new RemoveJobArtifactsToCacheRequest(this.clusterID, this.artifacts);
            }

            public String toString() {
                return "ResourceClusterActor.RemoveJobArtifactsToCacheRequest.RemoveJobArtifactsToCacheRequestBuilder(clusterID=" + this.clusterID + ", artifacts=" + this.artifacts + ")";
            }
        }
    }

    static final class AddNewJobArtifactsToCacheRequest {
        private final ClusterID clusterID;
        private final List<ArtifactID> artifacts;

        @ConstructorProperties(value={"clusterID", "artifacts"})
        AddNewJobArtifactsToCacheRequest(ClusterID clusterID, List<ArtifactID> artifacts) {
            this.clusterID = clusterID;
            this.artifacts = artifacts;
        }

        public static AddNewJobArtifactsToCacheRequestBuilder builder() {
            return new AddNewJobArtifactsToCacheRequestBuilder();
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public List<ArtifactID> getArtifacts() {
            return this.artifacts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddNewJobArtifactsToCacheRequest)) {
                return false;
            }
            AddNewJobArtifactsToCacheRequest other = (AddNewJobArtifactsToCacheRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            if (this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID)) {
                return false;
            }
            List<ArtifactID> this$artifacts = this.getArtifacts();
            List<ArtifactID> other$artifacts = other.getArtifacts();
            return !(this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            List<ArtifactID> $artifacts = this.getArtifacts();
            result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.AddNewJobArtifactsToCacheRequest(clusterID=" + this.getClusterID() + ", artifacts=" + this.getArtifacts() + ")";
        }

        public static class AddNewJobArtifactsToCacheRequestBuilder {
            private ClusterID clusterID;
            private List<ArtifactID> artifacts;

            AddNewJobArtifactsToCacheRequestBuilder() {
            }

            public AddNewJobArtifactsToCacheRequestBuilder clusterID(ClusterID clusterID) {
                this.clusterID = clusterID;
                return this;
            }

            public AddNewJobArtifactsToCacheRequestBuilder artifacts(List<ArtifactID> artifacts) {
                this.artifacts = artifacts;
                return this;
            }

            public AddNewJobArtifactsToCacheRequest build() {
                return new AddNewJobArtifactsToCacheRequest(this.clusterID, this.artifacts);
            }

            public String toString() {
                return "ResourceClusterActor.AddNewJobArtifactsToCacheRequest.AddNewJobArtifactsToCacheRequestBuilder(clusterID=" + this.clusterID + ", artifacts=" + this.artifacts + ")";
            }
        }
    }

    static final class CacheJobArtifactsOnTaskExecutorRequest {
        private final TaskExecutorID taskExecutorID;
        private final ClusterID clusterID;

        @ConstructorProperties(value={"taskExecutorID", "clusterID"})
        public CacheJobArtifactsOnTaskExecutorRequest(TaskExecutorID taskExecutorID, ClusterID clusterID) {
            this.taskExecutorID = taskExecutorID;
            this.clusterID = clusterID;
        }

        public TaskExecutorID getTaskExecutorID() {
            return this.taskExecutorID;
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheJobArtifactsOnTaskExecutorRequest)) {
                return false;
            }
            CacheJobArtifactsOnTaskExecutorRequest other = (CacheJobArtifactsOnTaskExecutorRequest)o;
            TaskExecutorID this$taskExecutorID = this.getTaskExecutorID();
            TaskExecutorID other$taskExecutorID = other.getTaskExecutorID();
            if (this$taskExecutorID == null ? other$taskExecutorID != null : !this$taskExecutorID.equals(other$taskExecutorID)) {
                return false;
            }
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            return !(this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaskExecutorID $taskExecutorID = this.getTaskExecutorID();
            result = result * 59 + ($taskExecutorID == null ? 43 : $taskExecutorID.hashCode());
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.CacheJobArtifactsOnTaskExecutorRequest(taskExecutorID=" + this.getTaskExecutorID() + ", clusterID=" + this.getClusterID() + ")";
        }
    }

    private static final class PublishResourceOverviewMetricsRequest {
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof PublishResourceOverviewMetricsRequest;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public String toString() {
            return "ResourceClusterActor.PublishResourceOverviewMetricsRequest()";
        }
    }

    static final class GetTaskExecutorWorkerMappingRequest {
        private final Map<String, String> attributes;

        @ConstructorProperties(value={"attributes"})
        public GetTaskExecutorWorkerMappingRequest(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetTaskExecutorWorkerMappingRequest)) {
                return false;
            }
            GetTaskExecutorWorkerMappingRequest other = (GetTaskExecutorWorkerMappingRequest)o;
            Map<String, String> this$attributes = this.getAttributes();
            Map<String, String> other$attributes = other.getAttributes();
            return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.GetTaskExecutorWorkerMappingRequest(attributes=" + this.getAttributes() + ")";
        }
    }

    private static final class CheckDisabledTaskExecutors {
        private final String reason;

        @ConstructorProperties(value={"reason"})
        public CheckDisabledTaskExecutors(String reason) {
            this.reason = reason;
        }

        public String getReason() {
            return this.reason;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CheckDisabledTaskExecutors)) {
                return false;
            }
            CheckDisabledTaskExecutors other = (CheckDisabledTaskExecutors)o;
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.CheckDisabledTaskExecutors(reason=" + this.getReason() + ")";
        }
    }

    static final class GetClusterUsageRequest {
        private final ClusterID clusterID;
        private final Function<TaskExecutorRegistration, Optional<String>> groupKeyFunc;

        @ConstructorProperties(value={"clusterID", "groupKeyFunc"})
        public GetClusterUsageRequest(ClusterID clusterID, Function<TaskExecutorRegistration, Optional<String>> groupKeyFunc) {
            this.clusterID = clusterID;
            this.groupKeyFunc = groupKeyFunc;
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public Function<TaskExecutorRegistration, Optional<String>> getGroupKeyFunc() {
            return this.groupKeyFunc;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetClusterUsageRequest)) {
                return false;
            }
            GetClusterUsageRequest other = (GetClusterUsageRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            if (this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID)) {
                return false;
            }
            Function<TaskExecutorRegistration, Optional<String>> this$groupKeyFunc = this.getGroupKeyFunc();
            Function<TaskExecutorRegistration, Optional<String>> other$groupKeyFunc = other.getGroupKeyFunc();
            return !(this$groupKeyFunc == null ? other$groupKeyFunc != null : !this$groupKeyFunc.equals(other$groupKeyFunc));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            Function<TaskExecutorRegistration, Optional<String>> $groupKeyFunc = this.getGroupKeyFunc();
            result = result * 59 + ($groupKeyFunc == null ? 43 : $groupKeyFunc.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.GetClusterUsageRequest(clusterID=" + this.getClusterID() + ", groupKeyFunc=" + this.getGroupKeyFunc() + ")";
        }
    }

    static final class ArtifactList {
        private final List<ArtifactID> artifacts;

        @ConstructorProperties(value={"artifacts"})
        public ArtifactList(List<ArtifactID> artifacts) {
            this.artifacts = artifacts;
        }

        public List<ArtifactID> getArtifacts() {
            return this.artifacts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArtifactList)) {
                return false;
            }
            ArtifactList other = (ArtifactList)o;
            List<ArtifactID> this$artifacts = this.getArtifacts();
            List<ArtifactID> other$artifacts = other.getArtifacts();
            return !(this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ArtifactID> $artifacts = this.getArtifacts();
            result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.ArtifactList(artifacts=" + this.getArtifacts() + ")";
        }
    }

    static final class TaskExecutorsAllocation {
        private final Map<TaskExecutorAllocationRequest, TaskExecutorID> allocations;

        @ConstructorProperties(value={"allocations"})
        public TaskExecutorsAllocation(Map<TaskExecutorAllocationRequest, TaskExecutorID> allocations) {
            this.allocations = allocations;
        }

        public Map<TaskExecutorAllocationRequest, TaskExecutorID> getAllocations() {
            return this.allocations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskExecutorsAllocation)) {
                return false;
            }
            TaskExecutorsAllocation other = (TaskExecutorsAllocation)o;
            Map<TaskExecutorAllocationRequest, TaskExecutorID> this$allocations = this.getAllocations();
            Map<TaskExecutorAllocationRequest, TaskExecutorID> other$allocations = other.getAllocations();
            return !(this$allocations == null ? other$allocations != null : !((Object)this$allocations).equals(other$allocations));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<TaskExecutorAllocationRequest, TaskExecutorID> $allocations = this.getAllocations();
            result = result * 59 + ($allocations == null ? 43 : ((Object)$allocations).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.TaskExecutorsAllocation(allocations=" + this.getAllocations() + ")";
        }
    }

    static final class TaskExecutorsList {
        private final List<TaskExecutorID> taskExecutors;

        @ConstructorProperties(value={"taskExecutors"})
        public TaskExecutorsList(List<TaskExecutorID> taskExecutors) {
            this.taskExecutors = taskExecutors;
        }

        public List<TaskExecutorID> getTaskExecutors() {
            return this.taskExecutors;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskExecutorsList)) {
                return false;
            }
            TaskExecutorsList other = (TaskExecutorsList)o;
            List<TaskExecutorID> this$taskExecutors = this.getTaskExecutors();
            List<TaskExecutorID> other$taskExecutors = other.getTaskExecutors();
            return !(this$taskExecutors == null ? other$taskExecutors != null : !((Object)this$taskExecutors).equals(other$taskExecutors));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<TaskExecutorID> $taskExecutors = this.getTaskExecutors();
            result = result * 59 + ($taskExecutors == null ? 43 : ((Object)$taskExecutors).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.TaskExecutorsList(taskExecutors=" + this.getTaskExecutors() + ")";
        }
    }

    static final class GetTaskExecutorStatusRequest {
        private final TaskExecutorID taskExecutorID;
        private final ClusterID clusterID;

        @ConstructorProperties(value={"taskExecutorID", "clusterID"})
        public GetTaskExecutorStatusRequest(TaskExecutorID taskExecutorID, ClusterID clusterID) {
            this.taskExecutorID = taskExecutorID;
            this.clusterID = clusterID;
        }

        public TaskExecutorID getTaskExecutorID() {
            return this.taskExecutorID;
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetTaskExecutorStatusRequest)) {
                return false;
            }
            GetTaskExecutorStatusRequest other = (GetTaskExecutorStatusRequest)o;
            TaskExecutorID this$taskExecutorID = this.getTaskExecutorID();
            TaskExecutorID other$taskExecutorID = other.getTaskExecutorID();
            if (this$taskExecutorID == null ? other$taskExecutorID != null : !this$taskExecutorID.equals(other$taskExecutorID)) {
                return false;
            }
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            return !(this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaskExecutorID $taskExecutorID = this.getTaskExecutorID();
            result = result * 59 + ($taskExecutorID == null ? 43 : $taskExecutorID.hashCode());
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.GetTaskExecutorStatusRequest(taskExecutorID=" + this.getTaskExecutorID() + ", clusterID=" + this.getClusterID() + ")";
        }
    }

    static final class GetUnregisteredTaskExecutorsRequest
    implements HasAttributes {
        private final ClusterID clusterID;
        private final Map<String, String> attributes;

        @ConstructorProperties(value={"clusterID", "attributes"})
        public GetUnregisteredTaskExecutorsRequest(ClusterID clusterID, Map<String, String> attributes) {
            this.clusterID = clusterID;
            this.attributes = attributes;
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetUnregisteredTaskExecutorsRequest)) {
                return false;
            }
            GetUnregisteredTaskExecutorsRequest other = (GetUnregisteredTaskExecutorsRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            if (this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID)) {
                return false;
            }
            Map<String, String> this$attributes = this.getAttributes();
            Map<String, String> other$attributes = other.getAttributes();
            return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            Map<String, String> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.GetUnregisteredTaskExecutorsRequest(clusterID=" + this.getClusterID() + ", attributes=" + this.getAttributes() + ")";
        }
    }

    static final class GetBusyTaskExecutorsRequest
    implements HasAttributes {
        private final ClusterID clusterID;
        private final Map<String, String> attributes;

        @ConstructorProperties(value={"clusterID", "attributes"})
        public GetBusyTaskExecutorsRequest(ClusterID clusterID, Map<String, String> attributes) {
            this.clusterID = clusterID;
            this.attributes = attributes;
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetBusyTaskExecutorsRequest)) {
                return false;
            }
            GetBusyTaskExecutorsRequest other = (GetBusyTaskExecutorsRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            if (this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID)) {
                return false;
            }
            Map<String, String> this$attributes = this.getAttributes();
            Map<String, String> other$attributes = other.getAttributes();
            return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            Map<String, String> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.GetBusyTaskExecutorsRequest(clusterID=" + this.getClusterID() + ", attributes=" + this.getAttributes() + ")";
        }
    }

    static final class GetDisabledTaskExecutorsRequest
    implements HasAttributes {
        private final ClusterID clusterID;
        private final Map<String, String> attributes;

        @ConstructorProperties(value={"clusterID", "attributes"})
        public GetDisabledTaskExecutorsRequest(ClusterID clusterID, Map<String, String> attributes) {
            this.clusterID = clusterID;
            this.attributes = attributes;
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetDisabledTaskExecutorsRequest)) {
                return false;
            }
            GetDisabledTaskExecutorsRequest other = (GetDisabledTaskExecutorsRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            if (this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID)) {
                return false;
            }
            Map<String, String> this$attributes = this.getAttributes();
            Map<String, String> other$attributes = other.getAttributes();
            return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            Map<String, String> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.GetDisabledTaskExecutorsRequest(clusterID=" + this.getClusterID() + ", attributes=" + this.getAttributes() + ")";
        }
    }

    static final class GetAvailableTaskExecutorsRequest
    implements HasAttributes {
        private final ClusterID clusterID;
        private final Map<String, String> attributes;

        @ConstructorProperties(value={"clusterID", "attributes"})
        public GetAvailableTaskExecutorsRequest(ClusterID clusterID, Map<String, String> attributes) {
            this.clusterID = clusterID;
            this.attributes = attributes;
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetAvailableTaskExecutorsRequest)) {
                return false;
            }
            GetAvailableTaskExecutorsRequest other = (GetAvailableTaskExecutorsRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            if (this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID)) {
                return false;
            }
            Map<String, String> this$attributes = this.getAttributes();
            Map<String, String> other$attributes = other.getAttributes();
            return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            Map<String, String> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.GetAvailableTaskExecutorsRequest(clusterID=" + this.getClusterID() + ", attributes=" + this.getAttributes() + ")";
        }
    }

    static interface HasAttributes {
        public Map<String, String> getAttributes();
    }

    static final class GetActiveJobsRequest {
        private final ClusterID clusterID;
        private final Optional<Integer> startingIndex;
        private final Optional<Integer> pageSize;

        public GetActiveJobsRequest(ClusterID clusterID) {
            this.clusterID = clusterID;
            this.pageSize = Optional.empty();
            this.startingIndex = Optional.empty();
        }

        public static GetActiveJobsRequestBuilder builder() {
            return new GetActiveJobsRequestBuilder();
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public Optional<Integer> getStartingIndex() {
            return this.startingIndex;
        }

        public Optional<Integer> getPageSize() {
            return this.pageSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetActiveJobsRequest)) {
                return false;
            }
            GetActiveJobsRequest other = (GetActiveJobsRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            if (this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID)) {
                return false;
            }
            Optional<Integer> this$startingIndex = this.getStartingIndex();
            Optional<Integer> other$startingIndex = other.getStartingIndex();
            if (this$startingIndex == null ? other$startingIndex != null : !((Object)this$startingIndex).equals(other$startingIndex)) {
                return false;
            }
            Optional<Integer> this$pageSize = this.getPageSize();
            Optional<Integer> other$pageSize = other.getPageSize();
            return !(this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            Optional<Integer> $startingIndex = this.getStartingIndex();
            result = result * 59 + ($startingIndex == null ? 43 : ((Object)$startingIndex).hashCode());
            Optional<Integer> $pageSize = this.getPageSize();
            result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.GetActiveJobsRequest(clusterID=" + this.getClusterID() + ", startingIndex=" + this.getStartingIndex() + ", pageSize=" + this.getPageSize() + ")";
        }

        @ConstructorProperties(value={"clusterID", "startingIndex", "pageSize"})
        public GetActiveJobsRequest(ClusterID clusterID, Optional<Integer> startingIndex, Optional<Integer> pageSize) {
            this.clusterID = clusterID;
            this.startingIndex = startingIndex;
            this.pageSize = pageSize;
        }

        public static class GetActiveJobsRequestBuilder {
            private ClusterID clusterID;
            private Optional<Integer> startingIndex;
            private Optional<Integer> pageSize;

            GetActiveJobsRequestBuilder() {
            }

            public GetActiveJobsRequestBuilder clusterID(ClusterID clusterID) {
                this.clusterID = clusterID;
                return this;
            }

            public GetActiveJobsRequestBuilder startingIndex(Optional<Integer> startingIndex) {
                this.startingIndex = startingIndex;
                return this;
            }

            public GetActiveJobsRequestBuilder pageSize(Optional<Integer> pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public GetActiveJobsRequest build() {
                return new GetActiveJobsRequest(this.clusterID, this.startingIndex, this.pageSize);
            }

            public String toString() {
                return "ResourceClusterActor.GetActiveJobsRequest.GetActiveJobsRequestBuilder(clusterID=" + this.clusterID + ", startingIndex=" + this.startingIndex + ", pageSize=" + this.pageSize + ")";
            }
        }
    }

    static final class GetRegisteredTaskExecutorsRequest
    implements HasAttributes {
        private final ClusterID clusterID;
        private final Map<String, String> attributes;

        @ConstructorProperties(value={"clusterID", "attributes"})
        public GetRegisteredTaskExecutorsRequest(ClusterID clusterID, Map<String, String> attributes) {
            this.clusterID = clusterID;
            this.attributes = attributes;
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetRegisteredTaskExecutorsRequest)) {
                return false;
            }
            GetRegisteredTaskExecutorsRequest other = (GetRegisteredTaskExecutorsRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            if (this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID)) {
                return false;
            }
            Map<String, String> this$attributes = this.getAttributes();
            Map<String, String> other$attributes = other.getAttributes();
            return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            Map<String, String> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.GetRegisteredTaskExecutorsRequest(clusterID=" + this.getClusterID() + ", attributes=" + this.getAttributes() + ")";
        }
    }

    static final class TaskExecutorGatewayRequest {
        private final TaskExecutorID taskExecutorID;
        private final ClusterID clusterID;

        @ConstructorProperties(value={"taskExecutorID", "clusterID"})
        public TaskExecutorGatewayRequest(TaskExecutorID taskExecutorID, ClusterID clusterID) {
            this.taskExecutorID = taskExecutorID;
            this.clusterID = clusterID;
        }

        public TaskExecutorID getTaskExecutorID() {
            return this.taskExecutorID;
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskExecutorGatewayRequest)) {
                return false;
            }
            TaskExecutorGatewayRequest other = (TaskExecutorGatewayRequest)o;
            TaskExecutorID this$taskExecutorID = this.getTaskExecutorID();
            TaskExecutorID other$taskExecutorID = other.getTaskExecutorID();
            if (this$taskExecutorID == null ? other$taskExecutorID != null : !this$taskExecutorID.equals(other$taskExecutorID)) {
                return false;
            }
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            return !(this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaskExecutorID $taskExecutorID = this.getTaskExecutorID();
            result = result * 59 + ($taskExecutorID == null ? 43 : $taskExecutorID.hashCode());
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.TaskExecutorGatewayRequest(taskExecutorID=" + this.getTaskExecutorID() + ", clusterID=" + this.getClusterID() + ")";
        }
    }

    static final class GetAssignedTaskExecutorRequest {
        private final WorkerId workerId;
        private final ClusterID clusterID;

        @ConstructorProperties(value={"workerId", "clusterID"})
        public GetAssignedTaskExecutorRequest(WorkerId workerId, ClusterID clusterID) {
            this.workerId = workerId;
            this.clusterID = clusterID;
        }

        public WorkerId getWorkerId() {
            return this.workerId;
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetAssignedTaskExecutorRequest)) {
                return false;
            }
            GetAssignedTaskExecutorRequest other = (GetAssignedTaskExecutorRequest)o;
            WorkerId this$workerId = this.getWorkerId();
            WorkerId other$workerId = other.getWorkerId();
            if (this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId)) {
                return false;
            }
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            return !(this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WorkerId $workerId = this.getWorkerId();
            result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.GetAssignedTaskExecutorRequest(workerId=" + this.getWorkerId() + ", clusterID=" + this.getClusterID() + ")";
        }
    }

    static final class TaskExecutorInfoRequest {
        @Nullable
        private final TaskExecutorID taskExecutorID;
        @Nullable
        private final String hostName;
        private final ClusterID clusterID;

        @ConstructorProperties(value={"taskExecutorID", "hostName", "clusterID"})
        public TaskExecutorInfoRequest(@Nullable TaskExecutorID taskExecutorID, @Nullable String hostName, ClusterID clusterID) {
            this.taskExecutorID = taskExecutorID;
            this.hostName = hostName;
            this.clusterID = clusterID;
        }

        @Nullable
        public TaskExecutorID getTaskExecutorID() {
            return this.taskExecutorID;
        }

        @Nullable
        public String getHostName() {
            return this.hostName;
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskExecutorInfoRequest)) {
                return false;
            }
            TaskExecutorInfoRequest other = (TaskExecutorInfoRequest)o;
            TaskExecutorID this$taskExecutorID = this.getTaskExecutorID();
            TaskExecutorID other$taskExecutorID = other.getTaskExecutorID();
            if (this$taskExecutorID == null ? other$taskExecutorID != null : !this$taskExecutorID.equals(other$taskExecutorID)) {
                return false;
            }
            String this$hostName = this.getHostName();
            String other$hostName = other.getHostName();
            if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
                return false;
            }
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            return !(this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaskExecutorID $taskExecutorID = this.getTaskExecutorID();
            result = result * 59 + ($taskExecutorID == null ? 43 : $taskExecutorID.hashCode());
            String $hostName = this.getHostName();
            result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.TaskExecutorInfoRequest(taskExecutorID=" + this.getTaskExecutorID() + ", hostName=" + this.getHostName() + ", clusterID=" + this.getClusterID() + ")";
        }
    }

    static final class ResourceOverviewRequest {
        private final ClusterID clusterID;

        @ConstructorProperties(value={"clusterID"})
        public ResourceOverviewRequest(ClusterID clusterID) {
            this.clusterID = clusterID;
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceOverviewRequest)) {
                return false;
            }
            ResourceOverviewRequest other = (ResourceOverviewRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            return !(this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.ResourceOverviewRequest(clusterID=" + this.getClusterID() + ")";
        }
    }

    static final class InitializeTaskExecutorRequest {
        private final TaskExecutorID taskExecutorID;
        private final WorkerId workerId;

        @ConstructorProperties(value={"taskExecutorID", "workerId"})
        public InitializeTaskExecutorRequest(TaskExecutorID taskExecutorID, WorkerId workerId) {
            this.taskExecutorID = taskExecutorID;
            this.workerId = workerId;
        }

        public TaskExecutorID getTaskExecutorID() {
            return this.taskExecutorID;
        }

        public WorkerId getWorkerId() {
            return this.workerId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitializeTaskExecutorRequest)) {
                return false;
            }
            InitializeTaskExecutorRequest other = (InitializeTaskExecutorRequest)o;
            TaskExecutorID this$taskExecutorID = this.getTaskExecutorID();
            TaskExecutorID other$taskExecutorID = other.getTaskExecutorID();
            if (this$taskExecutorID == null ? other$taskExecutorID != null : !this$taskExecutorID.equals(other$taskExecutorID)) {
                return false;
            }
            WorkerId this$workerId = this.getWorkerId();
            WorkerId other$workerId = other.getWorkerId();
            return !(this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaskExecutorID $taskExecutorID = this.getTaskExecutorID();
            result = result * 59 + ($taskExecutorID == null ? 43 : $taskExecutorID.hashCode());
            WorkerId $workerId = this.getWorkerId();
            result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.InitializeTaskExecutorRequest(taskExecutorID=" + this.getTaskExecutorID() + ", workerId=" + this.getWorkerId() + ")";
        }
    }

    static final class ExpireDisableTaskExecutorsRequest {
        private final DisableTaskExecutorsRequest request;

        @ConstructorProperties(value={"request"})
        public ExpireDisableTaskExecutorsRequest(DisableTaskExecutorsRequest request) {
            this.request = request;
        }

        public DisableTaskExecutorsRequest getRequest() {
            return this.request;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpireDisableTaskExecutorsRequest)) {
                return false;
            }
            ExpireDisableTaskExecutorsRequest other = (ExpireDisableTaskExecutorsRequest)o;
            DisableTaskExecutorsRequest this$request = this.getRequest();
            DisableTaskExecutorsRequest other$request = other.getRequest();
            return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DisableTaskExecutorsRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.ExpireDisableTaskExecutorsRequest(request=" + this.getRequest() + ")";
        }
    }

    static final class TaskExecutorAssignmentTimeout {
        private final TaskExecutorID taskExecutorID;

        @ConstructorProperties(value={"taskExecutorID"})
        public TaskExecutorAssignmentTimeout(TaskExecutorID taskExecutorID) {
            this.taskExecutorID = taskExecutorID;
        }

        public TaskExecutorID getTaskExecutorID() {
            return this.taskExecutorID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskExecutorAssignmentTimeout)) {
                return false;
            }
            TaskExecutorAssignmentTimeout other = (TaskExecutorAssignmentTimeout)o;
            TaskExecutorID this$taskExecutorID = this.getTaskExecutorID();
            TaskExecutorID other$taskExecutorID = other.getTaskExecutorID();
            return !(this$taskExecutorID == null ? other$taskExecutorID != null : !this$taskExecutorID.equals(other$taskExecutorID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaskExecutorID $taskExecutorID = this.getTaskExecutorID();
            result = result * 59 + ($taskExecutorID == null ? 43 : $taskExecutorID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.TaskExecutorAssignmentTimeout(taskExecutorID=" + this.getTaskExecutorID() + ")";
        }
    }

    static final class TaskExecutorBatchAssignmentRequest {
        private final Set<TaskExecutorAllocationRequest> allocationRequests;
        private final ClusterID clusterID;

        public Map<SchedulingConstraints, List<TaskExecutorAllocationRequest>> getGroupedBySchedulingConstraints() {
            return this.allocationRequests.stream().collect(Collectors.groupingBy(TaskExecutorAllocationRequest::getConstraints));
        }

        public String getJobId() {
            return this.allocationRequests.iterator().next().getWorkerId().getJobId();
        }

        @ConstructorProperties(value={"allocationRequests", "clusterID"})
        public TaskExecutorBatchAssignmentRequest(Set<TaskExecutorAllocationRequest> allocationRequests, ClusterID clusterID) {
            this.allocationRequests = allocationRequests;
            this.clusterID = clusterID;
        }

        public Set<TaskExecutorAllocationRequest> getAllocationRequests() {
            return this.allocationRequests;
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskExecutorBatchAssignmentRequest)) {
                return false;
            }
            TaskExecutorBatchAssignmentRequest other = (TaskExecutorBatchAssignmentRequest)o;
            Set<TaskExecutorAllocationRequest> this$allocationRequests = this.getAllocationRequests();
            Set<TaskExecutorAllocationRequest> other$allocationRequests = other.getAllocationRequests();
            if (this$allocationRequests == null ? other$allocationRequests != null : !((Object)this$allocationRequests).equals(other$allocationRequests)) {
                return false;
            }
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            return !(this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<TaskExecutorAllocationRequest> $allocationRequests = this.getAllocationRequests();
            result = result * 59 + ($allocationRequests == null ? 43 : ((Object)$allocationRequests).hashCode());
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.TaskExecutorBatchAssignmentRequest(allocationRequests=" + this.getAllocationRequests() + ", clusterID=" + this.getClusterID() + ")";
        }
    }

    static final class HeartbeatTimeout {
        private final TaskExecutorID taskExecutorID;
        private final Instant lastActivity;

        @ConstructorProperties(value={"taskExecutorID", "lastActivity"})
        public HeartbeatTimeout(TaskExecutorID taskExecutorID, Instant lastActivity) {
            this.taskExecutorID = taskExecutorID;
            this.lastActivity = lastActivity;
        }

        public TaskExecutorID getTaskExecutorID() {
            return this.taskExecutorID;
        }

        public Instant getLastActivity() {
            return this.lastActivity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HeartbeatTimeout)) {
                return false;
            }
            HeartbeatTimeout other = (HeartbeatTimeout)o;
            TaskExecutorID this$taskExecutorID = this.getTaskExecutorID();
            TaskExecutorID other$taskExecutorID = other.getTaskExecutorID();
            if (this$taskExecutorID == null ? other$taskExecutorID != null : !this$taskExecutorID.equals(other$taskExecutorID)) {
                return false;
            }
            Instant this$lastActivity = this.getLastActivity();
            Instant other$lastActivity = other.getLastActivity();
            return !(this$lastActivity == null ? other$lastActivity != null : !((Object)this$lastActivity).equals(other$lastActivity));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaskExecutorID $taskExecutorID = this.getTaskExecutorID();
            result = result * 59 + ($taskExecutorID == null ? 43 : $taskExecutorID.hashCode());
            Instant $lastActivity = this.getLastActivity();
            result = result * 59 + ($lastActivity == null ? 43 : ((Object)$lastActivity).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterActor.HeartbeatTimeout(taskExecutorID=" + this.getTaskExecutorID() + ", lastActivity=" + this.getLastActivity() + ")";
        }
    }
}

