/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import io.mantisrx.common.Ack;
import io.mantisrx.config.dynamic.LongDynamicProperty;
import io.mantisrx.master.resourcecluster.DisableTaskExecutorsRequest;
import io.mantisrx.master.resourcecluster.ResourceClusterActor;
import io.mantisrx.master.resourcecluster.ResourceClusterGatewayAkkaImpl;
import io.mantisrx.master.resourcecluster.ResourceClusterScalerActor;
import io.mantisrx.master.resourcecluster.proto.SetResourceClusterScalerStatusRequest;
import io.mantisrx.server.core.domain.ArtifactID;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ContainerSkuID;
import io.mantisrx.server.master.resourcecluster.PagedActiveJobOverview;
import io.mantisrx.server.master.resourcecluster.ResourceCluster;
import io.mantisrx.server.master.resourcecluster.TaskExecutorAllocationRequest;
import io.mantisrx.server.master.resourcecluster.TaskExecutorID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorRegistration;
import io.mantisrx.server.worker.TaskExecutorGateway;
import io.mantisrx.shaded.com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

class ResourceClusterAkkaImpl
extends ResourceClusterGatewayAkkaImpl
implements ResourceCluster {
    private final ClusterID clusterID;

    public ResourceClusterAkkaImpl(ActorRef resourceClusterManagerActor, Duration askTimeout, ClusterID clusterID, LongDynamicProperty rateLimitPerSecondDp) {
        super(resourceClusterManagerActor, askTimeout, rateLimitPerSecondDp);
        this.clusterID = clusterID;
    }

    public String getName() {
        return this.clusterID.getResourceID();
    }

    public CompletableFuture<Ack> initializeTaskExecutor(TaskExecutorID taskExecutorID, WorkerId workerId) {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.InitializeTaskExecutorRequest(taskExecutorID, workerId), (Duration)this.askTimeout).thenApply(Ack.class::cast).toCompletableFuture();
    }

    public CompletableFuture<List<TaskExecutorID>> getRegisteredTaskExecutors(Map<String, String> attributes) {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.GetRegisteredTaskExecutorsRequest(this.clusterID, attributes), (Duration)this.askTimeout).thenApply(ResourceClusterActor.TaskExecutorsList.class::cast).toCompletableFuture().thenApply(l -> l.getTaskExecutors());
    }

    public CompletableFuture<List<TaskExecutorID>> getAvailableTaskExecutors(Map<String, String> attributes) {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.GetAvailableTaskExecutorsRequest(this.clusterID, attributes), (Duration)this.askTimeout).thenApply(ResourceClusterActor.TaskExecutorsList.class::cast).toCompletableFuture().thenApply(l -> l.getTaskExecutors());
    }

    public CompletableFuture<List<TaskExecutorID>> getBusyTaskExecutors(Map<String, String> attributes) {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.GetBusyTaskExecutorsRequest(this.clusterID, attributes), (Duration)this.askTimeout).thenApply(ResourceClusterActor.TaskExecutorsList.class::cast).toCompletableFuture().thenApply(l -> l.getTaskExecutors());
    }

    public CompletableFuture<List<TaskExecutorID>> getUnregisteredTaskExecutors(Map<String, String> attributes) {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.GetUnregisteredTaskExecutorsRequest(this.clusterID, attributes), (Duration)this.askTimeout).thenApply(ResourceClusterActor.TaskExecutorsList.class::cast).toCompletableFuture().thenApply(l -> l.getTaskExecutors());
    }

    public CompletableFuture<ResourceCluster.ResourceOverview> resourceOverview() {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.ResourceOverviewRequest(this.clusterID), (Duration)this.askTimeout).thenApply(ResourceCluster.ResourceOverview.class::cast).toCompletableFuture();
    }

    public CompletableFuture<Ack> addNewJobArtifactsToCache(ClusterID clusterID, List<ArtifactID> artifacts) {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.AddNewJobArtifactsToCacheRequest(clusterID, artifacts), (Duration)this.askTimeout).thenApply(Ack.class::cast).toCompletableFuture();
    }

    public CompletableFuture<Ack> removeJobArtifactsToCache(List<ArtifactID> artifacts) {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.RemoveJobArtifactsToCacheRequest(this.clusterID, artifacts), (Duration)this.askTimeout).thenApply(Ack.class::cast).toCompletableFuture();
    }

    public CompletableFuture<List<ArtifactID>> getJobArtifactsToCache() {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.GetJobArtifactsToCacheRequest(this.clusterID), (Duration)this.askTimeout).thenApply(ResourceClusterActor.ArtifactList.class::cast).toCompletableFuture().thenApply(ResourceClusterActor.ArtifactList::getArtifacts);
    }

    public CompletableFuture<Map<TaskExecutorAllocationRequest, TaskExecutorID>> getTaskExecutorsFor(Set<TaskExecutorAllocationRequest> allocationRequests) {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.TaskExecutorBatchAssignmentRequest(allocationRequests, this.clusterID), (Duration)this.askTimeout).thenApply(ResourceClusterActor.TaskExecutorsAllocation.class::cast).toCompletableFuture().thenApply(l -> l.getAllocations());
    }

    public CompletableFuture<TaskExecutorID> getTaskExecutorAssignedFor(WorkerId workerId) {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.GetAssignedTaskExecutorRequest(workerId, this.clusterID), (Duration)this.askTimeout).thenApply(TaskExecutorID.class::cast).toCompletableFuture();
    }

    public CompletableFuture<TaskExecutorGateway> getTaskExecutorGateway(TaskExecutorID taskExecutorID) {
        return (CompletableFuture)Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.TaskExecutorGatewayRequest(taskExecutorID, this.clusterID), (Duration)this.askTimeout).thenComposeAsync(result -> {
            if (result instanceof CompletableFuture) {
                return (CompletableFuture)result;
            }
            CompletableFuture exceptionFuture = new CompletableFuture();
            exceptionFuture.completeExceptionally(new RuntimeException("Unexpected object type on getTaskExecutorGateway: " + result.getClass().getName()));
            return exceptionFuture;
        });
    }

    public CompletableFuture<TaskExecutorRegistration> getTaskExecutorInfo(String hostName) {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.TaskExecutorInfoRequest(null, hostName, this.clusterID), (Duration)this.askTimeout).thenApply(TaskExecutorRegistration.class::cast).toCompletableFuture();
    }

    public CompletableFuture<TaskExecutorRegistration> getTaskExecutorInfo(TaskExecutorID taskExecutorID) {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.TaskExecutorInfoRequest(taskExecutorID, null, this.clusterID), (Duration)this.askTimeout).thenApply(TaskExecutorRegistration.class::cast).toCompletableFuture();
    }

    public CompletableFuture<ResourceCluster.TaskExecutorStatus> getTaskExecutorState(TaskExecutorID taskExecutorID) {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.GetTaskExecutorStatusRequest(taskExecutorID, this.clusterID), (Duration)this.askTimeout).thenApply(ResourceCluster.TaskExecutorStatus.class::cast).toCompletableFuture();
    }

    public CompletableFuture<Ack> refreshClusterScalerRuleSet() {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)ResourceClusterScalerActor.QueueClusterRuleRefreshRequest.builder().clusterID(this.clusterID).build(), (Duration)this.askTimeout).thenApply(Ack.class::cast).toCompletableFuture();
    }

    public CompletableFuture<Ack> disableTaskExecutorsFor(Map<String, String> attributes, Instant expiry, Optional<TaskExecutorID> taskExecutorID) {
        DisableTaskExecutorsRequest msg = new DisableTaskExecutorsRequest(attributes, this.clusterID, expiry, taskExecutorID);
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)msg, (Duration)this.askTimeout).thenApply(Ack.class::cast).toCompletableFuture();
    }

    public CompletableFuture<Ack> setScalerStatus(ClusterID clusterID, ContainerSkuID skuID, Boolean enabled, Long expirationDurationInSeconds) {
        SetResourceClusterScalerStatusRequest msg = SetResourceClusterScalerStatusRequest.builder().skuId(skuID).clusterID(clusterID).enabled(enabled).expirationDurationInSeconds(expirationDurationInSeconds).build();
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)msg, (Duration)this.askTimeout).thenApply(Ack.class::cast).toCompletableFuture();
    }

    public CompletableFuture<PagedActiveJobOverview> getActiveJobOverview(Optional<Integer> startingIndex, Optional<Integer> maxSize) {
        ResourceClusterActor.GetActiveJobsRequest msg = ResourceClusterActor.GetActiveJobsRequest.builder().clusterID(this.clusterID).startingIndex(startingIndex).pageSize(maxSize).build();
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)msg, (Duration)this.askTimeout).thenApply(PagedActiveJobOverview.class::cast).toCompletableFuture();
    }

    public CompletableFuture<Map<TaskExecutorID, WorkerId>> getTaskExecutorWorkerMapping() {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.GetTaskExecutorWorkerMappingRequest((Map<String, String>)ImmutableMap.of()), (Duration)this.askTimeout).thenApply(obj -> (Map)obj).toCompletableFuture();
    }

    public CompletableFuture<Map<TaskExecutorID, WorkerId>> getTaskExecutorWorkerMapping(Map<String, String> attributes) {
        return Patterns.ask((ActorRef)this.resourceClusterManagerActor, (Object)new ResourceClusterActor.GetTaskExecutorWorkerMappingRequest(attributes), (Duration)this.askTimeout).thenApply(obj -> (Map)obj).toCompletableFuture();
    }
}

