/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster;

import akka.actor.AbstractActor;
import akka.actor.AbstractActorWithTimers;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.japi.pf.ReceiveBuilder;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.Ack;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import io.mantisrx.master.resourcecluster.DisableTaskExecutorsRequest;
import io.mantisrx.master.resourcecluster.ResourceClusterActor;
import io.mantisrx.master.resourcecluster.proto.GetClusterIdleInstancesRequest;
import io.mantisrx.master.resourcecluster.proto.GetClusterIdleInstancesResponse;
import io.mantisrx.master.resourcecluster.proto.GetClusterUsageResponse;
import io.mantisrx.master.resourcecluster.proto.ResourceClusterScaleSpec;
import io.mantisrx.master.resourcecluster.proto.ScaleResourceRequest;
import io.mantisrx.master.resourcecluster.proto.SetResourceClusterScalerStatusRequest;
import io.mantisrx.master.resourcecluster.writable.ResourceClusterScaleRulesWritable;
import io.mantisrx.server.master.persistence.IMantisPersistenceProvider;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ContainerSkuID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorRegistration;
import io.mantisrx.shaded.com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceClusterScalerActor
extends AbstractActorWithTimers {
    private static final Logger log = LoggerFactory.getLogger(ResourceClusterScalerActor.class);
    private final ClusterID clusterId;
    private final Duration scalerPullThreshold;
    private final Duration ruleSetRefreshThreshold;
    private final ActorRef resourceClusterActor;
    private final ActorRef resourceClusterHostActor;
    private final IMantisPersistenceProvider storageProvider;
    private final ConcurrentMap<ContainerSkuID, ClusterAvailabilityRule> skuToRuleMap = new ConcurrentHashMap<ContainerSkuID, ClusterAvailabilityRule>();
    private final Clock clock;
    private final Counter numScaleUp;
    private final Counter numScaleDown;
    private final Counter numReachScaleMaxLimit;
    private final Counter numReachScaleMinLimit;
    private final Counter numScaleRuleTrigger;
    static Function<TaskExecutorRegistration, Optional<String>> groupKeyFromTaskExecutorDefinitionIdFunc = reg -> reg.getTaskExecutorContainerDefinitionId().map(id -> id.getResourceID());

    public static Props props(ClusterID clusterId, Clock clock, Duration scalerPullThreshold, Duration ruleRefreshThreshold, IMantisPersistenceProvider storageProvider, ActorRef resourceClusterHostActor, ActorRef resourceClusterActor) {
        return Props.create(ResourceClusterScalerActor.class, (Object[])new Object[]{clusterId, clock, scalerPullThreshold, ruleRefreshThreshold, storageProvider, resourceClusterHostActor, resourceClusterActor});
    }

    public ResourceClusterScalerActor(ClusterID clusterId, Clock clock, Duration scalerPullThreshold, Duration ruleRefreshThreshold, IMantisPersistenceProvider storageProvider, ActorRef resourceClusterHostActor, ActorRef resourceClusterActor) {
        this.clusterId = clusterId;
        this.resourceClusterActor = resourceClusterActor;
        this.resourceClusterHostActor = resourceClusterHostActor;
        this.storageProvider = storageProvider;
        this.clock = clock;
        this.scalerPullThreshold = scalerPullThreshold;
        this.ruleSetRefreshThreshold = ruleRefreshThreshold;
        MetricGroupId metricGroupId = new MetricGroupId("ResourceClusterScalerActor", new Tag[]{new BasicTag("resourceCluster", this.clusterId.getResourceID())});
        Metrics m = new Metrics.Builder().id(metricGroupId).addCounter("numScaleDown").addCounter("numReachScaleMaxLimit").addCounter("numScaleUp").addCounter("numReachScaleMinLimit").addCounter("numScaleRuleTrigger").build();
        m = MetricsRegistry.getInstance().registerAndGet(m);
        this.numScaleDown = m.getCounter("numScaleDown");
        this.numReachScaleMaxLimit = m.getCounter("numReachScaleMaxLimit");
        this.numScaleUp = m.getCounter("numScaleUp");
        this.numReachScaleMinLimit = m.getCounter("numReachScaleMinLimit");
        this.numScaleRuleTrigger = m.getCounter("numScaleRuleTrigger");
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(TriggerClusterUsageRequest.class, this::onTriggerClusterUsageRequest).match(TriggerClusterRuleRefreshRequest.class, this::onTriggerClusterRuleRefreshRequest).match(QueueClusterRuleRefreshRequest.class, this::onQueueClusterRuleRefreshRequest).match(GetRuleSetRequest.class, req -> this.getSender().tell((Object)GetRuleSetResponse.builder().rules((ImmutableMap<ContainerSkuID, ClusterAvailabilityRule>)ImmutableMap.copyOf(this.skuToRuleMap)).build(), this.self())).match(GetClusterUsageResponse.class, this::onGetClusterUsageResponse).match(GetClusterIdleInstancesResponse.class, this::onGetClusterIdleInstancesResponse).match(GetRuleSetResponse.class, s -> log.info("[{}] Refreshed rule size: {}", (Object)s.getClusterID(), (Object)s.getRules().size())).match(SetResourceClusterScalerStatusRequest.class, req -> {
            this.onSetScalerStatus((SetResourceClusterScalerStatusRequest)req);
            this.getSender().tell((Object)Ack.getInstance(), this.self());
        }).match(ExpireSetScalerStatusRequest.class, this::onExpireSetScalerStatus).match(Ack.class, ack -> log.info("Received ack from {}", (Object)this.sender())).build();
    }

    public void preStart() throws Exception {
        super.preStart();
        log.info("ResourceClusterScaler Actor {} starting", (Object)this.clusterId);
        this.fetchRuleSet();
        this.getTimers().startTimerWithFixedDelay((Object)("ClusterScaler-" + this.clusterId), (Object)new TriggerClusterUsageRequest(this.clusterId), this.scalerPullThreshold);
        this.getTimers().startTimerWithFixedDelay((Object)("ClusterScalerRuleFetcher-" + this.clusterId), (Object)new TriggerClusterRuleRefreshRequest(this.clusterId), this.ruleSetRefreshThreshold);
    }

    private void onGetClusterUsageResponse(GetClusterUsageResponse usageResponse) {
        log.info("Getting cluster usage: {}", (Object)usageResponse);
        this.numScaleRuleTrigger.increment();
        usageResponse.getUsages().forEach(usage -> {
            ContainerSkuID skuId = ContainerSkuID.of((String)usage.getUsageGroupKey());
            if (this.skuToRuleMap.containsKey(skuId) && ((ClusterAvailabilityRule)this.skuToRuleMap.get(skuId)).isEnabled()) {
                Optional<ScaleDecision> decisionO = ((ClusterAvailabilityRule)this.skuToRuleMap.get(skuId)).apply((GetClusterUsageResponse.UsageByGroupKey)usage);
                if (decisionO.isPresent()) {
                    log.info("Informing scale decision: {}", (Object)decisionO.get());
                    switch (decisionO.get().getType()) {
                        case ScaleDown: {
                            log.info("Scaling down, fetching idle instances.");
                            this.numScaleDown.increment();
                            this.resourceClusterActor.tell((Object)GetClusterIdleInstancesRequest.builder().clusterID(this.clusterId).skuId(skuId).desireSize(decisionO.get().getDesireSize()).maxInstanceCount(Math.max(0, usage.getTotalCount() - decisionO.get().getDesireSize())).build(), this.self());
                            break;
                        }
                        case ScaleUp: {
                            log.info("Scaling up, informing host actor: {}", (Object)decisionO.get());
                            this.numScaleUp.increment();
                            this.resourceClusterHostActor.tell((Object)this.translateScaleDecision(decisionO.get()), this.self());
                            break;
                        }
                        case NoOpReachMax: {
                            this.numReachScaleMaxLimit.increment();
                            break;
                        }
                        case NoOpReachMin: {
                            this.numReachScaleMinLimit.increment();
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid scale type: " + decisionO);
                        }
                    }
                }
            } else {
                log.info("Either scaling is disabled for sku or no sku rule is available for {}: {}", (Object)this.clusterId, (Object)usage.getUsageGroupKey());
            }
        });
        this.getSender().tell((Object)Ack.getInstance(), this.self());
    }

    private void onGetClusterIdleInstancesResponse(GetClusterIdleInstancesResponse response) {
        log.info("On GetClusterIdleInstancesResponse, informing host actor: {}", (Object)response);
        this.resourceClusterHostActor.tell((Object)ScaleResourceRequest.builder().clusterId(this.clusterId).skuId(response.getSkuId()).desireSize(response.getDesireSize()).idleInstances(response.getInstanceIds()).build(), this.self());
        response.getInstanceIds().forEach(id -> this.resourceClusterActor.tell((Object)new DisableTaskExecutorsRequest(Collections.emptyMap(), this.clusterId, Instant.now().plus(Duration.ofMinutes(60L)), Optional.of(id)), this.self()));
    }

    private void onTriggerClusterUsageRequest(TriggerClusterUsageRequest req) {
        log.trace("Requesting cluster usage: {}", (Object)this.clusterId);
        if (this.skuToRuleMap.isEmpty()) {
            log.info("{} scaler is disabled due to no rules", (Object)this.clusterId);
            return;
        }
        this.resourceClusterActor.tell((Object)new ResourceClusterActor.GetClusterUsageRequest(this.clusterId, groupKeyFromTaskExecutorDefinitionIdFunc), this.self());
    }

    private void onTriggerClusterRuleRefreshRequest(TriggerClusterRuleRefreshRequest req) {
        log.info("{}: Requesting cluster rule refresh", (Object)this.clusterId);
        this.fetchRuleSet();
    }

    private void onQueueClusterRuleRefreshRequest(QueueClusterRuleRefreshRequest req) {
        log.debug("{}: Queue a request to refresh cluster rules", (Object)this.clusterId);
        this.self().tell((Object)new TriggerClusterRuleRefreshRequest(this.clusterId), this.self());
        this.getSender().tell((Object)Ack.getInstance(), this.self());
    }

    private void fetchRuleSet() {
        try {
            ResourceClusterScaleRulesWritable rules = this.storageProvider.getResourceClusterScaleRules(this.clusterId);
            HashSet removedKeys = new HashSet(this.skuToRuleMap.keySet());
            Set preservedKeys = rules.getScaleRules().keySet().stream().map(ContainerSkuID::of).collect(Collectors.toSet());
            removedKeys.removeAll(preservedKeys);
            removedKeys.forEach(this.skuToRuleMap::remove);
            rules.getScaleRules().values().forEach(scaleRule -> {
                log.info("Cluster [{}]: Adding scaleRule: {}", (Object)this.clusterId, scaleRule);
                ClusterAvailabilityRule clusterAvailabilityRule = this.createClusterAvailabilityRule((ResourceClusterScaleSpec)scaleRule, (ClusterAvailabilityRule)this.skuToRuleMap.get(scaleRule.getSkuId()));
                this.skuToRuleMap.put(scaleRule.getSkuId(), clusterAvailabilityRule);
            });
            GetRuleSetResponse fetchFut = GetRuleSetResponse.builder().rules((ImmutableMap<ContainerSkuID, ClusterAvailabilityRule>)ImmutableMap.copyOf(this.skuToRuleMap)).clusterID(this.clusterId).build();
            this.self().tell((Object)fetchFut, this.self());
        }
        catch (IOException e) {
            log.error("Failed to fetch rule set for cluster: {}", (Object)this.clusterId, (Object)e);
        }
    }

    private ClusterAvailabilityRule createClusterAvailabilityRule(ResourceClusterScaleSpec scaleSpec, ClusterAvailabilityRule existingRule) {
        if (existingRule == null) {
            return new ClusterAvailabilityRule(scaleSpec, this.clock, Instant.MIN, true);
        }
        return new ClusterAvailabilityRule(scaleSpec, this.clock, existingRule.lastActionInstant, existingRule.enabled);
    }

    private void onSetScalerStatus(SetResourceClusterScalerStatusRequest req) {
        if (this.skuToRuleMap.containsKey(req.getSkuId())) {
            ((ClusterAvailabilityRule)this.skuToRuleMap.get(req.getSkuId())).setEnabled(req.getEnabled());
            if (!req.getEnabled().booleanValue()) {
                this.setExpireSetScalerStatusRequestTimer(new ExpireSetScalerStatusRequest(req));
            }
        }
    }

    private void onExpireSetScalerStatus(ExpireSetScalerStatusRequest req) {
        log.info("Expiration set scaler status request: {}", (Object)req);
        ContainerSkuID skuID = req.request.getSkuId();
        ClusterAvailabilityRule rule = (ClusterAvailabilityRule)this.skuToRuleMap.get(skuID);
        if (rule != null && !rule.isEnabled()) {
            if (!((ClusterAvailabilityRule)this.skuToRuleMap.get(skuID)).isLastActionOlderThan(req.getRequest().getExpirationDurationInSeconds())) {
                ((ClusterAvailabilityRule)this.skuToRuleMap.get(skuID)).setEnabled(true);
            } else {
                this.setExpireSetScalerStatusRequestTimer(req);
            }
        }
    }

    private void setExpireSetScalerStatusRequestTimer(ExpireSetScalerStatusRequest req) {
        this.getTimers().startSingleTimer((Object)("ExpireSetScalerStatusRequest-" + this.clusterId), (Object)req, Duration.ofSeconds(req.getRequest().getExpirationDurationInSeconds()));
    }

    private ScaleResourceRequest translateScaleDecision(ScaleDecision decision) {
        return ScaleResourceRequest.builder().clusterId(this.clusterId).skuId(decision.getSkuId()).desireSize(decision.getDesireSize()).build();
    }

    static final class ScaleDecision {
        private final ContainerSkuID skuId;
        private final ClusterID clusterId;
        private final int maxSize;
        private final int minSize;
        private final int desireSize;
        private final ScaleType type;

        @ConstructorProperties(value={"skuId", "clusterId", "maxSize", "minSize", "desireSize", "type"})
        ScaleDecision(ContainerSkuID skuId, ClusterID clusterId, int maxSize, int minSize, int desireSize, ScaleType type) {
            this.skuId = skuId;
            this.clusterId = clusterId;
            this.maxSize = maxSize;
            this.minSize = minSize;
            this.desireSize = desireSize;
            this.type = type;
        }

        public static ScaleDecisionBuilder builder() {
            return new ScaleDecisionBuilder();
        }

        public ContainerSkuID getSkuId() {
            return this.skuId;
        }

        public ClusterID getClusterId() {
            return this.clusterId;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public int getMinSize() {
            return this.minSize;
        }

        public int getDesireSize() {
            return this.desireSize;
        }

        public ScaleType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScaleDecision)) {
                return false;
            }
            ScaleDecision other = (ScaleDecision)o;
            if (this.getMaxSize() != other.getMaxSize()) {
                return false;
            }
            if (this.getMinSize() != other.getMinSize()) {
                return false;
            }
            if (this.getDesireSize() != other.getDesireSize()) {
                return false;
            }
            ContainerSkuID this$skuId = this.getSkuId();
            ContainerSkuID other$skuId = other.getSkuId();
            if (this$skuId == null ? other$skuId != null : !this$skuId.equals(other$skuId)) {
                return false;
            }
            ClusterID this$clusterId = this.getClusterId();
            ClusterID other$clusterId = other.getClusterId();
            if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
                return false;
            }
            ScaleType this$type = this.getType();
            ScaleType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxSize();
            result = result * 59 + this.getMinSize();
            result = result * 59 + this.getDesireSize();
            ContainerSkuID $skuId = this.getSkuId();
            result = result * 59 + ($skuId == null ? 43 : $skuId.hashCode());
            ClusterID $clusterId = this.getClusterId();
            result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
            ScaleType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterScalerActor.ScaleDecision(skuId=" + this.getSkuId() + ", clusterId=" + this.getClusterId() + ", maxSize=" + this.getMaxSize() + ", minSize=" + this.getMinSize() + ", desireSize=" + this.getDesireSize() + ", type=" + (Object)((Object)this.getType()) + ")";
        }

        public static class ScaleDecisionBuilder {
            private ContainerSkuID skuId;
            private ClusterID clusterId;
            private int maxSize;
            private int minSize;
            private int desireSize;
            private ScaleType type;

            ScaleDecisionBuilder() {
            }

            public ScaleDecisionBuilder skuId(ContainerSkuID skuId) {
                this.skuId = skuId;
                return this;
            }

            public ScaleDecisionBuilder clusterId(ClusterID clusterId) {
                this.clusterId = clusterId;
                return this;
            }

            public ScaleDecisionBuilder maxSize(int maxSize) {
                this.maxSize = maxSize;
                return this;
            }

            public ScaleDecisionBuilder minSize(int minSize) {
                this.minSize = minSize;
                return this;
            }

            public ScaleDecisionBuilder desireSize(int desireSize) {
                this.desireSize = desireSize;
                return this;
            }

            public ScaleDecisionBuilder type(ScaleType type) {
                this.type = type;
                return this;
            }

            public ScaleDecision build() {
                return new ScaleDecision(this.skuId, this.clusterId, this.maxSize, this.minSize, this.desireSize, this.type);
            }

            public String toString() {
                return "ResourceClusterScalerActor.ScaleDecision.ScaleDecisionBuilder(skuId=" + this.skuId + ", clusterId=" + this.clusterId + ", maxSize=" + this.maxSize + ", minSize=" + this.minSize + ", desireSize=" + this.desireSize + ", type=" + (Object)((Object)this.type) + ")";
            }
        }
    }

    static enum ScaleType {
        NoOpReachMax,
        NoOpReachMin,
        ScaleUp,
        ScaleDown;

    }

    static class ClusterAvailabilityRule {
        private final ResourceClusterScaleSpec scaleSpec;
        private final Clock clock;
        private Instant lastActionInstant;
        private boolean enabled;

        public ClusterAvailabilityRule(ResourceClusterScaleSpec scaleSpec, Clock clock, Instant lastActionInstant, Boolean enabled) {
            this.scaleSpec = scaleSpec;
            this.clock = clock;
            this.lastActionInstant = lastActionInstant;
            this.enabled = enabled;
        }

        private void resetLastActionInstant() {
            log.debug("resetLastActionInstant: {}, {}", (Object)this.scaleSpec.getClusterId(), (Object)this.scaleSpec.getSkuId());
            this.lastActionInstant = this.clock.instant();
        }

        public void setEnabled(boolean enabled) {
            log.debug("setEnabled: {}, {}, {}", new Object[]{enabled, this.scaleSpec.getClusterId(), this.scaleSpec.getSkuId()});
            this.enabled = enabled;
            this.resetLastActionInstant();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isLastActionOlderThan(long secondsSinceLastAction) {
            log.debug("[isLastActionOlderThan] secondsSinceLastAction: {}, {}, {}", new Object[]{secondsSinceLastAction, this.scaleSpec.getClusterId(), this.scaleSpec.getSkuId()});
            log.debug("[isLastActionOlderThan] lastActionInstant: {}, {}, {}", new Object[]{this.lastActionInstant, this.scaleSpec.getClusterId(), this.scaleSpec.getSkuId()});
            log.debug("[isLastActionOlderThan] lastActionInstant + secondsSinceLastAction: {}, {}, {}", new Object[]{this.lastActionInstant.plusSeconds(secondsSinceLastAction), this.scaleSpec.getClusterId(), this.scaleSpec.getSkuId()});
            log.debug("[isLastActionOlderThan] comp: {}, {}, {}", new Object[]{this.lastActionInstant.plusSeconds(secondsSinceLastAction).compareTo(this.clock.instant()) > 0, this.scaleSpec.getClusterId(), this.scaleSpec.getSkuId()});
            return this.lastActionInstant.plusSeconds(secondsSinceLastAction).compareTo(this.clock.instant()) > 0;
        }

        public Optional<ScaleDecision> apply(GetClusterUsageResponse.UsageByGroupKey usage) {
            Optional<ScaleDecision> decision = Optional.empty();
            if (usage.getIdleCount() > this.scaleSpec.getMaxIdleToKeep()) {
                if (this.isLastActionOlderThan(this.scaleSpec.getCoolDownSecs() * 5L)) {
                    log.debug("Scale Down CoolDown skip: {}, {}", (Object)this.scaleSpec.getClusterId(), (Object)this.scaleSpec.getSkuId());
                    return Optional.empty();
                }
                int step = usage.getIdleCount() - this.scaleSpec.getMaxIdleToKeep();
                int newSize = Math.max(usage.getTotalCount() - step, this.scaleSpec.getMinSize());
                decision = Optional.of(ScaleDecision.builder().clusterId(this.scaleSpec.getClusterId()).skuId(this.scaleSpec.getSkuId()).desireSize(newSize).maxSize(newSize).minSize(newSize).type(newSize == usage.getTotalCount() ? ScaleType.NoOpReachMin : ScaleType.ScaleDown).build());
            } else if (usage.getIdleCount() < this.scaleSpec.getMinIdleToKeep()) {
                if (this.isLastActionOlderThan(this.scaleSpec.getCoolDownSecs())) {
                    log.debug("Scale Up CoolDown skip: {}, {}", (Object)this.scaleSpec.getClusterId(), (Object)this.scaleSpec.getSkuId());
                    return Optional.empty();
                }
                int step = this.scaleSpec.getMinIdleToKeep() - usage.getIdleCount();
                int newSize = Math.min(usage.getTotalCount() + step, this.scaleSpec.getMaxSize());
                decision = Optional.of(ScaleDecision.builder().clusterId(this.scaleSpec.getClusterId()).skuId(this.scaleSpec.getSkuId()).desireSize(newSize).maxSize(newSize).minSize(newSize).type(newSize == usage.getTotalCount() ? ScaleType.NoOpReachMax : ScaleType.ScaleUp).build());
            }
            log.info("Scale Decision for {}-{}: {}", new Object[]{this.scaleSpec.getClusterId(), this.scaleSpec.getSkuId(), decision});
            if (decision.isPresent() && (((ScaleDecision)decision.get()).type.equals((Object)ScaleType.ScaleDown) || decision.get().type.equals((Object)ScaleType.ScaleUp))) {
                log.debug("Ongoing scale operation. Resetting last action timer: {}, {}", (Object)this.scaleSpec.getClusterId(), (Object)this.scaleSpec.getSkuId());
                this.resetLastActionInstant();
            }
            return decision;
        }
    }

    static final class GetRuleSetResponse {
        private final ClusterID clusterID;
        private final ImmutableMap<ContainerSkuID, ClusterAvailabilityRule> rules;

        @ConstructorProperties(value={"clusterID", "rules"})
        GetRuleSetResponse(ClusterID clusterID, ImmutableMap<ContainerSkuID, ClusterAvailabilityRule> rules) {
            this.clusterID = clusterID;
            this.rules = rules;
        }

        public static GetRuleSetResponseBuilder builder() {
            return new GetRuleSetResponseBuilder();
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public ImmutableMap<ContainerSkuID, ClusterAvailabilityRule> getRules() {
            return this.rules;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetRuleSetResponse)) {
                return false;
            }
            GetRuleSetResponse other = (GetRuleSetResponse)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            if (this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID)) {
                return false;
            }
            ImmutableMap<ContainerSkuID, ClusterAvailabilityRule> this$rules = this.getRules();
            ImmutableMap<ContainerSkuID, ClusterAvailabilityRule> other$rules = other.getRules();
            return !(this$rules == null ? other$rules != null : !this$rules.equals(other$rules));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            ImmutableMap<ContainerSkuID, ClusterAvailabilityRule> $rules = this.getRules();
            result = result * 59 + ($rules == null ? 43 : $rules.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterScalerActor.GetRuleSetResponse(clusterID=" + this.getClusterID() + ", rules=" + this.getRules() + ")";
        }

        public static class GetRuleSetResponseBuilder {
            private ClusterID clusterID;
            private ImmutableMap<ContainerSkuID, ClusterAvailabilityRule> rules;

            GetRuleSetResponseBuilder() {
            }

            public GetRuleSetResponseBuilder clusterID(ClusterID clusterID) {
                this.clusterID = clusterID;
                return this;
            }

            public GetRuleSetResponseBuilder rules(ImmutableMap<ContainerSkuID, ClusterAvailabilityRule> rules) {
                this.rules = rules;
                return this;
            }

            public GetRuleSetResponse build() {
                return new GetRuleSetResponse(this.clusterID, this.rules);
            }

            public String toString() {
                return "ResourceClusterScalerActor.GetRuleSetResponse.GetRuleSetResponseBuilder(clusterID=" + this.clusterID + ", rules=" + this.rules + ")";
            }
        }
    }

    static final class GetRuleSetRequest {
        private final ClusterID clusterID;

        @ConstructorProperties(value={"clusterID"})
        GetRuleSetRequest(ClusterID clusterID) {
            this.clusterID = clusterID;
        }

        public static GetRuleSetRequestBuilder builder() {
            return new GetRuleSetRequestBuilder();
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetRuleSetRequest)) {
                return false;
            }
            GetRuleSetRequest other = (GetRuleSetRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            return !(this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterScalerActor.GetRuleSetRequest(clusterID=" + this.getClusterID() + ")";
        }

        public static class GetRuleSetRequestBuilder {
            private ClusterID clusterID;

            GetRuleSetRequestBuilder() {
            }

            public GetRuleSetRequestBuilder clusterID(ClusterID clusterID) {
                this.clusterID = clusterID;
                return this;
            }

            public GetRuleSetRequest build() {
                return new GetRuleSetRequest(this.clusterID);
            }

            public String toString() {
                return "ResourceClusterScalerActor.GetRuleSetRequest.GetRuleSetRequestBuilder(clusterID=" + this.clusterID + ")";
            }
        }
    }

    static final class QueueClusterRuleRefreshRequest {
        private final ClusterID clusterID;

        @ConstructorProperties(value={"clusterID"})
        QueueClusterRuleRefreshRequest(ClusterID clusterID) {
            this.clusterID = clusterID;
        }

        public static QueueClusterRuleRefreshRequestBuilder builder() {
            return new QueueClusterRuleRefreshRequestBuilder();
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueueClusterRuleRefreshRequest)) {
                return false;
            }
            QueueClusterRuleRefreshRequest other = (QueueClusterRuleRefreshRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            return !(this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterScalerActor.QueueClusterRuleRefreshRequest(clusterID=" + this.getClusterID() + ")";
        }

        public static class QueueClusterRuleRefreshRequestBuilder {
            private ClusterID clusterID;

            QueueClusterRuleRefreshRequestBuilder() {
            }

            public QueueClusterRuleRefreshRequestBuilder clusterID(ClusterID clusterID) {
                this.clusterID = clusterID;
                return this;
            }

            public QueueClusterRuleRefreshRequest build() {
                return new QueueClusterRuleRefreshRequest(this.clusterID);
            }

            public String toString() {
                return "ResourceClusterScalerActor.QueueClusterRuleRefreshRequest.QueueClusterRuleRefreshRequestBuilder(clusterID=" + this.clusterID + ")";
            }
        }
    }

    static final class TriggerClusterRuleRefreshRequest {
        private final ClusterID clusterID;

        @ConstructorProperties(value={"clusterID"})
        TriggerClusterRuleRefreshRequest(ClusterID clusterID) {
            this.clusterID = clusterID;
        }

        public static TriggerClusterRuleRefreshRequestBuilder builder() {
            return new TriggerClusterRuleRefreshRequestBuilder();
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TriggerClusterRuleRefreshRequest)) {
                return false;
            }
            TriggerClusterRuleRefreshRequest other = (TriggerClusterRuleRefreshRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            return !(this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterScalerActor.TriggerClusterRuleRefreshRequest(clusterID=" + this.getClusterID() + ")";
        }

        public static class TriggerClusterRuleRefreshRequestBuilder {
            private ClusterID clusterID;

            TriggerClusterRuleRefreshRequestBuilder() {
            }

            public TriggerClusterRuleRefreshRequestBuilder clusterID(ClusterID clusterID) {
                this.clusterID = clusterID;
                return this;
            }

            public TriggerClusterRuleRefreshRequest build() {
                return new TriggerClusterRuleRefreshRequest(this.clusterID);
            }

            public String toString() {
                return "ResourceClusterScalerActor.TriggerClusterRuleRefreshRequest.TriggerClusterRuleRefreshRequestBuilder(clusterID=" + this.clusterID + ")";
            }
        }
    }

    static final class ExpireSetScalerStatusRequest {
        private final SetResourceClusterScalerStatusRequest request;

        @ConstructorProperties(value={"request"})
        public ExpireSetScalerStatusRequest(SetResourceClusterScalerStatusRequest request) {
            this.request = request;
        }

        public SetResourceClusterScalerStatusRequest getRequest() {
            return this.request;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpireSetScalerStatusRequest)) {
                return false;
            }
            ExpireSetScalerStatusRequest other = (ExpireSetScalerStatusRequest)o;
            SetResourceClusterScalerStatusRequest this$request = this.getRequest();
            SetResourceClusterScalerStatusRequest other$request = other.getRequest();
            return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SetResourceClusterScalerStatusRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterScalerActor.ExpireSetScalerStatusRequest(request=" + this.getRequest() + ")";
        }
    }

    static final class TriggerClusterUsageRequest {
        private final ClusterID clusterID;

        @ConstructorProperties(value={"clusterID"})
        TriggerClusterUsageRequest(ClusterID clusterID) {
            this.clusterID = clusterID;
        }

        public static TriggerClusterUsageRequestBuilder builder() {
            return new TriggerClusterUsageRequestBuilder();
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TriggerClusterUsageRequest)) {
                return false;
            }
            TriggerClusterUsageRequest other = (TriggerClusterUsageRequest)o;
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            return !(this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterScalerActor.TriggerClusterUsageRequest(clusterID=" + this.getClusterID() + ")";
        }

        public static class TriggerClusterUsageRequestBuilder {
            private ClusterID clusterID;

            TriggerClusterUsageRequestBuilder() {
            }

            public TriggerClusterUsageRequestBuilder clusterID(ClusterID clusterID) {
                this.clusterID = clusterID;
                return this;
            }

            public TriggerClusterUsageRequest build() {
                return new TriggerClusterUsageRequest(this.clusterID);
            }

            public String toString() {
                return "ResourceClusterScalerActor.TriggerClusterUsageRequest.TriggerClusterUsageRequestBuilder(clusterID=" + this.clusterID + ")";
            }
        }
    }
}

