/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.Patterns;
import io.mantisrx.common.properties.MantisPropertiesLoader;
import io.mantisrx.config.dynamic.LongDynamicProperty;
import io.mantisrx.master.resourcecluster.ResourceClusterAkkaImpl;
import io.mantisrx.master.resourcecluster.ResourceClustersManagerActor;
import io.mantisrx.server.core.utils.ConfigUtils;
import io.mantisrx.server.master.config.ConfigurationFactory;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.config.MasterConfiguration;
import io.mantisrx.server.master.persistence.IMantisPersistenceProvider;
import io.mantisrx.server.master.persistence.MantisJobStore;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ResourceCluster;
import io.mantisrx.server.master.resourcecluster.ResourceClusters;
import io.mantisrx.server.master.scheduler.JobMessageRouter;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.runtime.rpc.RpcService;

public class ResourceClustersAkkaImpl
implements ResourceClusters {
    private final ActorRef resourceClustersManagerActor;
    private final Duration askTimeout;
    private final LongDynamicProperty rateLimitPerSecondDp;
    private final ConcurrentMap<ClusterID, ResourceCluster> cache = new ConcurrentHashMap<ClusterID, ResourceCluster>();

    public ResourceCluster getClusterFor(ClusterID clusterID) {
        this.cache.computeIfAbsent(clusterID, dontCare -> new ResourceClusterAkkaImpl(this.resourceClustersManagerActor, this.askTimeout, clusterID, this.rateLimitPerSecondDp));
        return (ResourceCluster)this.cache.get(clusterID);
    }

    public CompletableFuture<Set<ClusterID>> listActiveClusters() {
        return ((CompletableFuture)Patterns.ask((ActorRef)this.resourceClustersManagerActor, (Object)new ResourceClustersManagerActor.ListActiveClusters(), (Duration)this.askTimeout).toCompletableFuture().thenApply(ResourceClustersManagerActor.ClusterIdSet.class::cast)).thenApply(clusterIdSet -> clusterIdSet.getClusterIDS());
    }

    public static ResourceClusters load(ConfigurationFactory masterConfiguration, RpcService rpcService, ActorSystem actorSystem, MantisJobStore mantisJobStore, JobMessageRouter jobMessageRouter, ActorRef resourceClusterHostActorRef, IMantisPersistenceProvider persistenceProvider, MantisPropertiesLoader propertiesLoader) {
        MasterConfiguration config = masterConfiguration.getConfig();
        ActorRef resourceClusterManagerActor = actorSystem.actorOf(ResourceClustersManagerActor.props(config, Clock.systemDefaultZone(), rpcService, mantisJobStore, resourceClusterHostActorRef, persistenceProvider, jobMessageRouter));
        Duration askTimeout = Duration.ofMillis(ConfigurationProvider.getConfig().getMasterApiAskTimeoutMs());
        LongDynamicProperty permitsPerSecondDp = ConfigUtils.getDynamicPropertyLong((String)"getResourceClusterActionsPermitsPerSecond", MasterConfiguration.class, (long)config.getResourceClusterActionsPermitsPerSecond(), (MantisPropertiesLoader)propertiesLoader);
        return new ResourceClustersAkkaImpl(resourceClusterManagerActor, askTimeout, permitsPerSecondDp);
    }

    @ConstructorProperties(value={"resourceClustersManagerActor", "askTimeout", "rateLimitPerSecondDp"})
    private ResourceClustersAkkaImpl(ActorRef resourceClustersManagerActor, Duration askTimeout, LongDynamicProperty rateLimitPerSecondDp) {
        this.resourceClustersManagerActor = resourceClustersManagerActor;
        this.askTimeout = askTimeout;
        this.rateLimitPerSecondDp = rateLimitPerSecondDp;
    }
}

