/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster.proto;

import io.mantisrx.server.master.resourcecluster.ClusterID;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class GetClusterUsageResponse {
    private final ClusterID clusterID;
    private final List<UsageByGroupKey> usages;

    @ConstructorProperties(value={"clusterID", "usages"})
    GetClusterUsageResponse(ClusterID clusterID, List<UsageByGroupKey> usages) {
        this.clusterID = clusterID;
        this.usages = usages;
    }

    public static GetClusterUsageResponseBuilder builder() {
        return new GetClusterUsageResponseBuilder();
    }

    public ClusterID getClusterID() {
        return this.clusterID;
    }

    public List<UsageByGroupKey> getUsages() {
        return this.usages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetClusterUsageResponse)) {
            return false;
        }
        GetClusterUsageResponse other = (GetClusterUsageResponse)o;
        ClusterID this$clusterID = this.getClusterID();
        ClusterID other$clusterID = other.getClusterID();
        if (this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID)) {
            return false;
        }
        List<UsageByGroupKey> this$usages = this.getUsages();
        List<UsageByGroupKey> other$usages = other.getUsages();
        return !(this$usages == null ? other$usages != null : !((Object)this$usages).equals(other$usages));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClusterID $clusterID = this.getClusterID();
        result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
        List<UsageByGroupKey> $usages = this.getUsages();
        result = result * 59 + ($usages == null ? 43 : ((Object)$usages).hashCode());
        return result;
    }

    public String toString() {
        return "GetClusterUsageResponse(clusterID=" + this.getClusterID() + ", usages=" + this.getUsages() + ")";
    }

    public static class GetClusterUsageResponseBuilder {
        private ClusterID clusterID;
        private ArrayList<UsageByGroupKey> usages;

        GetClusterUsageResponseBuilder() {
        }

        public GetClusterUsageResponseBuilder clusterID(ClusterID clusterID) {
            this.clusterID = clusterID;
            return this;
        }

        public GetClusterUsageResponseBuilder usage(UsageByGroupKey usage) {
            if (this.usages == null) {
                this.usages = new ArrayList();
            }
            this.usages.add(usage);
            return this;
        }

        public GetClusterUsageResponseBuilder usages(Collection<? extends UsageByGroupKey> usages) {
            if (usages == null) {
                throw new NullPointerException("usages cannot be null");
            }
            if (this.usages == null) {
                this.usages = new ArrayList();
            }
            this.usages.addAll(usages);
            return this;
        }

        public GetClusterUsageResponseBuilder clearUsages() {
            if (this.usages != null) {
                this.usages.clear();
            }
            return this;
        }

        public GetClusterUsageResponse build() {
            List<UsageByGroupKey> usages;
            switch (this.usages == null ? 0 : this.usages.size()) {
                case 0: {
                    usages = Collections.emptyList();
                    break;
                }
                case 1: {
                    usages = Collections.singletonList(this.usages.get(0));
                    break;
                }
                default: {
                    usages = Collections.unmodifiableList(new ArrayList<UsageByGroupKey>(this.usages));
                }
            }
            return new GetClusterUsageResponse(this.clusterID, usages);
        }

        public String toString() {
            return "GetClusterUsageResponse.GetClusterUsageResponseBuilder(clusterID=" + this.clusterID + ", usages=" + this.usages + ")";
        }
    }

    public static final class UsageByGroupKey {
        private final String usageGroupKey;
        private final int idleCount;
        private final int totalCount;

        @ConstructorProperties(value={"usageGroupKey", "idleCount", "totalCount"})
        UsageByGroupKey(String usageGroupKey, int idleCount, int totalCount) {
            this.usageGroupKey = usageGroupKey;
            this.idleCount = idleCount;
            this.totalCount = totalCount;
        }

        public static UsageByGroupKeyBuilder builder() {
            return new UsageByGroupKeyBuilder();
        }

        public String getUsageGroupKey() {
            return this.usageGroupKey;
        }

        public int getIdleCount() {
            return this.idleCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsageByGroupKey)) {
                return false;
            }
            UsageByGroupKey other = (UsageByGroupKey)o;
            if (this.getIdleCount() != other.getIdleCount()) {
                return false;
            }
            if (this.getTotalCount() != other.getTotalCount()) {
                return false;
            }
            String this$usageGroupKey = this.getUsageGroupKey();
            String other$usageGroupKey = other.getUsageGroupKey();
            return !(this$usageGroupKey == null ? other$usageGroupKey != null : !this$usageGroupKey.equals(other$usageGroupKey));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIdleCount();
            result = result * 59 + this.getTotalCount();
            String $usageGroupKey = this.getUsageGroupKey();
            result = result * 59 + ($usageGroupKey == null ? 43 : $usageGroupKey.hashCode());
            return result;
        }

        public String toString() {
            return "GetClusterUsageResponse.UsageByGroupKey(usageGroupKey=" + this.getUsageGroupKey() + ", idleCount=" + this.getIdleCount() + ", totalCount=" + this.getTotalCount() + ")";
        }

        public static class UsageByGroupKeyBuilder {
            private String usageGroupKey;
            private int idleCount;
            private int totalCount;

            UsageByGroupKeyBuilder() {
            }

            public UsageByGroupKeyBuilder usageGroupKey(String usageGroupKey) {
                this.usageGroupKey = usageGroupKey;
                return this;
            }

            public UsageByGroupKeyBuilder idleCount(int idleCount) {
                this.idleCount = idleCount;
                return this;
            }

            public UsageByGroupKeyBuilder totalCount(int totalCount) {
                this.totalCount = totalCount;
                return this;
            }

            public UsageByGroupKey build() {
                return new UsageByGroupKey(this.usageGroupKey, this.idleCount, this.totalCount);
            }

            public String toString() {
                return "GetClusterUsageResponse.UsageByGroupKey.UsageByGroupKeyBuilder(usageGroupKey=" + this.usageGroupKey + ", idleCount=" + this.idleCount + ", totalCount=" + this.totalCount + ")";
            }
        }
    }
}

