/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster.proto;

import io.mantisrx.master.resourcecluster.proto.MantisResourceClusterEnvType;
import io.mantisrx.master.resourcecluster.proto.SkuSizeSpec;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ContainerSkuID;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class MantisResourceClusterSpec {
    private final String name;
    private final ClusterID id;
    private final String ownerName;
    private final String ownerEmail;
    private final MantisResourceClusterEnvType envType;
    private final Set<SkuTypeSpec> skuSpecs;
    private final Map<String, String> clusterMetadataFields;

    @JsonCreator
    public MantisResourceClusterSpec(@JsonProperty(value="name") String name, @JsonProperty(value="id") ClusterID id, @JsonProperty(value="ownerName") String ownerName, @JsonProperty(value="ownerEmail") String ownerEmail, @JsonProperty(value="envType") MantisResourceClusterEnvType envType, @JsonProperty(value="skuSpecs") Set<SkuTypeSpec> skuSpecs, @JsonProperty(value="clusterMetadataFields") Map<String, String> clusterMetadataFields) {
        this.name = name;
        this.id = id;
        this.ownerName = ownerName;
        this.ownerEmail = ownerEmail;
        this.envType = envType;
        this.skuSpecs = skuSpecs;
        this.clusterMetadataFields = clusterMetadataFields;
    }

    public static MantisResourceClusterSpecBuilder builder() {
        return new MantisResourceClusterSpecBuilder();
    }

    public String getName() {
        return this.name;
    }

    public ClusterID getId() {
        return this.id;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public MantisResourceClusterEnvType getEnvType() {
        return this.envType;
    }

    public Set<SkuTypeSpec> getSkuSpecs() {
        return this.skuSpecs;
    }

    public Map<String, String> getClusterMetadataFields() {
        return this.clusterMetadataFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MantisResourceClusterSpec)) {
            return false;
        }
        MantisResourceClusterSpec other = (MantisResourceClusterSpec)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ClusterID this$id = this.getId();
        ClusterID other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$ownerName = this.getOwnerName();
        String other$ownerName = other.getOwnerName();
        if (this$ownerName == null ? other$ownerName != null : !this$ownerName.equals(other$ownerName)) {
            return false;
        }
        String this$ownerEmail = this.getOwnerEmail();
        String other$ownerEmail = other.getOwnerEmail();
        if (this$ownerEmail == null ? other$ownerEmail != null : !this$ownerEmail.equals(other$ownerEmail)) {
            return false;
        }
        MantisResourceClusterEnvType this$envType = this.getEnvType();
        MantisResourceClusterEnvType other$envType = other.getEnvType();
        if (this$envType == null ? other$envType != null : !((Object)((Object)this$envType)).equals((Object)other$envType)) {
            return false;
        }
        Set<SkuTypeSpec> this$skuSpecs = this.getSkuSpecs();
        Set<SkuTypeSpec> other$skuSpecs = other.getSkuSpecs();
        if (this$skuSpecs == null ? other$skuSpecs != null : !((Object)this$skuSpecs).equals(other$skuSpecs)) {
            return false;
        }
        Map<String, String> this$clusterMetadataFields = this.getClusterMetadataFields();
        Map<String, String> other$clusterMetadataFields = other.getClusterMetadataFields();
        return !(this$clusterMetadataFields == null ? other$clusterMetadataFields != null : !((Object)this$clusterMetadataFields).equals(other$clusterMetadataFields));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ClusterID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $ownerName = this.getOwnerName();
        result = result * 59 + ($ownerName == null ? 43 : $ownerName.hashCode());
        String $ownerEmail = this.getOwnerEmail();
        result = result * 59 + ($ownerEmail == null ? 43 : $ownerEmail.hashCode());
        MantisResourceClusterEnvType $envType = this.getEnvType();
        result = result * 59 + ($envType == null ? 43 : ((Object)((Object)$envType)).hashCode());
        Set<SkuTypeSpec> $skuSpecs = this.getSkuSpecs();
        result = result * 59 + ($skuSpecs == null ? 43 : ((Object)$skuSpecs).hashCode());
        Map<String, String> $clusterMetadataFields = this.getClusterMetadataFields();
        result = result * 59 + ($clusterMetadataFields == null ? 43 : ((Object)$clusterMetadataFields).hashCode());
        return result;
    }

    public String toString() {
        return "MantisResourceClusterSpec(name=" + this.getName() + ", id=" + this.getId() + ", ownerName=" + this.getOwnerName() + ", ownerEmail=" + this.getOwnerEmail() + ", envType=" + (Object)((Object)this.getEnvType()) + ", skuSpecs=" + this.getSkuSpecs() + ", clusterMetadataFields=" + this.getClusterMetadataFields() + ")";
    }

    public static class MantisResourceClusterSpecBuilder {
        private String name;
        private ClusterID id;
        private String ownerName;
        private String ownerEmail;
        private MantisResourceClusterEnvType envType;
        private ArrayList<SkuTypeSpec> skuSpecs;
        private ArrayList<String> clusterMetadataFields$key;
        private ArrayList<String> clusterMetadataFields$value;

        MantisResourceClusterSpecBuilder() {
        }

        public MantisResourceClusterSpecBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MantisResourceClusterSpecBuilder id(ClusterID id) {
            this.id = id;
            return this;
        }

        public MantisResourceClusterSpecBuilder ownerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public MantisResourceClusterSpecBuilder ownerEmail(String ownerEmail) {
            this.ownerEmail = ownerEmail;
            return this;
        }

        public MantisResourceClusterSpecBuilder envType(MantisResourceClusterEnvType envType) {
            this.envType = envType;
            return this;
        }

        public MantisResourceClusterSpecBuilder skuSpec(SkuTypeSpec skuSpec) {
            if (this.skuSpecs == null) {
                this.skuSpecs = new ArrayList();
            }
            this.skuSpecs.add(skuSpec);
            return this;
        }

        public MantisResourceClusterSpecBuilder skuSpecs(Collection<? extends SkuTypeSpec> skuSpecs) {
            if (skuSpecs == null) {
                throw new NullPointerException("skuSpecs cannot be null");
            }
            if (this.skuSpecs == null) {
                this.skuSpecs = new ArrayList();
            }
            this.skuSpecs.addAll(skuSpecs);
            return this;
        }

        public MantisResourceClusterSpecBuilder clearSkuSpecs() {
            if (this.skuSpecs != null) {
                this.skuSpecs.clear();
            }
            return this;
        }

        public MantisResourceClusterSpecBuilder clusterMetadataField(String clusterMetadataFieldKey, String clusterMetadataFieldValue) {
            if (this.clusterMetadataFields$key == null) {
                this.clusterMetadataFields$key = new ArrayList();
                this.clusterMetadataFields$value = new ArrayList();
            }
            this.clusterMetadataFields$key.add(clusterMetadataFieldKey);
            this.clusterMetadataFields$value.add(clusterMetadataFieldValue);
            return this;
        }

        public MantisResourceClusterSpecBuilder clusterMetadataFields(Map<? extends String, ? extends String> clusterMetadataFields) {
            if (clusterMetadataFields == null) {
                throw new NullPointerException("clusterMetadataFields cannot be null");
            }
            if (this.clusterMetadataFields$key == null) {
                this.clusterMetadataFields$key = new ArrayList();
                this.clusterMetadataFields$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : clusterMetadataFields.entrySet()) {
                this.clusterMetadataFields$key.add($lombokEntry.getKey());
                this.clusterMetadataFields$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public MantisResourceClusterSpecBuilder clearClusterMetadataFields() {
            if (this.clusterMetadataFields$key != null) {
                this.clusterMetadataFields$key.clear();
                this.clusterMetadataFields$value.clear();
            }
            return this;
        }

        public MantisResourceClusterSpec build() {
            Map<String, String> clusterMetadataFields;
            Set<Object> skuSpecs;
            switch (this.skuSpecs == null ? 0 : this.skuSpecs.size()) {
                case 0: {
                    skuSpecs = Collections.emptySet();
                    break;
                }
                case 1: {
                    skuSpecs = Collections.singleton(this.skuSpecs.get(0));
                    break;
                }
                default: {
                    skuSpecs = new LinkedHashSet(this.skuSpecs.size() < 0x40000000 ? 1 + this.skuSpecs.size() + (this.skuSpecs.size() - 3) / 3 : Integer.MAX_VALUE);
                    skuSpecs.addAll(this.skuSpecs);
                    skuSpecs = Collections.unmodifiableSet(skuSpecs);
                }
            }
            switch (this.clusterMetadataFields$key == null ? 0 : this.clusterMetadataFields$key.size()) {
                case 0: {
                    clusterMetadataFields = Collections.emptyMap();
                    break;
                }
                case 1: {
                    clusterMetadataFields = Collections.singletonMap(this.clusterMetadataFields$key.get(0), this.clusterMetadataFields$value.get(0));
                    break;
                }
                default: {
                    clusterMetadataFields = new LinkedHashMap(this.clusterMetadataFields$key.size() < 0x40000000 ? 1 + this.clusterMetadataFields$key.size() + (this.clusterMetadataFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.clusterMetadataFields$key.size(); ++$i) {
                        clusterMetadataFields.put(this.clusterMetadataFields$key.get($i), this.clusterMetadataFields$value.get($i));
                    }
                    clusterMetadataFields = Collections.unmodifiableMap(clusterMetadataFields);
                }
            }
            return new MantisResourceClusterSpec(this.name, this.id, this.ownerName, this.ownerEmail, this.envType, skuSpecs, clusterMetadataFields);
        }

        public String toString() {
            return "MantisResourceClusterSpec.MantisResourceClusterSpecBuilder(name=" + this.name + ", id=" + this.id + ", ownerName=" + this.ownerName + ", ownerEmail=" + this.ownerEmail + ", envType=" + (Object)((Object)this.envType) + ", skuSpecs=" + this.skuSpecs + ", clusterMetadataFields$key=" + this.clusterMetadataFields$key + ", clusterMetadataFields$value=" + this.clusterMetadataFields$value + ")";
        }
    }

    public static final class SkuCapacity {
        private final ContainerSkuID skuId;
        private final int minSize;
        private final int maxSize;
        private final int desireSize;

        @JsonCreator
        public SkuCapacity(@JsonProperty(value="skuId") ContainerSkuID skuId, @JsonProperty(value="minSize") int minSize, @JsonProperty(value="maxSize") int maxSize, @JsonProperty(value="desireSize") int desireSize) {
            this.skuId = skuId;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.desireSize = desireSize;
        }

        public static SkuCapacityBuilder builder() {
            return new SkuCapacityBuilder();
        }

        public ContainerSkuID getSkuId() {
            return this.skuId;
        }

        public int getMinSize() {
            return this.minSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public int getDesireSize() {
            return this.desireSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SkuCapacity)) {
                return false;
            }
            SkuCapacity other = (SkuCapacity)o;
            if (this.getMinSize() != other.getMinSize()) {
                return false;
            }
            if (this.getMaxSize() != other.getMaxSize()) {
                return false;
            }
            if (this.getDesireSize() != other.getDesireSize()) {
                return false;
            }
            ContainerSkuID this$skuId = this.getSkuId();
            ContainerSkuID other$skuId = other.getSkuId();
            return !(this$skuId == null ? other$skuId != null : !this$skuId.equals(other$skuId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMinSize();
            result = result * 59 + this.getMaxSize();
            result = result * 59 + this.getDesireSize();
            ContainerSkuID $skuId = this.getSkuId();
            result = result * 59 + ($skuId == null ? 43 : $skuId.hashCode());
            return result;
        }

        public String toString() {
            return "MantisResourceClusterSpec.SkuCapacity(skuId=" + this.getSkuId() + ", minSize=" + this.getMinSize() + ", maxSize=" + this.getMaxSize() + ", desireSize=" + this.getDesireSize() + ")";
        }

        public static class SkuCapacityBuilder {
            private ContainerSkuID skuId;
            private int minSize;
            private int maxSize;
            private int desireSize;

            SkuCapacityBuilder() {
            }

            public SkuCapacityBuilder skuId(ContainerSkuID skuId) {
                this.skuId = skuId;
                return this;
            }

            public SkuCapacityBuilder minSize(int minSize) {
                this.minSize = minSize;
                return this;
            }

            public SkuCapacityBuilder maxSize(int maxSize) {
                this.maxSize = maxSize;
                return this;
            }

            public SkuCapacityBuilder desireSize(int desireSize) {
                this.desireSize = desireSize;
                return this;
            }

            public SkuCapacity build() {
                return new SkuCapacity(this.skuId, this.minSize, this.maxSize, this.desireSize);
            }

            public String toString() {
                return "MantisResourceClusterSpec.SkuCapacity.SkuCapacityBuilder(skuId=" + this.skuId + ", minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", desireSize=" + this.desireSize + ")";
            }
        }
    }

    public static final class SkuTypeSpec {
        private final ContainerSkuID skuId;
        private final SkuCapacity capacity;
        private final String imageId;
        @Deprecated
        private final int cpuCoreCount;
        @Deprecated
        private final int memorySizeInMB;
        @Deprecated
        private final int networkMbps;
        @Deprecated
        private final int diskSizeInMB;
        private final Map<String, String> skuMetadataFields;
        @Nullable
        private final SkuSizeSpec size;

        @JsonCreator
        public SkuTypeSpec(@JsonProperty(value="skuId") ContainerSkuID skuId, @JsonProperty(value="capacity") SkuCapacity capacity, @JsonProperty(value="imageId") String imageId, @JsonProperty(value="cpuCoreCount") int cpuCoreCount, @JsonProperty(value="memorySizeInBytes") int memorySizeInMB, @JsonProperty(value="networkMbps") int networkMbps, @JsonProperty(value="diskSizeInBytes") int diskSizeInMB, @JsonProperty(value="skuMetadataFields") Map<String, String> skuMetadataFields, @JsonProperty(value="size") SkuSizeSpec size) {
            this.skuId = skuId;
            this.capacity = capacity;
            this.imageId = imageId;
            this.cpuCoreCount = cpuCoreCount;
            this.memorySizeInMB = memorySizeInMB;
            this.networkMbps = networkMbps;
            this.diskSizeInMB = diskSizeInMB;
            this.skuMetadataFields = skuMetadataFields;
            this.size = size;
        }

        public static SkuTypeSpecBuilder builder() {
            return new SkuTypeSpecBuilder();
        }

        public ContainerSkuID getSkuId() {
            return this.skuId;
        }

        public SkuCapacity getCapacity() {
            return this.capacity;
        }

        public String getImageId() {
            return this.imageId;
        }

        @Deprecated
        public int getCpuCoreCount() {
            return this.cpuCoreCount;
        }

        @Deprecated
        public int getMemorySizeInMB() {
            return this.memorySizeInMB;
        }

        @Deprecated
        public int getNetworkMbps() {
            return this.networkMbps;
        }

        @Deprecated
        public int getDiskSizeInMB() {
            return this.diskSizeInMB;
        }

        public Map<String, String> getSkuMetadataFields() {
            return this.skuMetadataFields;
        }

        @Nullable
        public SkuSizeSpec getSize() {
            return this.size;
        }

        public String toString() {
            return "MantisResourceClusterSpec.SkuTypeSpec(skuId=" + this.getSkuId() + ", capacity=" + this.getCapacity() + ", imageId=" + this.getImageId() + ", cpuCoreCount=" + this.getCpuCoreCount() + ", memorySizeInMB=" + this.getMemorySizeInMB() + ", networkMbps=" + this.getNetworkMbps() + ", diskSizeInMB=" + this.getDiskSizeInMB() + ", skuMetadataFields=" + this.getSkuMetadataFields() + ", size=" + this.getSize() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SkuTypeSpec)) {
                return false;
            }
            SkuTypeSpec other = (SkuTypeSpec)o;
            ContainerSkuID this$skuId = this.getSkuId();
            ContainerSkuID other$skuId = other.getSkuId();
            return !(this$skuId == null ? other$skuId != null : !this$skuId.equals(other$skuId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ContainerSkuID $skuId = this.getSkuId();
            result = result * 59 + ($skuId == null ? 43 : $skuId.hashCode());
            return result;
        }

        public static class SkuTypeSpecBuilder {
            private ContainerSkuID skuId;
            private SkuCapacity capacity;
            private String imageId;
            private int cpuCoreCount;
            private int memorySizeInMB;
            private int networkMbps;
            private int diskSizeInMB;
            private ArrayList<String> skuMetadataFields$key;
            private ArrayList<String> skuMetadataFields$value;
            private SkuSizeSpec size;

            SkuTypeSpecBuilder() {
            }

            public SkuTypeSpecBuilder skuId(ContainerSkuID skuId) {
                this.skuId = skuId;
                return this;
            }

            public SkuTypeSpecBuilder capacity(SkuCapacity capacity) {
                this.capacity = capacity;
                return this;
            }

            public SkuTypeSpecBuilder imageId(String imageId) {
                this.imageId = imageId;
                return this;
            }

            @Deprecated
            public SkuTypeSpecBuilder cpuCoreCount(int cpuCoreCount) {
                this.cpuCoreCount = cpuCoreCount;
                return this;
            }

            @Deprecated
            public SkuTypeSpecBuilder memorySizeInMB(int memorySizeInMB) {
                this.memorySizeInMB = memorySizeInMB;
                return this;
            }

            @Deprecated
            public SkuTypeSpecBuilder networkMbps(int networkMbps) {
                this.networkMbps = networkMbps;
                return this;
            }

            @Deprecated
            public SkuTypeSpecBuilder diskSizeInMB(int diskSizeInMB) {
                this.diskSizeInMB = diskSizeInMB;
                return this;
            }

            public SkuTypeSpecBuilder skuMetadataField(String skuMetadataFieldKey, String skuMetadataFieldValue) {
                if (this.skuMetadataFields$key == null) {
                    this.skuMetadataFields$key = new ArrayList();
                    this.skuMetadataFields$value = new ArrayList();
                }
                this.skuMetadataFields$key.add(skuMetadataFieldKey);
                this.skuMetadataFields$value.add(skuMetadataFieldValue);
                return this;
            }

            public SkuTypeSpecBuilder skuMetadataFields(Map<? extends String, ? extends String> skuMetadataFields) {
                if (skuMetadataFields == null) {
                    throw new NullPointerException("skuMetadataFields cannot be null");
                }
                if (this.skuMetadataFields$key == null) {
                    this.skuMetadataFields$key = new ArrayList();
                    this.skuMetadataFields$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends String> $lombokEntry : skuMetadataFields.entrySet()) {
                    this.skuMetadataFields$key.add($lombokEntry.getKey());
                    this.skuMetadataFields$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public SkuTypeSpecBuilder clearSkuMetadataFields() {
                if (this.skuMetadataFields$key != null) {
                    this.skuMetadataFields$key.clear();
                    this.skuMetadataFields$value.clear();
                }
                return this;
            }

            public SkuTypeSpecBuilder size(@Nullable SkuSizeSpec size) {
                this.size = size;
                return this;
            }

            public SkuTypeSpec build() {
                Map<String, String> skuMetadataFields;
                switch (this.skuMetadataFields$key == null ? 0 : this.skuMetadataFields$key.size()) {
                    case 0: {
                        skuMetadataFields = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        skuMetadataFields = Collections.singletonMap(this.skuMetadataFields$key.get(0), this.skuMetadataFields$value.get(0));
                        break;
                    }
                    default: {
                        skuMetadataFields = new LinkedHashMap(this.skuMetadataFields$key.size() < 0x40000000 ? 1 + this.skuMetadataFields$key.size() + (this.skuMetadataFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.skuMetadataFields$key.size(); ++$i) {
                            skuMetadataFields.put(this.skuMetadataFields$key.get($i), this.skuMetadataFields$value.get($i));
                        }
                        skuMetadataFields = Collections.unmodifiableMap(skuMetadataFields);
                    }
                }
                return new SkuTypeSpec(this.skuId, this.capacity, this.imageId, this.cpuCoreCount, this.memorySizeInMB, this.networkMbps, this.diskSizeInMB, skuMetadataFields, this.size);
            }

            public String toString() {
                return "MantisResourceClusterSpec.SkuTypeSpec.SkuTypeSpecBuilder(skuId=" + this.skuId + ", capacity=" + this.capacity + ", imageId=" + this.imageId + ", cpuCoreCount=" + this.cpuCoreCount + ", memorySizeInMB=" + this.memorySizeInMB + ", networkMbps=" + this.networkMbps + ", diskSizeInMB=" + this.diskSizeInMB + ", skuMetadataFields$key=" + this.skuMetadataFields$key + ", skuMetadataFields$value=" + this.skuMetadataFields$value + ", size=" + this.size + ")";
            }
        }
    }
}

