/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster.proto;

import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ContainerSkuID;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;

public final class ResourceClusterScaleSpec {
    private final ClusterID clusterId;
    private final ContainerSkuID skuId;
    private final int minIdleToKeep;
    private final int minSize;
    private final int maxIdleToKeep;
    private final int maxSize;
    private final long coolDownSecs;

    @JsonCreator
    public ResourceClusterScaleSpec(@JsonProperty(value="clusterId") ClusterID clusterId, @JsonProperty(value="skuId") ContainerSkuID skuId, @JsonProperty(value="minIdleToKeep") int minIdleToKeep, @JsonProperty(value="minSize") int minSize, @JsonProperty(value="maxIdleToKeep") int maxIdleToKeep, @JsonProperty(value="maxSize") int maxSize, @JsonProperty(value="coolDownSecs") long coolDownSecs) {
        this.clusterId = clusterId;
        this.skuId = skuId;
        this.minIdleToKeep = minIdleToKeep;
        this.minSize = minSize;
        this.maxIdleToKeep = maxIdleToKeep;
        this.maxSize = maxSize;
        this.coolDownSecs = coolDownSecs;
    }

    public static ResourceClusterScaleSpecBuilder builder() {
        return new ResourceClusterScaleSpecBuilder();
    }

    public ClusterID getClusterId() {
        return this.clusterId;
    }

    public ContainerSkuID getSkuId() {
        return this.skuId;
    }

    public int getMinIdleToKeep() {
        return this.minIdleToKeep;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxIdleToKeep() {
        return this.maxIdleToKeep;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getCoolDownSecs() {
        return this.coolDownSecs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceClusterScaleSpec)) {
            return false;
        }
        ResourceClusterScaleSpec other = (ResourceClusterScaleSpec)o;
        if (this.getMinIdleToKeep() != other.getMinIdleToKeep()) {
            return false;
        }
        if (this.getMinSize() != other.getMinSize()) {
            return false;
        }
        if (this.getMaxIdleToKeep() != other.getMaxIdleToKeep()) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        if (this.getCoolDownSecs() != other.getCoolDownSecs()) {
            return false;
        }
        ClusterID this$clusterId = this.getClusterId();
        ClusterID other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
            return false;
        }
        ContainerSkuID this$skuId = this.getSkuId();
        ContainerSkuID other$skuId = other.getSkuId();
        return !(this$skuId == null ? other$skuId != null : !this$skuId.equals(other$skuId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinIdleToKeep();
        result = result * 59 + this.getMinSize();
        result = result * 59 + this.getMaxIdleToKeep();
        result = result * 59 + this.getMaxSize();
        long $coolDownSecs = this.getCoolDownSecs();
        result = result * 59 + (int)($coolDownSecs >>> 32 ^ $coolDownSecs);
        ClusterID $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        ContainerSkuID $skuId = this.getSkuId();
        result = result * 59 + ($skuId == null ? 43 : $skuId.hashCode());
        return result;
    }

    public String toString() {
        return "ResourceClusterScaleSpec(clusterId=" + this.getClusterId() + ", skuId=" + this.getSkuId() + ", minIdleToKeep=" + this.getMinIdleToKeep() + ", minSize=" + this.getMinSize() + ", maxIdleToKeep=" + this.getMaxIdleToKeep() + ", maxSize=" + this.getMaxSize() + ", coolDownSecs=" + this.getCoolDownSecs() + ")";
    }

    public static class ResourceClusterScaleSpecBuilder {
        private ClusterID clusterId;
        private ContainerSkuID skuId;
        private int minIdleToKeep;
        private int minSize;
        private int maxIdleToKeep;
        private int maxSize;
        private long coolDownSecs;

        ResourceClusterScaleSpecBuilder() {
        }

        public ResourceClusterScaleSpecBuilder clusterId(ClusterID clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public ResourceClusterScaleSpecBuilder skuId(ContainerSkuID skuId) {
            this.skuId = skuId;
            return this;
        }

        public ResourceClusterScaleSpecBuilder minIdleToKeep(int minIdleToKeep) {
            this.minIdleToKeep = minIdleToKeep;
            return this;
        }

        public ResourceClusterScaleSpecBuilder minSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public ResourceClusterScaleSpecBuilder maxIdleToKeep(int maxIdleToKeep) {
            this.maxIdleToKeep = maxIdleToKeep;
            return this;
        }

        public ResourceClusterScaleSpecBuilder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public ResourceClusterScaleSpecBuilder coolDownSecs(long coolDownSecs) {
            this.coolDownSecs = coolDownSecs;
            return this;
        }

        public ResourceClusterScaleSpec build() {
            return new ResourceClusterScaleSpec(this.clusterId, this.skuId, this.minIdleToKeep, this.minSize, this.maxIdleToKeep, this.maxSize, this.coolDownSecs);
        }

        public String toString() {
            return "ResourceClusterScaleSpec.ResourceClusterScaleSpecBuilder(clusterId=" + this.clusterId + ", skuId=" + this.skuId + ", minIdleToKeep=" + this.minIdleToKeep + ", minSize=" + this.minSize + ", maxIdleToKeep=" + this.maxIdleToKeep + ", maxSize=" + this.maxSize + ", coolDownSecs=" + this.coolDownSecs + ")";
        }
    }
}

