/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.scheduler;

import io.mantisrx.master.scheduler.FitnessCalculator;
import io.mantisrx.runtime.MachineDefinition;

public class CpuWeightedFitnessCalculator
implements FitnessCalculator {
    @Override
    public double calculate(MachineDefinition requested, MachineDefinition available) {
        if (!available.canFit(requested)) {
            return 0.0;
        }
        double cpuScore = 1.0 - (available.getCpuCores() - requested.getCpuCores()) / available.getCpuCores();
        double memoryScore = 1.0 - (available.getMemoryMB() - requested.getMemoryMB()) / available.getMemoryMB();
        return (18.0 * cpuScore + memoryScore) / 19.0;
    }
}

