/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.zk;

import io.mantisrx.server.core.BaseService;
import io.mantisrx.server.master.ILeadershipManager;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.leader.LeaderLatch;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import io.mantisrx.shaded.org.apache.zookeeper.CreateMode;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElector
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(LeaderElector.class);
    private volatile boolean started = false;
    private final ObjectMapper jsonMapper;
    private final ILeadershipManager leadershipManager;
    private final LeaderLatch leaderLatch;
    private final CuratorFramework curator;
    private final String electionPath;
    private final String leaderPath;

    private LeaderElector(ObjectMapper jsonMapper, ILeadershipManager leadershipManager, CuratorFramework curator, String electionPath, String leaderPath) {
        super(false);
        this.jsonMapper = jsonMapper;
        this.leadershipManager = leadershipManager;
        this.curator = curator;
        this.leaderLatch = this.createNewLeaderLatch(electionPath);
        this.electionPath = electionPath;
        this.leaderPath = leaderPath;
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        try {
            Stat pathStat = (Stat)this.curator.checkExists().forPath(this.leaderPath);
            if (pathStat == null) {
                ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(this.leaderPath);
            }
            this.leaderLatch.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create a leader elector for master: " + e.getMessage(), e);
        }
    }

    public void shutdown() {
        try {
            this.leaderLatch.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close the leader latch: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.started = false;
        }
    }

    private LeaderLatch createNewLeaderLatch(String leaderPath) {
        LeaderLatch newLeaderLatch = new LeaderLatch(this.curator, leaderPath, "127.0.0.1");
        newLeaderLatch.addListener(new LeaderLatchListener(){

            public void isLeader() {
                LeaderElector.this.announceLeader();
            }

            public void notLeader() {
                LeaderElector.this.leadershipManager.stopBeingLeader();
            }
        }, (Executor)Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("MasterLeader-%s")));
        return newLeaderLatch;
    }

    private void announceLeader() {
        try {
            logger.info("Announcing leader");
            byte[] masterDescription = this.jsonMapper.writeValueAsBytes((Object)this.leadershipManager.getDescription());
            ((ErrorListenerPathAndBytesable)this.curator.setData().inBackground((client, event) -> {
                if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                    this.leadershipManager.becomeLeader();
                } else {
                    logger.warn("Failed to elect leader from path {} with event {}", (Object)this.leaderPath, (Object)event);
                }
            })).forPath(this.leaderPath, masterDescription);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to announce leader: " + e.getMessage(), e);
        }
    }

    public static Builder builder(ILeadershipManager manager) {
        return new Builder(manager);
    }

    public static class Builder {
        private ObjectMapper jsonMapper;
        private ILeadershipManager leadershipManager;
        private CuratorFramework curator;
        private String electionPath;
        private String announcementPath;

        public Builder(ILeadershipManager leadershipManager) {
            this.leadershipManager = leadershipManager;
        }

        public Builder withJsonMapper(ObjectMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
            return this;
        }

        public Builder withCurator(CuratorFramework curator) {
            this.curator = curator;
            return this;
        }

        public Builder withElectionPath(String path) {
            this.electionPath = path;
            return this;
        }

        public Builder withAnnouncementPath(String annPath) {
            this.announcementPath = annPath;
            return this;
        }

        public LeaderElector build() {
            return new LeaderElector(this.jsonMapper, this.leadershipManager, this.curator, this.electionPath, this.announcementPath);
        }
    }
}

