/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master;

import com.netflix.fenzo.ConstraintEvaluator;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTrackerState;
import com.netflix.fenzo.VirtualMachineCurrentState;
import java.util.Map;
import org.apache.mesos.Protos;

public class ClusterAffinityConstraint
implements ConstraintEvaluator {
    private final String asgAttributeName;
    private final String clusterName;
    private final String name;

    public ClusterAffinityConstraint(String clusterAttributeName, String clusterName) {
        this.asgAttributeName = clusterAttributeName;
        this.clusterName = clusterName;
        this.name = ClusterAffinityConstraint.class.getName() + "-" + clusterAttributeName;
    }

    public String getName() {
        return this.name;
    }

    public ConstraintEvaluator.Result evaluate(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
        Map attributeMap = targetVM.getCurrAvailableResources().getAttributeMap();
        if (this.asgAttributeName != null && attributeMap != null && attributeMap.get(this.asgAttributeName) != null && ((Protos.Attribute)attributeMap.get(this.asgAttributeName)).getText().isInitialized()) {
            String targetClusterName = ((Protos.Attribute)attributeMap.get(this.asgAttributeName)).getText().getValue();
            if (targetClusterName.startsWith(this.clusterName)) {
                return new ConstraintEvaluator.Result(true, "");
            }
            return new ConstraintEvaluator.Result(false, this.asgAttributeName + " does not begin with " + this.clusterName);
        }
        return new ConstraintEvaluator.Result(false, this.asgAttributeName + " unavailable on host " + targetVM.getCurrAvailableResources().hostname());
    }
}

