/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master;

import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTrackerState;
import com.netflix.fenzo.VMTaskFitnessCalculator;
import com.netflix.fenzo.VirtualMachineCurrentState;
import com.netflix.fenzo.VirtualMachineLease;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.scheduler.ScheduleRequest;
import java.util.Optional;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterFitnessCalculator
implements VMTaskFitnessCalculator {
    private static final Logger logger = LoggerFactory.getLogger(ClusterFitnessCalculator.class);
    private final String clusterAttributeName = ConfigurationProvider.getConfig().getSlaveClusterAttributeName();

    private Optional<String> getAttribute(VirtualMachineLease lease, String attributeName) {
        boolean hasValue = lease.getAttributeMap() != null && lease.getAttributeMap().get(attributeName) != null && ((Protos.Attribute)lease.getAttributeMap().get(attributeName)).getText().hasValue();
        return hasValue ? Optional.of(((Protos.Attribute)lease.getAttributeMap().get(attributeName)).getText().getValue()) : Optional.empty();
    }

    public String getName() {
        return "Mantis Job Cluster Fitness Calculator";
    }

    public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
        Optional<String> targetVMCluster;
        Optional<String> preferredCluster = ((ScheduleRequest)taskRequest).getPreferredCluster();
        if (!(!preferredCluster.isPresent() || (targetVMCluster = this.getAttribute(targetVM.getCurrAvailableResources(), this.clusterAttributeName)).isPresent() && targetVMCluster.get().equals(preferredCluster.get()))) {
            if (logger.isDebugEnabled()) {
                logger.debug("preferred cluster {} targetVM cluster {}", (Object)preferredCluster.get(), (Object)targetVMCluster.orElse("missing"));
            }
            return 0.8;
        }
        return 1.0;
    }
}

