/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master;

import com.netflix.fenzo.AsSoftConstraint;
import com.netflix.fenzo.ConstraintEvaluator;
import com.netflix.fenzo.VMTaskFitnessCalculator;
import com.netflix.fenzo.functions.Func1;
import com.netflix.fenzo.plugins.BalancedHostAttrConstraint;
import com.netflix.fenzo.plugins.ExclusiveHostConstraint;
import com.netflix.fenzo.plugins.UniqueHostAttrConstraint;
import io.mantisrx.runtime.JobConstraints;
import io.mantisrx.server.master.ClusterAffinityConstraint;
import io.mantisrx.server.master.config.ConfigurationProvider;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintsEvaluators {
    private static final String MANTISAGENT_MAIN_M4 = "mantisagent-main-m4";
    private static final String MANTISAGENT_MAIN_M3 = "mantisagent-main-m3";
    private static final String MANTISAGENT_MAIN_M5 = "mantisagent-main-m5";
    private static final int EXPECTED_NUM_ZONES = 3;
    private static final Logger logger = LoggerFactory.getLogger(ConstraintsEvaluators.class);
    public static ExclusiveHostConstraint exclusiveHostConstraint = new ExclusiveHostConstraint();

    public static ConstraintEvaluator hardConstraint(JobConstraints constraint, final Set<String> coTasks) {
        switch (constraint) {
            case ExclusiveHost: {
                return exclusiveHostConstraint;
            }
            case UniqueHost: {
                return new UniqueHostAttrConstraint((Func1)new Func1<String, Set<String>>(){

                    public Set<String> call(String s) {
                        return coTasks;
                    }
                });
            }
            case ZoneBalance: {
                return new BalancedHostAttrConstraint((Func1)new Func1<String, Set<String>>(){

                    public Set<String> call(String s) {
                        return coTasks;
                    }
                }, ConstraintsEvaluators.zoneAttributeName(), 3);
            }
            case M4Cluster: {
                return new ClusterAffinityConstraint(ConstraintsEvaluators.asgAttributeName(), MANTISAGENT_MAIN_M4);
            }
            case M3Cluster: {
                return new ClusterAffinityConstraint(ConstraintsEvaluators.asgAttributeName(), MANTISAGENT_MAIN_M3);
            }
            case M5Cluster: {
                return new ClusterAffinityConstraint(ConstraintsEvaluators.asgAttributeName(), MANTISAGENT_MAIN_M5);
            }
        }
        logger.error("Unknown job hard constraint " + constraint);
        return null;
    }

    public static String asgAttributeName() {
        return ConfigurationProvider.getConfig().getActiveSlaveAttributeName();
    }

    public static String zoneAttributeName() {
        return ConfigurationProvider.getConfig().getHostZoneAttributeName();
    }

    public static VMTaskFitnessCalculator softConstraint(JobConstraints constraint, final Set<String> coTasks) {
        switch (constraint) {
            case ExclusiveHost: {
                return AsSoftConstraint.get((ConstraintEvaluator)exclusiveHostConstraint);
            }
            case UniqueHost: {
                return AsSoftConstraint.get((ConstraintEvaluator)new UniqueHostAttrConstraint((Func1)new Func1<String, Set<String>>(){

                    public Set<String> call(String s) {
                        return coTasks;
                    }
                }));
            }
            case ZoneBalance: {
                return new BalancedHostAttrConstraint((Func1)new Func1<String, Set<String>>(){

                    public Set<String> call(String s) {
                        return coTasks;
                    }
                }, ConstraintsEvaluators.zoneAttributeName(), 3).asSoftConstraint();
            }
            case M4Cluster: {
                return AsSoftConstraint.get((ConstraintEvaluator)new ClusterAffinityConstraint(ConstraintsEvaluators.asgAttributeName(), MANTISAGENT_MAIN_M4));
            }
            case M3Cluster: {
                return AsSoftConstraint.get((ConstraintEvaluator)new ClusterAffinityConstraint(ConstraintsEvaluators.asgAttributeName(), MANTISAGENT_MAIN_M3));
            }
            case M5Cluster: {
                return AsSoftConstraint.get((ConstraintEvaluator)new ClusterAffinityConstraint(ConstraintsEvaluators.asgAttributeName(), MANTISAGENT_MAIN_M5));
            }
        }
        logger.error("Unknown job soft constraint " + constraint);
        return null;
    }
}

