/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master;

import io.mantisrx.server.core.master.MasterDescription;
import io.mantisrx.server.master.ILeadershipManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeadershipManagerLocalImpl
implements ILeadershipManager {
    private static final Logger logger = LoggerFactory.getLogger(LeadershipManagerLocalImpl.class);
    private final MasterDescription masterDescription;
    private volatile boolean isLeader = true;
    private volatile boolean isReady = false;

    public LeadershipManagerLocalImpl(MasterDescription masterDescription) {
        this.masterDescription = masterDescription;
    }

    @Override
    public void becomeLeader() {
        logger.info("Becoming leader now");
        this.isLeader = true;
    }

    @Override
    public boolean isLeader() {
        logger.debug("is leader? {}", (Object)this.isLeader);
        return this.isLeader;
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    @Override
    public void setLeaderReady() {
        logger.info("marking leader READY");
        this.isReady = true;
    }

    @Override
    public void stopBeingLeader() {
        logger.info("Asked to stop being leader now");
        this.isReady = false;
        this.isLeader = false;
    }

    @Override
    public MasterDescription getDescription() {
        return this.masterDescription;
    }
}

