/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master;

import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.spectator.GaugeCallback;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import io.mantisrx.server.core.master.MasterDescription;
import io.mantisrx.server.master.ILeadershipManager;
import io.mantisrx.server.master.MasterMain;
import io.mantisrx.server.master.ServiceLifecycle;
import io.mantisrx.server.master.config.MasterConfiguration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Func0;

public class LeadershipManagerZkImpl
implements ILeadershipManager {
    private static final Logger logger = LoggerFactory.getLogger(LeadershipManagerZkImpl.class);
    private final Gauge isLeaderGauge;
    private final Gauge isLeaderReadyGauge;
    private final AtomicBoolean firstTimeLeaderMode = new AtomicBoolean(false);
    private final MasterConfiguration config;
    private final ServiceLifecycle serviceLifecycle;
    private volatile boolean isLeader = false;
    private volatile boolean isReady = false;
    private volatile Instant becameLeaderAt;

    public LeadershipManagerZkImpl(MasterConfiguration config, ServiceLifecycle serviceLifecycle) {
        this.config = config;
        this.serviceLifecycle = serviceLifecycle;
        MetricGroupId metricGroupId = new MetricGroupId(MasterMain.class.getCanonicalName());
        Func0 leaderSinceInSeconds = () -> {
            if (this.isLeader) {
                return Duration.between(this.becameLeaderAt, Instant.now()).getSeconds();
            }
            return 0.0;
        };
        Metrics m = new Metrics.Builder().id(metricGroupId).addGauge("isLeaderGauge").addGauge("isLeaderReadyGauge").addGauge((Gauge)new GaugeCallback(metricGroupId, "leaderSinceInSeconds", leaderSinceInSeconds)).build();
        m = MetricsRegistry.getInstance().registerAndGet(m);
        this.isLeaderGauge = m.getGauge("isLeaderGauge");
        this.isLeaderReadyGauge = m.getGauge("isLeaderReadyGauge");
    }

    @Override
    public void becomeLeader() {
        logger.info("Becoming leader now");
        if (this.firstTimeLeaderMode.compareAndSet(false, true)) {
            this.serviceLifecycle.becomeLeader();
            this.isLeaderGauge.set(1L);
            this.becameLeaderAt = Instant.now();
        } else {
            logger.warn("Unexpected to be told to enter leader mode more than once, ignoring.");
        }
        this.isLeader = true;
    }

    @Override
    public boolean isLeader() {
        return this.isLeader;
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    @Override
    public void setLeaderReady() {
        logger.info("marking leader READY");
        this.isLeaderReadyGauge.set(1L);
        this.isReady = true;
    }

    @Override
    public void stopBeingLeader() {
        logger.info("Asked to stop being leader now");
        this.isReady = false;
        this.isLeader = false;
        this.isLeaderGauge.set(0L);
        this.isLeaderReadyGauge.set(0L);
        if (!this.firstTimeLeaderMode.get()) {
            logger.warn("Unexpected to be told to stop being leader when we haven't entered leader mode before, ignoring.");
            return;
        }
        logger.error("Exiting due to losing leadership after running as leader");
        System.exit(1);
    }

    @Override
    public MasterDescription getDescription() {
        return new MasterDescription(this.getHost(), this.getHostIP(), this.config.getApiPort(), this.config.getSchedInfoPort(), this.config.getApiPortV2(), this.config.getApiStatusUri(), this.config.getConsolePort(), System.currentTimeMillis());
    }

    private String getHost() {
        String host = this.config.getMasterHost();
        if (host != null) {
            return host;
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to get the host information: " + e.getMessage(), e);
        }
    }

    private String getHostIP() {
        String ip = this.config.getMasterIP();
        if (ip != null) {
            return ip;
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to get the host information: " + e.getMessage(), e);
        }
    }
}

