/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.atomic.AtomicInteger;

public class SchedulerCounters {
    private static final SchedulerCounters instance = new SchedulerCounters();
    private final AtomicInteger iterationNumberCounter = new AtomicInteger();
    private final AtomicInteger numResourceAllocationTrials = new AtomicInteger(0);
    private volatile IterationCounter counter = null;

    private SchedulerCounters() {
    }

    public static SchedulerCounters getInstance() {
        return instance;
    }

    public void incrementResourceAllocationTrials(int delta) {
        this.numResourceAllocationTrials.addAndGet(delta);
    }

    public IterationCounter getCounter() {
        return this.counter;
    }

    void endIteration(int numWorkersToLaunch, int numWorkersLaunched, int numSlavesToUse, int numSlavesRejected) {
        this.counter = new IterationCounter(this.iterationNumberCounter.getAndIncrement(), numWorkersToLaunch, numWorkersLaunched, numSlavesToUse, numSlavesRejected, this.numResourceAllocationTrials.getAndSet(0));
    }

    String toJsonString() {
        return this.counter.toJsonString();
    }

    public class IterationCounter {
        @JsonIgnore
        private final ObjectMapper mapper = new ObjectMapper();
        private int iterationNumber;
        private int numWorkersToLaunch;
        private int numWorkersLaunched;
        private int numSlavesToUse;
        private int numSlavesRejected;
        private int numResourceAllocations;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        IterationCounter(@JsonProperty(value="numWorkersToLaunch") int iterationNumber, @JsonProperty(value="numWorkersLaunched") int numWorkersToLaunch, @JsonProperty(value="numSlavesToUse") int numWorkersLaunched, @JsonProperty(value="numSlavesRejected") int numOffersToUse, @JsonProperty(value="numResourceAllocationTrials") int numOffersRejected, int numResourceAllocations) {
            this.iterationNumber = iterationNumber;
            this.numWorkersToLaunch = numWorkersToLaunch;
            this.numWorkersLaunched = numWorkersLaunched;
            this.numSlavesToUse = numOffersToUse;
            this.numSlavesRejected = numOffersRejected;
            this.numResourceAllocations = numResourceAllocations;
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }

        void setCounters(int numWorkersToLaunch, int numWorkersLaunched, int numOffersToUse, int numOffersRejected) {
            ++this.iterationNumber;
            this.numWorkersToLaunch = numWorkersToLaunch;
            this.numWorkersLaunched = numWorkersLaunched;
            this.numSlavesToUse = numOffersToUse;
            this.numSlavesRejected = numOffersRejected;
        }

        public int getIterationNumber() {
            return this.iterationNumber;
        }

        public int getNumWorkersToLaunch() {
            return this.numWorkersToLaunch;
        }

        public int getNumWorkersLaunched() {
            return this.numWorkersLaunched;
        }

        public int getNumSlavesToUse() {
            return this.numSlavesToUse;
        }

        public int getNumSlavesRejected() {
            return this.numSlavesRejected;
        }

        public int getNumResourceAllocations() {
            return this.numResourceAllocations;
        }

        public String toJsonString() {
            try {
                return this.mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                return this.iterationNumber + ", " + this.numWorkersToLaunch + ", " + this.numWorkersLaunched + ", " + this.numSlavesToUse + ", " + this.numSlavesRejected + ", " + this.numResourceAllocations;
            }
        }
    }
}

