/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master;

import io.mantisrx.server.core.BaseService;
import java.util.Iterator;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(ServiceLifecycle.class);
    private LinkedList<BaseService> servicesList = new LinkedList();

    void addService(BaseService service) {
        if (!this.servicesList.isEmpty()) {
            service.addPredecessor(this.servicesList.getLast());
        }
        this.servicesList.add(service);
    }

    void start() {
        for (BaseService service : this.servicesList) {
            try {
                logger.info("Starting service " + service.getMyServiceCount() + ": " + service);
                service.start();
                logger.info("Successfully started service " + service.getMyServiceCount() + ": " + service);
            }
            catch (Exception e) {
                logger.error(String.format("Failed to start service %d: %s: %s", service.getMyServiceCount(), service, e.getMessage()), (Throwable)e);
                throw e;
            }
        }
    }

    void becomeLeader() {
        for (BaseService service : this.servicesList) {
            service.enterActiveMode();
        }
    }

    void shutdown() {
        if (!this.servicesList.isEmpty()) {
            Iterator<BaseService> iterator = this.servicesList.descendingIterator();
            while (iterator.hasNext()) {
                BaseService service = iterator.next();
                logger.info("Shutting down service " + service.getMyServiceCount() + ": " + service);
                service.shutdown();
                logger.info("Successfully shut down service " + service.getMyServiceCount() + ": " + service);
            }
        }
    }
}

