/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.agentdeploy;

import io.mantisrx.runtime.MigrationStrategy;
import io.mantisrx.runtime.WorkerMigrationConfig;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.utils.MantisClock;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PercentageMigrationStrategy
extends MigrationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(PercentageMigrationStrategy.class);
    private static final int DEFAULT_PERCENT_WORKERS = 10;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final MantisClock clock;
    private final String jobId;
    private final Configuration configuration;

    public PercentageMigrationStrategy(MantisClock clock, String jobId, WorkerMigrationConfig config) {
        super(config);
        long defaultMigrationIntervalMs;
        this.clock = clock;
        this.jobId = jobId;
        try {
            defaultMigrationIntervalMs = ConfigurationProvider.getConfig().getIntervalMoveWorkersOnDisabledVMsMillis();
        }
        catch (IllegalStateException ise) {
            logger.warn("Error reading intervalMoveWorkersOnDisabledVMsMillis from config Provider, will default to 1 minute");
            defaultMigrationIntervalMs = 60000L;
        }
        this.configuration = this.parseConfig(config.getConfigString(), defaultMigrationIntervalMs);
    }

    Configuration parseConfig(String configuration, long defaultMigrationIntervalMs) {
        try {
            return (Configuration)objectMapper.readValue(configuration, Configuration.class);
        }
        catch (IOException e) {
            logger.error("failed to parse config '{}' for job {}, default to {} percent workers migrated every {} millis", new Object[]{configuration, this.jobId, 10, defaultMigrationIntervalMs});
            return new Configuration(10, defaultMigrationIntervalMs);
        }
    }

    public List<Integer> execute(ConcurrentSkipListSet<Integer> workersOnDisabledVms, int numRunningWorkers, int totalNumWorkers, long lastWorkerMigrationTimestamp) {
        if (lastWorkerMigrationTimestamp > this.clock.now() - this.configuration.getIntervalMs()) {
            return Collections.emptyList();
        }
        if (workersOnDisabledVms.isEmpty()) {
            return Collections.emptyList();
        }
        int numInactiveWorkers = totalNumWorkers - numRunningWorkers;
        int numWorkersOnDisabledVM = workersOnDisabledVms.size();
        int numWorkersToMigrate = Math.min(numWorkersOnDisabledVM, Math.max(1, (int)Math.ceil((double)(totalNumWorkers * this.configuration.getPercentToMove()) / 100.0)));
        if (numInactiveWorkers >= numWorkersToMigrate) {
            logger.debug("[{}] num inactive workers {} > num workers to migrate {}, suppressing percent migrate", new Object[]{this.jobId, numInactiveWorkers, numWorkersToMigrate});
            return Collections.emptyList();
        }
        ArrayList<Integer> workersToMigrate = new ArrayList<Integer>(numWorkersToMigrate -= numInactiveWorkers);
        for (int i = numWorkersToMigrate; i > 0; --i) {
            Integer workerToMigrate = workersOnDisabledVms.pollFirst();
            if (workerToMigrate == null) continue;
            workersToMigrate.add(workerToMigrate);
        }
        if (workersToMigrate.size() > 0) {
            logger.debug("migrating jobId {} workers {}", (Object)this.jobId, workersToMigrate);
        }
        return workersToMigrate;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    static class Configuration {
        private final int percentToMove;
        private final long intervalMs;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public Configuration(@JsonProperty(value="percentToMove") int percentToMove, @JsonProperty(value="intervalMs") long intervalMs) {
            this.percentToMove = percentToMove;
            this.intervalMs = intervalMs;
        }

        public int getPercentToMove() {
            return this.percentToMove;
        }

        public long getIntervalMs() {
            return this.intervalMs;
        }
    }
}

