/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.config;

import io.mantisrx.master.jobcluster.job.CostsCalculator;
import io.mantisrx.master.scheduler.FitnessCalculator;
import io.mantisrx.server.core.CoreConfiguration;
import io.mantisrx.server.master.store.KeyValueStore;
import io.mantisrx.shaded.com.google.common.base.Splitter;
import io.mantisrx.shaded.com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Map;
import org.skife.config.Config;
import org.skife.config.Default;
import org.skife.config.DefaultNull;

public interface MasterConfiguration
extends CoreConfiguration {
    @Config(value={"mantis.master.consoleport"})
    public int getConsolePort();

    @Config(value={"mantis.master.apiport"})
    public int getApiPort();

    @Config(value={"mantis.master.schedInfoPort"})
    public int getSchedInfoPort();

    @Config(value={"mantis.master.apiportv2"})
    public int getApiPortV2();

    @Config(value={"mantis.master.metrics.port"})
    public int getMasterMetricsPort();

    @Config(value={"mantis.master.api.status.path"})
    public String getApiStatusUri();

    @Config(value={"mantis.master.storageProvider"})
    public KeyValueStore getStorageProvider();

    @Config(value={"mantis.master.resourceClusterProvider"})
    public String getResourceClusterProvider();

    @Config(value={"mantis.master.host"})
    @DefaultNull
    public String getMasterHost();

    @Config(value={"mantis.master.ip"})
    @DefaultNull
    public String getMasterIP();

    @Config(value={"mesos.worker.timeoutSecondsToReportStart"})
    @Default(value="10")
    public int getTimeoutSecondsToReportStart();

    @Config(value={"mantis.master.leader.mismatch.retry.count"})
    @Default(value="5")
    public int getMasterLeaderMismatchRetryCount();

    @Config(value={"master.shutdown.curator.service.enabled"})
    @Default(value="true")
    public boolean getShutdownCuratorServiceEnabled();

    @Config(value={"mantis.master.api.route.ask.timeout.millis"})
    @Default(value="1000")
    public long getMasterApiAskTimeoutMs();

    @Config(value={"mantis.master.api.route.ask.longOperation.timeout.millis"})
    @Default(value="2500")
    public long getMasterApiLongOperationAskTimeoutMs();

    @Config(value={"mantis.worker.machine.definition.maxCpuCores"})
    @Default(value="8")
    public int getWorkerMachineDefinitionMaxCpuCores();

    @Config(value={"mantis.worker.machine.definition.maxMemoryMB"})
    @Default(value="28000")
    public int getWorkerMachineDefinitionMaxMemoryMB();

    @Config(value={"mantis.worker.machine.definition.maxNetworkMbps"})
    @Default(value="1024")
    public int getWorkerMachineDefinitionMaxNetworkMbps();

    @Config(value={"mantis.master.max.workers.per.stage"})
    @Default(value="1500")
    public int getMaxWorkersPerStage();

    @Config(value={"mantis.master.worker.jvm.memory.scale.back.percent"})
    @Default(value="10")
    public int getWorkerJvmMemoryScaleBackPercentage();

    @Config(value={"mantis.master.active.slave.attribute.name"})
    @Default(value="NETFLIX_AUTO_SCALE_GROUP")
    public String getActiveSlaveAttributeName();

    @Config(value={"mantis.master.slave.cluster.attribute.name"})
    @Default(value="CLUSTER_NAME")
    public String getSlaveClusterAttributeName();

    @Config(value={"mantis.master.agent.fitness.cluster.weight"})
    @Default(value="0.2")
    public double getPreferredClusterFitnessWeight();

    @Config(value={"mantis.master.agent.fitness.durationtype.weight"})
    @Default(value="0.5")
    public double getDurationTypeFitnessWeight();

    @Config(value={"mantis.master.agent.fitness.binpacking.weight"})
    @Default(value="0.3")
    public double getBinPackingFitnessWeight();

    @Config(value={"mantis.master.agent.fitness.goodenough.threshold"})
    @Default(value="0.63")
    public double getFitnessGoodEnoughThreshold();

    @Config(value={"mantis.master.framework.name"})
    @Default(value="MantisFramework")
    public String getMantisFrameworkName();

    @Config(value={"mantis.master.framework.user"})
    @Default(value="")
    public String getMantisFrameworkUserName();

    @Config(value={"mantis.worker.executor.name"})
    @Default(value="Mantis Worker Executor")
    public String getWorkerExecutorName();

    @Config(value={"mantis.master.scheduler.iteration.interval.millis"})
    @Default(value="50")
    public long getSchedulerIterationIntervalMillis();

    @Config(value={"mantis.master.scheduler.disable.slave.duration.secs"})
    @Default(value="60")
    public long getDisableSlaveDurationSecs();

    @Config(value={"mantis.master.scheduler.retry-interval.millis"})
    @Default(value="60000")
    public int getSchedulerIntervalBetweenRetriesInMs();

    @Config(value={"mantis.master.scheduler.fitnessCalculator.class"})
    @Default(value="io.mantisrx.master.scheduler.CpuWeightedFitnessCalculator")
    public FitnessCalculator getFitnessCalculator();

    default public Duration getSchedulerIntervalBetweenRetries() {
        return Duration.ofMillis(this.getSchedulerIntervalBetweenRetriesInMs());
    }

    @Config(value={"mantis.master.scheduler.max-retries"})
    @Default(value="10")
    public int getSchedulerMaxRetries();

    @Config(value={"mantis.zookeeper.leader.election.path"})
    public String getLeaderElectionPath();

    @Config(value={"mantis.worker.heartbeat.intervalv2.secs"})
    @Default(value="20")
    public long getDefaultWorkerHeartbeatIntervalSecs();

    @Config(value={"mantis.worker.heartbeat.interval.secs"})
    @Default(value="60")
    public long getDefaultWorkerTimeoutSecs();

    @Config(value={"mantis.worker.heartbeat.interval.init.secs"})
    @Default(value="180")
    public long getWorkerInitTimeoutSecs();

    @Config(value={"mantis.worker.heartbeat.receipts.min.threshold.percent"})
    @Default(value="55")
    public double getHeartbeatReceiptsMinThresholdPercentage();

    @Config(value={"mantis.master.stage.assignment.refresh.interval.ms"})
    @Default(value="1000")
    public long getStageAssignmentRefreshIntervalMs();

    @Config(value={"mantis.worker.heartbeat.termination.enabled"})
    @Default(value="true")
    public boolean isHeartbeatTerminationEnabled();

    @Config(value={"mantis.worker.heartbeat.processing.enabled"})
    @Default(value="true")
    public boolean isHeartbeatProcessingEnabled();

    @Config(value={"mantis.interval.move.workers.disabled.vms.millis"})
    @Default(value="60000")
    public long getIntervalMoveWorkersOnDisabledVMsMillis();

    @Config(value={"mesos.lease.offer.expiry.secs"})
    @Default(value="300")
    public long getMesosLeaseOfferExpirySecs();

    @Config(value={"mantis.jobs.max.jars.per.named.job"})
    @Default(value="10")
    public int getMaximumNumberOfJarsPerJobName();

    @Config(value={"mantis.worker.resubmissions.maximum"})
    @Default(value="100")
    public int getMaximumResubmissionsPerWorker();

    @Config(value={"mantis.worker.resubmission.interval.secs"})
    @Default(value="5:10:20")
    public String getWorkerResubmitIntervalSecs();

    @Config(value={"mantis.worker.expire.resubmit.delay.secs"})
    @Default(value="300")
    public long getExpireWorkerResubmitDelaySecs();

    @Config(value={"mantis.worker.expire.resubmit.execution.interval.secs"})
    @Default(value="120")
    public long getExpireResubmitDelayExecutionIntervalSecs();

    @Config(value={"mantis.master.purge.frequency.secs"})
    @Default(value="1200")
    public long getCompletedJobPurgeFrequencySeqs();

    @Config(value={"mantis.master.purge.size"})
    @Default(value="50")
    public int getMaxJobsToPurge();

    @Config(value={"mantis.worker.state.launched.timeout.millis"})
    @Default(value="7000")
    public long getWorkerInLaunchedStateTimeoutMillis();

    @Config(value={"mantis.master.store.worker.writes.batch.size"})
    @Default(value="100")
    public int getWorkerWriteBatchSize();

    @Config(value={"mantis.master.ephemeral.job.unsubscribed.timeout.secs"})
    @Default(value="300")
    public long getEphemeralJobUnsubscribedTimeoutSecs();

    @Config(value={"mantis.master.init.timeout.secs"})
    @Default(value="240")
    public long getMasterInitTimeoutSecs();

    @Config(value={"mantis.master.terminated.job.to.delete.delay.hours"})
    @Default(value="360")
    public long getTerminatedJobToDeleteDelayHours();

    @Config(value={"mantis.master.max.archived.jobs.to.cache"})
    @Default(value="1000")
    public int getMaxArchivedJobsToCache();

    @Config(value={"mesos.slave.attribute.zone.name"})
    @Default(value="AWSZone")
    public String getHostZoneAttributeName();

    @Config(value={"mantis.agent.cluster.autoscale.by.attribute.name"})
    @Default(value="CLUSTER_NAME")
    public String getAutoscaleByAttributeName();

    @Config(value={"mantis.agent.cluster.autoscaler.map.hostname.attribute.name"})
    @Default(value="EC2_INSTANCE_ID")
    public String getAutoScalerMapHostnameAttributeName();

    @Config(value={"mantis.agent.cluster.autoscaler.shortfall.evaluation.disabled"})
    @Default(value="false")
    public boolean getDisableShortfallEvaluation();

    @Config(value={"mantis.scheduling.info.observable.heartbeat.interval.secs"})
    @Default(value="120")
    public long getSchedulingInfoObservableHeartbeatIntervalSecs();

    @Config(value={"mantis.job.master.scheduling.info.cores"})
    @Default(value="2.0")
    public double getJobMasterCores();

    @Config(value={"mantis.job.master.scheduling.info.memoryMB"})
    @Default(value="4096.0")
    public double getJobMasterMemoryMB();

    @Config(value={"mantis.job.master.scheduling.info.networkMbps"})
    @Default(value="128.0")
    public double getJobMasterNetworkMbps();

    @Config(value={"mantis.job.master.scheduling.info.diskMB"})
    @Default(value="100.0")
    public double getJobMasterDiskMB();

    @Config(value={"mantis.master.api.cache.ttl.milliseconds"})
    @Default(value="250")
    public int getApiCacheTtlMilliseconds();

    @Config(value={"mantis.master.api.cache.size.max"})
    @Default(value="50")
    public int getApiCacheMaxSize();

    @Config(value={"mantis.master.api.cache.size.min"})
    @Default(value="5")
    public int getApiCacheMinSize();

    @Config(value={"mantis.agent.heartbeat.interval.ms"})
    @Default(value="300000")
    public int getHeartbeatIntervalInMs();

    @Config(value={"mantis.job.master.resource.cluster.scaler.interval.secs"})
    @Default(value="60")
    public int getScalerTriggerThresholdInSecs();

    @Config(value={"mantis.job.master.resource.cluster.scaler.ruleset.refresh.secs"})
    @Default(value="180")
    public int getScalerRuleSetRefreshThresholdInSecs();

    @Config(value={"mantis.agent.assignment.interval.ms"})
    @Default(value="60000")
    public int getAssignmentIntervalInMs();

    @Config(value={"mantis.job.costsCalculator.class"})
    @Default(value="io.mantisrx.master.jobcluster.job.NoopCostsCalculator")
    public CostsCalculator getJobCostsCalculator();

    @Config(value={"mantis.job.worker.max.artifacts.to.cache"})
    @Default(value="5")
    public int getMaxJobArtifactsToCache();

    @Config(value={"mantis.artifactCaching.jobClusters"})
    @Default(value="")
    public String getJobClustersWithArtifactCachingEnabled();

    @Config(value={"mantis.artifactCaching.enabled"})
    @Default(value="true")
    public boolean isJobArtifactCachingEnabled();

    @Config(value={"mantis.master.resource.cluster.actions.permitsPerSecond"})
    @Default(value="5000")
    public int getResourceClusterActionsPermitsPerSecond();

    @Config(value={"mantis.scheduler.enable-batch"})
    @Default(value="false")
    public boolean isBatchSchedulingEnabled();

    @Config(value={"mantis.scheduler.schedulingConstraints"})
    @Default(value="")
    public String getSchedulingConstraintsString();

    default public Duration getHeartbeatInterval() {
        return Duration.ofMillis(this.getHeartbeatIntervalInMs());
    }

    default public Duration getMaxAssignmentThreshold() {
        return Duration.ofMillis(this.getAssignmentIntervalInMs());
    }

    default public Map<String, String> getSchedulingConstraints() {
        return this.getSchedulingConstraintsString().isEmpty() ? ImmutableMap.of() : Splitter.on((String)",").withKeyValueSeparator(':').split((CharSequence)this.getSchedulingConstraintsString());
    }
}

