/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.domain;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class JobId
implements Comparable<JobId> {
    private static final String DELIMITER = "-";
    private final String cluster;
    private final long jobNum;
    private final String id;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public JobId(@JsonProperty(value="clusterName") String clusterName, @JsonProperty(value="jobNum") long jobNum) {
        this.cluster = clusterName;
        this.jobNum = jobNum;
        this.id = clusterName + DELIMITER + jobNum;
    }

    public static Optional<JobId> fromId(String id) {
        int i = id.lastIndexOf(DELIMITER);
        if (i < 0) {
            return Optional.empty();
        }
        String jobCluster = id.substring(0, i);
        try {
            int jobNum = Integer.parseInt(id.substring(i + 1));
            return Optional.ofNullable(new JobId(jobCluster, jobNum));
        }
        catch (NumberFormatException nfe) {
            return Optional.empty();
        }
    }

    public String getCluster() {
        return this.cluster;
    }

    public long getJobNum() {
        return this.jobNum;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cluster == null ? 0 : this.cluster.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (int)(this.jobNum ^ this.jobNum >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobId other = (JobId)obj;
        if (this.cluster == null ? other.cluster != null : !this.cluster.equals(other.cluster)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.jobNum == other.jobNum;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public int compareTo(JobId o) {
        return this.id.compareTo(o.getId());
    }
}

