/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.persistence;

import io.mantisrx.master.events.LifecycleEventPublisher;
import io.mantisrx.master.events.LifecycleEventsProto;
import io.mantisrx.master.jobcluster.IJobClusterMetadata;
import io.mantisrx.master.jobcluster.job.IMantisJobMetadata;
import io.mantisrx.server.master.persistence.KeyValueBasedPersistenceProvider;
import io.mantisrx.server.master.store.FileBasedStore;
import io.mantisrx.server.master.store.KeyValueStore;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedPersistenceProvider
extends KeyValueBasedPersistenceProvider {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedPersistenceProvider.class);
    private static final LifecycleEventPublisher noopEventPublisher = new LifecycleEventPublisher(){

        @Override
        public void publishAuditEvent(LifecycleEventsProto.AuditEvent auditEvent) {
        }

        @Override
        public void publishStatusEvent(LifecycleEventsProto.StatusEvent statusEvent) {
        }

        @Override
        public void publishWorkerListChangedEvent(LifecycleEventsProto.WorkerListChangedEvent workerListChangedEvent) {
        }
    };

    public FileBasedPersistenceProvider(boolean actualStorageProvider) {
        this(actualStorageProvider ? new FileBasedStore() : KeyValueStore.NO_OP, noopEventPublisher);
    }

    public FileBasedPersistenceProvider(KeyValueStore sprovider, LifecycleEventPublisher publisher) {
        super(sprovider, publisher);
    }

    public FileBasedPersistenceProvider(FileBasedStore sprovider) {
        this(sprovider, noopEventPublisher);
    }

    public FileBasedPersistenceProvider(File stateDirectory, boolean eventPublisher) {
        this(new FileBasedStore(stateDirectory), noopEventPublisher);
    }

    Optional<IJobClusterMetadata> loadJobCluster(String clusterName) throws IOException {
        return this.loadAllJobClusters().stream().filter(jc -> clusterName.equals(jc.getJobClusterDefinition().getName())).findFirst();
    }

    Optional<IMantisJobMetadata> loadActiveJob(String jobId) throws IOException {
        return this.loadAllJobs().stream().filter(job -> jobId.equals(job.getJobId().getId())).findFirst();
    }
}

