/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.scheduler;

import akka.actor.ActorSystem;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.server.master.ExecuteStageRequestFactory;
import io.mantisrx.server.master.config.MasterConfiguration;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ResourceClusters;
import io.mantisrx.server.master.scheduler.JobMessageRouter;
import io.mantisrx.server.master.scheduler.MantisScheduler;
import io.mantisrx.server.master.scheduler.MantisSchedulerFactory;
import io.mantisrx.server.master.scheduler.ResourceClusterAwareScheduler;
import io.mantisrx.server.master.scheduler.ResourceClusterAwareSchedulerActor;
import io.mantisrx.shaded.com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisSchedulerFactoryImpl
implements MantisSchedulerFactory {
    private static final Logger log = LoggerFactory.getLogger(MantisSchedulerFactoryImpl.class);
    private final ActorSystem actorSystem;
    private final ResourceClusters resourceClusters;
    private final ExecuteStageRequestFactory executeStageRequestFactory;
    private final JobMessageRouter jobMessageRouter;
    private final MasterConfiguration masterConfiguration;
    private final MetricsRegistry metricsRegistry;
    private final Map<ClusterID, MantisScheduler> actorRefMap = new ConcurrentHashMap<ClusterID, MantisScheduler>();

    @Override
    public MantisScheduler forClusterID(ClusterID clusterID) {
        if (clusterID != null) {
            if (Strings.isNullOrEmpty((String)clusterID.getResourceID())) {
                log.error("Received empty resource id: {}", (Object)clusterID);
                throw new RuntimeException("Empty resourceID in clusterID for MantisScheduler");
            }
            return this.actorRefMap.computeIfAbsent(clusterID, cid -> {
                log.info("Created scheduler actor for cluster: {}", (Object)clusterID.getResourceID());
                return new ResourceClusterAwareScheduler(this.actorSystem.actorOf(ResourceClusterAwareSchedulerActor.props(this.masterConfiguration.getSchedulerMaxRetries(), this.masterConfiguration.getSchedulerMaxRetries(), this.masterConfiguration.getSchedulerIntervalBetweenRetries(), this.resourceClusters.getClusterFor(cid), this.executeStageRequestFactory, this.jobMessageRouter, this.metricsRegistry), "scheduler-for-" + cid.getResourceID()));
            });
        }
        log.error("Scheduler gets unexpected null clusterID");
        throw new RuntimeException("invalid null clusterID.");
    }

    @ConstructorProperties(value={"actorSystem", "resourceClusters", "executeStageRequestFactory", "jobMessageRouter", "masterConfiguration", "metricsRegistry"})
    public MantisSchedulerFactoryImpl(ActorSystem actorSystem, ResourceClusters resourceClusters, ExecuteStageRequestFactory executeStageRequestFactory, JobMessageRouter jobMessageRouter, MasterConfiguration masterConfiguration, MetricsRegistry metricsRegistry) {
        this.actorSystem = actorSystem;
        this.resourceClusters = resourceClusters;
        this.executeStageRequestFactory = executeStageRequestFactory;
        this.jobMessageRouter = jobMessageRouter;
        this.masterConfiguration = masterConfiguration;
        this.metricsRegistry = metricsRegistry;
    }
}

