/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.store;

import io.mantisrx.server.master.store.KeyValueStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedStore
implements KeyValueStore {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedStore.class);
    private final File rootDir;
    private final ReentrantLock fileLock = new ReentrantLock();

    public FileBasedStore() {
        this(new File("/tmp/mantis_storage"));
    }

    public FileBasedStore(File rootDir) {
        this.rootDir = rootDir;
        Path rootDirPath = Paths.get(rootDir.getPath(), new String[0]);
        try {
            if (Files.notExists(rootDirPath, new LinkOption[0])) {
                Files.createDirectories(rootDirPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path makePath(String dir, String fileName) throws IOException {
        Files.createDirectories(Paths.get(this.rootDir.getPath(), dir), new FileAttribute[0]);
        return Paths.get(this.rootDir.getPath(), dir, fileName);
    }

    public void reset() {
        try {
            FileUtils.deleteDirectory((File)Paths.get(this.rootDir.getPath(), new String[0]).toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Map<String, String>> getAllRows(String tableName) throws IOException {
        return this.getAllPartitionKeys(tableName).stream().map(partitionKey -> {
            try {
                return Pair.of((Object)partitionKey, this.getAll(tableName, (String)partitionKey));
            }
            catch (Exception e) {
                logger.warn("failed to read file for partitionKey {} because", partitionKey, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    @Override
    public List<String> getAllPartitionKeys(String tableName) throws IOException {
        Path tableRoot = Paths.get(this.rootDir.getPath(), tableName);
        if (Files.notExists(tableRoot, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (Stream<Path> paths = Files.list(tableRoot);){
            List<String> list = paths.map(x -> x.getFileName().toString()).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public String get(String tableName, String partitionKey, String secondaryKey) throws IOException {
        return this.getAll(tableName, partitionKey).get(secondaryKey);
    }

    @Override
    public Map<String, String> getAll(String tableName, String partitionKey) throws IOException {
        Path filePath = this.makePath(tableName, partitionKey);
        if (Files.notExists(filePath, new LinkOption[0])) {
            return new HashMap<String, String>();
        }
        return Files.readAllLines(filePath).stream().map(line -> line.split(",", 2)).collect(Collectors.toMap(tokens -> tokens[0], tokens -> tokens[1]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upsert(String tableName, String partitionKey, String secondaryKey, String data) throws IOException {
        this.fileLock.lock();
        try {
            Map<String, String> items = this.getAll(tableName, partitionKey);
            items.put(secondaryKey, data);
            this.upsertAll(tableName, partitionKey, items);
            boolean bl = true;
            return bl;
        }
        finally {
            this.fileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upsertAll(String tableName, String partitionKey, Map<String, String> all, Duration ttl) throws IOException {
        Path filePath = this.makePath(tableName, partitionKey);
        List lines = all.entrySet().stream().map(e -> (String)e.getKey() + "," + (String)e.getValue()).collect(Collectors.toList());
        this.fileLock.lock();
        try {
            Files.write(filePath, lines, new OpenOption[0]);
            boolean bl = true;
            return bl;
        }
        finally {
            this.fileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String tableName, String partitionKey, String secondaryKey) throws IOException {
        this.fileLock.lock();
        try {
            Map<String, String> items = this.getAll(tableName, partitionKey);
            items.remove(secondaryKey);
            this.upsertAll(tableName, partitionKey, items);
            boolean bl = true;
            return bl;
        }
        finally {
            this.fileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteAll(String tableName, String partitionKey) throws IOException {
        Path filePath = this.makePath(tableName, partitionKey);
        this.fileLock.lock();
        try {
            boolean bl = filePath.toFile().delete();
            return bl;
        }
        finally {
            this.fileLock.unlock();
        }
    }
}

