/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.store;

import io.mantisrx.common.Label;
import io.mantisrx.runtime.JobSla;
import io.mantisrx.runtime.MantisJobState;
import io.mantisrx.runtime.WorkerMigrationConfig;
import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.server.master.store.InvalidJobException;
import io.mantisrx.server.master.store.InvalidJobStateChangeException;
import io.mantisrx.server.master.store.MantisJobMetadata;
import io.mantisrx.server.master.store.MantisStageMetadata;
import io.mantisrx.server.master.store.MantisStageMetadataWritable;
import io.mantisrx.server.master.store.MantisWorkerMetadata;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisJobMetadataWritable
implements MantisJobMetadata {
    private static final Logger logger = LoggerFactory.getLogger(MantisJobMetadataWritable.class);
    private final String user;
    private final JobSla sla;
    private final long subscriptionTimeoutSecs;
    private final List<Label> labels;
    @JsonIgnore
    private final ConcurrentMap<Integer, MantisStageMetadataWritable> stageMetadataMap;
    @JsonIgnore
    private final ConcurrentMap<Integer, Integer> workerNumberToStageMap;
    @JsonIgnore
    private final ReentrantLock lock = new ReentrantLock();
    private String jobId;
    private String name;
    private long submittedAt;
    private long startedAt = 0L;
    private URL jarUrl;
    private volatile MantisJobState state;
    private final int numStages;
    private final List<Parameter> parameters;
    private int nextWorkerNumberToUse = 1;
    private final WorkerMigrationConfig migrationConfig;
    @JsonIgnore
    private Object sink;
    private final long heartbeatIntervalSecs;
    private final long workerTimeoutSecs;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public MantisJobMetadataWritable(@JsonProperty(value="jobId") String jobId, @JsonProperty(value="name") String name, @JsonProperty(value="user") String user, @JsonProperty(value="submittedAt") long submittedAt, @JsonProperty(value="startedAt") long startedAt, @JsonProperty(value="jarUrl") URL jarUrl, @JsonProperty(value="numStages") int numStages, @JsonProperty(value="sla") JobSla sla, @JsonProperty(value="state") MantisJobState state, @JsonProperty(value="workerTimeoutSecs") long workerTimeoutSecs, @JsonProperty(value="heartbeatIntervalSecs") long heartbeatIntervalSecs, @JsonProperty(value="subscriptionTimeoutSecs") long subscriptionTimeoutSecs, @JsonProperty(value="parameters") List<Parameter> parameters, @JsonProperty(value="nextWorkerNumberToUse") int nextWorkerNumberToUse, @JsonProperty(value="migrationConfig") WorkerMigrationConfig migrationConfig, @JsonProperty(value="labels") List<Label> labels) {
        this.jobId = jobId;
        this.name = name;
        this.user = user;
        this.submittedAt = submittedAt;
        this.startedAt = startedAt;
        this.jarUrl = jarUrl;
        this.numStages = numStages;
        this.sla = sla;
        this.state = state == null ? MantisJobState.Accepted : state;
        this.subscriptionTimeoutSecs = subscriptionTimeoutSecs;
        this.heartbeatIntervalSecs = heartbeatIntervalSecs;
        this.workerTimeoutSecs = workerTimeoutSecs;
        this.stageMetadataMap = new ConcurrentHashMap<Integer, MantisStageMetadataWritable>();
        this.workerNumberToStageMap = new ConcurrentHashMap<Integer, Integer>();
        this.parameters = parameters == null ? new LinkedList<Parameter>() : parameters;
        this.labels = labels == null ? new LinkedList<Label>() : labels;
        this.nextWorkerNumberToUse = nextWorkerNumberToUse;
        this.migrationConfig = Optional.ofNullable(migrationConfig).orElse(WorkerMigrationConfig.DEFAULT);
    }

    @Override
    public AutoCloseable obtainLock() {
        this.lock.lock();
        return new AutoCloseable(){

            @Override
            public void close() throws IllegalMonitorStateException {
                MantisJobMetadataWritable.this.lock.unlock();
            }
        };
    }

    public void setNextWorkerNumberToUse(int n) {
        this.nextWorkerNumberToUse = n;
    }

    void setJobState(MantisJobState state) throws InvalidJobStateChangeException {
        if (!this.state.isValidStateChgTo(state)) {
            throw new InvalidJobStateChangeException(this.jobId, this.state, state);
        }
        this.state = state;
    }

    @Override
    @JsonIgnore
    public Collection<? extends MantisStageMetadata> getStageMetadata() {
        return this.stageMetadataMap.values();
    }

    @Override
    @JsonIgnore
    public MantisStageMetadata getStageMetadata(int stageNum) {
        return (MantisStageMetadata)this.stageMetadataMap.get(stageNum);
    }

    public boolean addJobStageIfAbsent(MantisStageMetadataWritable msmd) {
        return this.stageMetadataMap.putIfAbsent(msmd.getStageNum(), msmd) == null;
    }

    public MantisWorkerMetadata tryAddOrReplaceWorker(int stageNum, MantisWorkerMetadata workerMetadata) {
        boolean result = ((MantisStageMetadataWritable)this.stageMetadataMap.get(stageNum)).replaceWorkerIndex(workerMetadata);
        if (result) {
            Integer integer = this.workerNumberToStageMap.put(workerMetadata.getWorkerNumber(), stageNum);
            if (integer != null && integer != stageNum) {
                logger.error(String.format("Unexpected to put worker number mapping from %d to stage %d for job %s, prev mapping to stage %d", workerMetadata.getWorkerNumber(), stageNum, workerMetadata.getJobId(), integer));
            }
            return null;
        }
        try {
            return ((MantisStageMetadataWritable)this.stageMetadataMap.get(stageNum)).getWorkerByIndex(workerMetadata.getWorkerIndex());
        }
        catch (InvalidJobException e) {
            logger.error("Failed to fetch existing worker when new worker got rejected: {}", (Object)workerMetadata, (Object)e);
            throw new RuntimeException("Failed to fetch existing worker when new worker got rejected", e);
        }
    }

    @Override
    @JsonIgnore
    public MantisWorkerMetadata getWorkerByIndex(int stageNumber, int workerIndex) throws InvalidJobException {
        MantisStageMetadata stage = (MantisStageMetadata)this.stageMetadataMap.get(stageNumber);
        if (stage == null) {
            throw new InvalidJobException(this.jobId, stageNumber, workerIndex);
        }
        return stage.getWorkerByIndex(workerIndex);
    }

    @Override
    @JsonIgnore
    public MantisWorkerMetadata getWorkerByNumber(int workerNumber) throws InvalidJobException {
        Integer stageNumber = (Integer)this.workerNumberToStageMap.get(workerNumber);
        if (stageNumber == null) {
            throw new InvalidJobException(this.jobId, -1, workerNumber);
        }
        MantisStageMetadata stage = (MantisStageMetadata)this.stageMetadataMap.get(stageNumber);
        if (stage == null) {
            throw new InvalidJobException(this.jobId, stageNumber, workerNumber);
        }
        return stage.getWorkerByWorkerNumber(workerNumber);
    }

    @JsonIgnore
    public int getMaxWorkerNumber() {
        int max = -1;
        Iterator iterator = this.workerNumberToStageMap.keySet().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            if (max >= id) continue;
            max = id;
        }
        return max;
    }

    public String toString() {
        return "MantisJobMetadataWritable{user='" + this.user + '\'' + ", sla=" + this.sla + ", subscriptionTimeoutSecs=" + this.subscriptionTimeoutSecs + ", labels=" + this.labels + ", stageMetadataMap=" + this.stageMetadataMap + ", workerNumberToStageMap=" + this.workerNumberToStageMap + ", jobId='" + this.jobId + '\'' + ", name='" + this.name + '\'' + ", submittedAt=" + this.submittedAt + ", startedAt=" + this.startedAt + ", jarUrl=" + this.jarUrl + ", state=" + this.state + ", numStages=" + this.numStages + ", parameters=" + this.parameters + ", nextWorkerNumberToUse=" + this.nextWorkerNumberToUse + ", migrationConfig=" + this.migrationConfig + '}';
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public JobSla getSla() {
        return this.sla;
    }

    @Override
    public long getSubscriptionTimeoutSecs() {
        return this.subscriptionTimeoutSecs;
    }

    @Override
    public List<Label> getLabels() {
        return this.labels;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSubmittedAt() {
        return this.submittedAt;
    }

    @Override
    public long getStartedAt() {
        return this.startedAt;
    }

    @Override
    public URL getJarUrl() {
        return this.jarUrl;
    }

    @Override
    public MantisJobState getState() {
        return this.state;
    }

    @Override
    public int getNumStages() {
        return this.numStages;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public int getNextWorkerNumberToUse() {
        return this.nextWorkerNumberToUse;
    }

    @Override
    public WorkerMigrationConfig getMigrationConfig() {
        return this.migrationConfig;
    }

    @Override
    public long getHeartbeatIntervalSecs() {
        return this.heartbeatIntervalSecs;
    }

    @Override
    public long getWorkerTimeoutSecs() {
        return this.workerTimeoutSecs;
    }
}

