/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.netty.guice;

import com.google.inject.AbstractModule;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.ipc.http.HttpClient;
import io.mantisrx.publish.DefaultSubscriptionTracker;
import io.mantisrx.publish.EventChannel;
import io.mantisrx.publish.EventTransmitter;
import io.mantisrx.publish.MrePublishClientInitializer;
import io.mantisrx.publish.StreamManager;
import io.mantisrx.publish.SubscriptionTracker;
import io.mantisrx.publish.Tee;
import io.mantisrx.publish.api.EventPublisher;
import io.mantisrx.publish.config.MrePublishConfiguration;
import io.mantisrx.publish.config.SampleArchaiusMrePublishConfiguration;
import io.mantisrx.publish.internal.discovery.MantisJobDiscovery;
import io.mantisrx.publish.netty.pipeline.HttpEventChannel;
import io.mantisrx.publish.netty.pipeline.HttpEventChannelManager;
import io.mantisrx.publish.netty.transmitters.ChoiceOfTwoEventTransmitter;
import io.mantisrx.publish.providers.EventPublisherProvider;
import io.mantisrx.publish.providers.MantisJobDiscoveryProvider;
import io.mantisrx.publish.providers.MrePublishClientInitializerProvider;
import io.mantisrx.publish.providers.StreamManagerProvider;
import io.mantisrx.publish.providers.TeeProvider;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

public class MantisRealtimeEventsPublishModule
extends AbstractModule {
    protected void configure() {
        this.bind(MrePublishConfiguration.class).toProvider(MrePublishConfigProvider.class).asEagerSingleton();
        this.bind(StreamManager.class).toProvider(StreamManagerProvider.class).asEagerSingleton();
        this.bind(EventPublisher.class).toProvider(EventPublisherProvider.class).asEagerSingleton();
        this.bind(MantisJobDiscovery.class).toProvider(MantisJobDiscoveryProvider.class).asEagerSingleton();
        this.bind(EventTransmitter.class).toProvider(EventTransmitterProvider.class).asEagerSingleton();
        this.bind(Tee.class).toProvider(TeeProvider.class).asEagerSingleton();
        this.bind(SubscriptionTracker.class).toProvider(SubscriptionTrackerProvider.class).asEagerSingleton();
        this.bind(MrePublishClientInitializer.class).toProvider(MrePublishClientInitializerProvider.class).asEagerSingleton();
    }

    @Singleton
    private static class MrePublishConfigProvider
    implements Provider<MrePublishConfiguration> {
        private final PropertyRepository propertyRepository;

        @Inject
        public MrePublishConfigProvider(PropertyRepository propertyRepository) {
            this.propertyRepository = propertyRepository;
        }

        public MrePublishConfiguration get() {
            return new SampleArchaiusMrePublishConfiguration(this.propertyRepository);
        }
    }

    @Singleton
    private static class SubscriptionTrackerProvider
    implements Provider<SubscriptionTracker> {
        private final MrePublishConfiguration configuration;
        private final Registry registry;
        private final StreamManager streamManager;
        private final MantisJobDiscovery jobDiscovery;

        @Inject
        public SubscriptionTrackerProvider(MrePublishConfiguration configuration, Registry registry, StreamManager streamManager, MantisJobDiscovery jobDiscovery) {
            this.configuration = configuration;
            this.registry = registry;
            this.streamManager = streamManager;
            this.jobDiscovery = jobDiscovery;
        }

        public SubscriptionTracker get() {
            return new DefaultSubscriptionTracker(this.configuration, this.registry, this.jobDiscovery, this.streamManager, HttpClient.create((Registry)this.registry));
        }
    }

    @Singleton
    private static class EventTransmitterProvider
    implements Provider<EventTransmitter> {
        private final MrePublishConfiguration configuration;
        private final Registry registry;
        private final MantisJobDiscovery jobDiscovery;

        @Inject
        public EventTransmitterProvider(MrePublishConfiguration configuration, Registry registry, MantisJobDiscovery jobDiscovery) {
            this.configuration = configuration;
            this.registry = registry;
            this.jobDiscovery = jobDiscovery;
        }

        public EventTransmitter get() {
            HttpEventChannelManager channelManager = new HttpEventChannelManager(this.registry, this.configuration);
            HttpEventChannel eventChannel = new HttpEventChannel(this.registry, channelManager);
            return new ChoiceOfTwoEventTransmitter(this.configuration, this.registry, this.jobDiscovery, (EventChannel)eventChannel);
        }
    }
}

