/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.netty.pipeline;

import com.netflix.spectator.api.Registry;
import io.mantisrx.publish.config.MrePublishConfiguration;
import io.mantisrx.publish.netty.pipeline.GzipEncoder;
import io.mantisrx.publish.netty.pipeline.HttpEventChannel;
import io.mantisrx.publish.netty.pipeline.HttpEventChannelHandler;
import io.mantisrx.publish.netty.pipeline.MantisEventAggregator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpEventChannelInitializer
extends ChannelInitializer<Channel> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpEventChannel.class);
    private final Registry registry;
    private final boolean gzipEnabled;
    private final long flushIntervalMs;
    private final int flushIntervalBytes;
    private final int idleTimeoutSeconds;
    private final int httpChunkSize;
    private final int writeTimeoutSeconds;
    private final EventLoopGroup encoderEventLoopGroup;

    HttpEventChannelInitializer(Registry registry, MrePublishConfiguration config, EventLoopGroup encoderEventLoopGroup) {
        this.registry = registry;
        this.gzipEnabled = config.getGzipEnabled();
        this.idleTimeoutSeconds = config.getIdleTimeoutSeconds();
        this.httpChunkSize = config.getHttpChunkSize();
        this.writeTimeoutSeconds = config.getWriteTimeoutSeconds();
        this.flushIntervalMs = config.getFlushIntervalMs();
        this.flushIntervalBytes = config.getFlushIntervalBytes();
        this.encoderEventLoopGroup = encoderEventLoopGroup;
    }

    protected void initChannel(Channel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new LoggingHandler()});
        pipeline.addLast("http-client-codec", (ChannelHandler)new HttpClientCodec());
        if (this.gzipEnabled) {
            pipeline.addLast((EventExecutorGroup)this.encoderEventLoopGroup, "gzip-encoder", (ChannelHandler)new GzipEncoder(this.registry));
        }
        pipeline.addLast("http-object-aggregator", (ChannelHandler)new HttpObjectAggregator(this.httpChunkSize));
        pipeline.addLast("write-timeout-handler", (ChannelHandler)new WriteTimeoutHandler(this.writeTimeoutSeconds));
        pipeline.addLast("mantis-event-aggregator", (ChannelHandler)new MantisEventAggregator(this.registry, Clock.systemUTC(), this.gzipEnabled, this.flushIntervalMs, this.flushIntervalBytes));
        pipeline.addLast("idle-channel-handler", (ChannelHandler)new IdleStateHandler(0, this.idleTimeoutSeconds, 0));
        pipeline.addLast("event-channel-handler", (ChannelHandler)new HttpEventChannelHandler(this.registry));
        LOG.debug("initializing channel with pipeline: {}", (Object)pipeline.toMap());
    }
}

