/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.netty.transmitters;

import com.netflix.mantis.discovery.proto.JobDiscoveryInfo;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import io.mantisrx.publish.EventChannel;
import io.mantisrx.publish.EventTransmitter;
import io.mantisrx.publish.api.Event;
import io.mantisrx.publish.config.MrePublishConfiguration;
import io.mantisrx.publish.internal.discovery.MantisJobDiscovery;
import io.mantisrx.publish.internal.exceptions.NonRetryableException;
import io.mantisrx.publish.internal.metrics.SpectatorUtils;
import io.mantisrx.publish.netty.transmitters.ChoiceOfTwoWorkerPool;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChoiceOfTwoEventTransmitter
implements EventTransmitter {
    private static final Logger LOG = LoggerFactory.getLogger(ChoiceOfTwoEventTransmitter.class);
    private final Registry registry;
    private final Timer channelSendTime;
    private final MantisJobDiscovery jobDiscovery;
    private final EventChannel eventChannel;
    private final ChoiceOfTwoWorkerPool workerPool;
    private final Counter noWorkersDroppedCount;
    private final Counter noDiscoveryDroppedCount;

    public ChoiceOfTwoEventTransmitter(MrePublishConfiguration config, Registry registry, MantisJobDiscovery jobDiscovery, EventChannel eventChannel) {
        this.registry = registry;
        this.channelSendTime = SpectatorUtils.buildAndRegisterTimer((Registry)registry, (String)"sendTime", (String[])new String[]{"channel", "netty"});
        this.noWorkersDroppedCount = SpectatorUtils.buildAndRegisterCounter((Registry)registry, (String)"mantisEventsDropped", (String[])new String[]{"reason", "transmitterNoWorkers"});
        this.noDiscoveryDroppedCount = SpectatorUtils.buildAndRegisterCounter((Registry)registry, (String)"mantisEventsDropped", (String[])new String[]{"reason", "transmitterNoDiscoveryInfo"});
        this.jobDiscovery = jobDiscovery;
        this.eventChannel = eventChannel;
        this.workerPool = new ChoiceOfTwoWorkerPool(config, registry, this.eventChannel);
    }

    public void send(Event event, String jobCluster) {
        Optional jobDiscoveryInfo = this.jobDiscovery.getCurrentJobWorkers(jobCluster);
        if (jobDiscoveryInfo.isPresent()) {
            List workers = ((JobDiscoveryInfo)jobDiscoveryInfo.get()).getIngestStageWorkers().getWorkers();
            int numWorkers = workers.size();
            if (numWorkers > 0) {
                this.workerPool.refresh(workers);
                long start = this.registry.clock().wallTime();
                try {
                    this.workerPool.record(event, (arg_0, arg_1) -> ((EventChannel)this.eventChannel).send(arg_0, arg_1));
                }
                catch (NonRetryableException e) {
                    LOG.trace("No workers for job cluster {}, dropping event", (Object)jobCluster);
                    this.noWorkersDroppedCount.increment();
                }
                long end = this.registry.clock().wallTime();
                this.channelSendTime.record(end - start, TimeUnit.MILLISECONDS);
            } else {
                LOG.trace("No workers for job cluster {}, dropping event", (Object)jobCluster);
                this.noWorkersDroppedCount.increment();
            }
        } else {
            LOG.trace("No job discovery info for job cluster {}, dropping event", (Object)jobCluster);
            this.noDiscoveryDroppedCount.increment();
        }
    }
}

