/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.AbstractProperty;
import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyFactory;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.archaius.api.annotations.Configuration;
import com.netflix.archaius.api.annotations.DefaultValue;
import com.netflix.archaius.api.annotations.PropertyName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProxyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigProxyFactory.class);
    private final Decoder decoder;
    private final PropertyRepository propertyRepository;
    private final Config config;
    private static Map<Type, Supplier<?>> knownCollections = new HashMap();

    @Inject
    public ConfigProxyFactory(Config config, Decoder decoder, PropertyFactory factory) {
        this.decoder = decoder;
        this.config = config;
        this.propertyRepository = factory;
    }

    @Deprecated
    public ConfigProxyFactory(Config config, PropertyFactory factory) {
        this.decoder = config.getDecoder();
        this.config = config;
        this.propertyRepository = factory;
    }

    @Deprecated
    public ConfigProxyFactory(Config config) {
        this.decoder = config.getDecoder();
        this.config = config;
        this.propertyRepository = DefaultPropertyFactory.from(config);
    }

    public <T> T newProxy(Class<T> type2) {
        return this.newProxy(type2, null);
    }

    private String derivePrefix(Configuration annot, String prefix) {
        if (prefix == null && annot != null && (prefix = annot.prefix()) == null) {
            prefix = "";
        }
        if (prefix == null) {
            return "";
        }
        if (prefix.endsWith(".") || prefix.isEmpty()) {
            return prefix;
        }
        return prefix + ".";
    }

    public <T> T newProxy(Class<T> type2, String initialPrefix) {
        Configuration annot = type2.getAnnotation(Configuration.class);
        return this.newProxy(type2, initialPrefix, annot == null ? false : annot.immutable());
    }

    <T> T newProxy(Class<T> type2, String initialPrefix, boolean immutable) {
        Configuration annot = type2.getAnnotation(Configuration.class);
        String prefix = this.derivePrefix(annot, initialPrefix);
        HashMap<Method, MethodInvoker<Object>> invokers = new HashMap<Method, MethodInvoker<Object>>();
        HashMap<Method, String> propertyNames = new HashMap<Method, String>();
        InvocationHandler handler = (proxy2, method, args) -> {
            MethodInvoker invoker = (MethodInvoker)invokers.get(method);
            if (invoker != null) {
                return invoker.invoke(args);
            }
            if ("equals".equals(method.getName())) {
                return proxy2 == args[0];
            }
            if ("hashCode".equals(method.getName())) {
                return System.identityHashCode(proxy2);
            }
            if ("toString".equals(method.getName())) {
                StringBuilder sb = new StringBuilder();
                sb.append(type2.getSimpleName()).append("[");
                sb.append(invokers.entrySet().stream().map(entry -> {
                    StringBuilder sbProperty = new StringBuilder();
                    sbProperty.append(((String)propertyNames.get(entry.getKey())).substring(prefix.length())).append("='");
                    try {
                        sbProperty.append(((MethodInvoker)entry.getValue()).invoke(null));
                    }
                    catch (Exception e2) {
                        sbProperty.append(e2.getMessage());
                    }
                    sbProperty.append("'");
                    return sbProperty.toString();
                }).collect(Collectors.joining(",")));
                sb.append("]");
                return sb.toString();
            }
            throw new NoSuchMethodError(method.getName() + " not found on interface " + type2.getName());
        };
        Object proxyObject = Proxy.newProxyInstance(type2.getClassLoader(), new Class[]{type2}, handler);
        for (Method m : type2.getMethods()) {
            try {
                MethodInvoker<Object> invoker;
                PropertyName nameAnnot;
                String verb = m.getName().startsWith("get") ? "get" : (m.getName().startsWith("is") ? "is" : "");
                Class<?> returnType = m.getReturnType();
                Supplier<Object> defaultSupplier = knownCollections.getOrDefault(returnType, () -> null);
                if (m.getAnnotation(DefaultValue.class) != null) {
                    if (m.isDefault()) {
                        throw new IllegalArgumentException("@DefaultValue cannot be defined on a method with a default implementation for method " + m.getDeclaringClass().getName() + "#" + m.getName());
                    }
                    if (Map.class.isAssignableFrom(returnType) || List.class.isAssignableFrom(returnType) || Set.class.isAssignableFrom(returnType)) {
                        throw new IllegalArgumentException("@DefaultValue cannot be used with collections.  Use default method implemenation instead " + m.getDeclaringClass().getName() + "#" + m.getName());
                    }
                    String value = m.getAnnotation(DefaultValue.class).value();
                    defaultSupplier = returnType == String.class ? ConfigProxyFactory.memoize(this.config.resolve(value)) : ConfigProxyFactory.memoize(this.decoder.decode(returnType, this.config.resolve(value)));
                }
                if (m.isDefault()) {
                    defaultSupplier = ConfigProxyFactory.createDefaultMethodSupplier(m, type2, proxyObject);
                }
                String propName = (nameAnnot = m.getAnnotation(PropertyName.class)) != null && nameAnnot.name() != null ? prefix + nameAnnot.name() : prefix + Character.toLowerCase(m.getName().charAt(verb.length())) + m.getName().substring(verb.length() + 1);
                propertyNames.put(m, propName);
                if (!knownCollections.containsKey(returnType) && returnType.isInterface()) {
                    invoker = this.createInterfaceProperty(propName, this.newProxy(returnType, propName, immutable));
                } else if (m.getParameterTypes() != null && m.getParameterTypes().length > 0) {
                    if (nameAnnot == null) {
                        throw new IllegalArgumentException("Missing @PropertyName annotation on " + m.getDeclaringClass().getName() + "#" + m.getName());
                    }
                    invoker = this.createParameterizedProperty(returnType, propName, nameAnnot.name(), defaultSupplier);
                } else {
                    invoker = this.createScalarProperty(m.getGenericReturnType(), propName, defaultSupplier);
                }
                if (immutable) {
                    Object value = invoker.invoke(new Object[0]);
                    invokers.put(m, args -> value);
                    continue;
                }
                invokers.put(m, invoker);
            }
            catch (Exception e2) {
                throw new RuntimeException("Error proxying method " + m.getName(), e2);
            }
        }
        return (T)proxyObject;
    }

    private static <T> Supplier<T> memoize(T value) {
        return () -> value;
    }

    private static <T> Supplier<T> createDefaultMethodSupplier(Method method, Class<T> type2, T proxyObject) {
        MethodHandle methodHandle;
        try {
            if (SystemUtils.IS_JAVA_1_8) {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                constructor.setAccessible(true);
                methodHandle = ((MethodHandles.Lookup)constructor.newInstance(type2, 2)).unreflectSpecial(method, type2).bindTo(proxyObject);
            } else {
                methodHandle = MethodHandles.lookup().findSpecial(type2, method.getName(), MethodType.methodType(method.getReturnType(), new Class[0]), type2).bindTo(proxyObject);
            }
        }
        catch (Throwable e2) {
            throw new RuntimeException("Failed to create temporary object for " + type2.getName(), e2);
        }
        return () -> {
            try {
                return methodHandle.invokeWithArguments(new Object[0]);
            }
            catch (Throwable e2) {
                throw new RuntimeException(e2);
            }
        };
    }

    protected <T> MethodInvoker<T> createInterfaceProperty(String propName, T proxy2) {
        LOG.debug("Creating interface property `{}` for type `{}`", (Object)propName, (Object)proxy2.getClass());
        return args -> proxy2;
    }

    protected <T> MethodInvoker<T> createScalarProperty(Type type2, String propName, Supplier<T> next2) {
        LOG.debug("Creating scalar property `{}` for type `{}`", (Object)propName, (Object)type2.getClass());
        Property prop = this.propertyRepository.get(propName, type2);
        return args -> Optional.ofNullable(prop.get()).orElseGet(next2);
    }

    protected <T> MethodInvoker<T> createParameterizedProperty(final Class<T> returnType, String propName, final String nameAnnot, final Supplier<T> next2) {
        LOG.debug("Creating parameterized property `{}` for type `{}`", (Object)propName, (Object)returnType);
        return new MethodInvoker<T>(){

            @Override
            public T invoke(Object[] args) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                for (int i = 0; i < args.length; ++i) {
                    values.put("" + i, args[i]);
                }
                String propName = new StrSubstitutor(values, "${", "}", '$').replace(nameAnnot);
                Object result = this.getPropertyWithDefault(returnType, propName);
                if (result == null) {
                    result = next2.get();
                }
                return result;
            }

            <R> R getPropertyWithDefault(Class<R> type2, String propName) {
                return ConfigProxyFactory.this.propertyRepository.get(propName, type2).get();
            }
        };
    }

    static {
        knownCollections.put((Type)((Object)Map.class), Collections::emptyMap);
        knownCollections.put((Type)((Object)Set.class), Collections::emptySet);
        knownCollections.put((Type)((Object)SortedSet.class), Collections::emptySortedSet);
        knownCollections.put((Type)((Object)List.class), Collections::emptyList);
        knownCollections.put((Type)((Object)LinkedList.class), LinkedList::new);
    }

    private static abstract class PropertyMethodInvoker<T>
    extends AbstractProperty<T>
    implements MethodInvoker<T> {
        private final Supplier<T> next;

        public PropertyMethodInvoker(String key2, Supplier<T> next2) {
            super(key2);
            this.next = next2;
        }

        @Override
        public T invoke(Object[] args) {
            Object result = this.get();
            if (result == null) {
                return this.next.get();
            }
            return result;
        }
    }

    static interface MethodInvoker<T> {
        public T invoke(Object[] var1);
    }
}

