/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.api.CascadeStrategy;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigLoader;
import com.netflix.archaius.api.ConfigReader;
import com.netflix.archaius.api.StrInterpolator;
import com.netflix.archaius.api.config.CompositeConfig;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.cascade.NoCascadeStrategy;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.MapConfig;
import com.netflix.archaius.interpolate.CommonsStrInterpolator;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import com.netflix.archaius.readers.PropertiesConfigReader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigLoader
implements ConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConfigLoader.class);
    private static final NoCascadeStrategy DEFAULT_CASCADE_STRATEGY = new NoCascadeStrategy();
    private static final StrInterpolator.Lookup DEFAULT_LOOKUP = new StrInterpolator.Lookup(){

        @Override
        public String lookup(String key2) {
            return null;
        }
    };
    private static final StrInterpolator DEFAULT_INTERPOLATOR = CommonsStrInterpolator.INSTANCE;
    private final Set<ConfigReader> loaders;
    private final CascadeStrategy defaultStrategy;
    private final StrInterpolator interpolator;
    private final StrInterpolator.Lookup lookup;

    public static Builder builder() {
        return new Builder();
    }

    public DefaultConfigLoader(Builder builder) {
        this.loaders = builder.loaders;
        this.defaultStrategy = builder.defaultStrategy;
        this.interpolator = builder.interpolator;
        this.lookup = builder.lookup;
    }

    @Override
    public ConfigLoader.Loader newLoader() {
        return new ConfigLoader.Loader(){
            private CascadeStrategy strategy;
            private ClassLoader classLoader;
            private Config overrides;
            {
                this.strategy = DefaultConfigLoader.this.defaultStrategy;
                this.classLoader = Thread.currentThread().getContextClassLoader();
                this.overrides = null;
            }

            @Override
            public ConfigLoader.Loader withCascadeStrategy(CascadeStrategy strategy) {
                this.strategy = strategy;
                return this;
            }

            @Override
            public ConfigLoader.Loader withClassLoader(ClassLoader classLoader) {
                this.classLoader = classLoader;
                return this;
            }

            @Override
            public ConfigLoader.Loader withFailOnFirst(boolean flag) {
                return this;
            }

            @Override
            public ConfigLoader.Loader withOverrides(Properties props) {
                this.overrides = MapConfig.from(props);
                return this;
            }

            @Override
            public ConfigLoader.Loader withOverrides(Config config) {
                this.overrides = config;
                return this;
            }

            @Override
            public CompositeConfig load(String resourceName) throws ConfigException {
                DefaultCompositeConfig compositeConfig = new DefaultCompositeConfig(true);
                List<String> names = this.strategy.generate(resourceName, DefaultConfigLoader.this.interpolator, DefaultConfigLoader.this.lookup);
                block2: for (String name2 : names) {
                    for (ConfigReader reader2 : DefaultConfigLoader.this.loaders) {
                        if (!reader2.canLoad(this.classLoader, name2)) continue;
                        try {
                            Config config = reader2.load(this.classLoader, name2, DefaultConfigLoader.this.interpolator, DefaultConfigLoader.this.lookup);
                            if (!config.isEmpty()) {
                                compositeConfig.addConfig(name2, config);
                            }
                            LOG.debug("Loaded {} ", (Object)name2);
                        }
                        catch (ConfigException e2) {
                            LOG.debug("Unable to load {}, {}", (Object)name2, (Object)e2.getMessage());
                        }
                        continue block2;
                    }
                }
                if (this.overrides != null) {
                    LOG.debug("Loading overrides form {}", (Object)resourceName);
                    compositeConfig.addConfig(resourceName + "_overrides", this.overrides);
                }
                return compositeConfig;
            }

            @Override
            public Config load(URL url) {
                for (ConfigReader loader : DefaultConfigLoader.this.loaders) {
                    if (!loader.canLoad(this.classLoader, url)) continue;
                    try {
                        Config config = loader.load(this.classLoader, url, DefaultConfigLoader.this.interpolator, DefaultConfigLoader.this.lookup);
                        LOG.info("Loaded " + url);
                        return config;
                    }
                    catch (ConfigException e2) {
                        LOG.info("Unable to load file '{}'", new Object[]{url, e2.getMessage()});
                    }
                    catch (Exception e3) {
                        LOG.info("Unable to load file '{}'", new Object[]{url, e3.getMessage()});
                    }
                }
                return null;
            }

            @Override
            public Config load(File file2) throws ConfigException {
                try {
                    return this.load(file2.toURI().toURL());
                }
                catch (MalformedURLException e2) {
                    throw new ConfigException("Failed to load file " + file2, e2);
                }
            }
        };
    }

    static /* synthetic */ NoCascadeStrategy access$000() {
        return DEFAULT_CASCADE_STRATEGY;
    }

    static /* synthetic */ StrInterpolator access$100() {
        return DEFAULT_INTERPOLATOR;
    }

    static /* synthetic */ StrInterpolator.Lookup access$200() {
        return DEFAULT_LOOKUP;
    }

    public static class Builder {
        private Set<ConfigReader> loaders = new HashSet<ConfigReader>();
        private CascadeStrategy defaultStrategy = DefaultConfigLoader.access$000();
        private StrInterpolator interpolator = DefaultConfigLoader.access$100();
        private StrInterpolator.Lookup lookup = DefaultConfigLoader.access$200();

        public Builder withConfigReader(ConfigReader loader) {
            this.loaders.add(loader);
            return this;
        }

        public Builder withConfigReaders(Set<ConfigReader> loaders) {
            if (loaders != null) {
                this.loaders.addAll(loaders);
            }
            return this;
        }

        public Builder withDefaultCascadingStrategy(CascadeStrategy strategy) {
            if (strategy != null) {
                this.defaultStrategy = strategy;
            }
            return this;
        }

        @Deprecated
        public Builder withFailOnFirst(boolean flag) {
            return this;
        }

        public Builder withStrInterpolator(StrInterpolator interpolator) {
            if (interpolator != null) {
                this.interpolator = interpolator;
            }
            return this;
        }

        public Builder withStrLookup(StrInterpolator.Lookup lookup) {
            this.lookup = lookup;
            return this;
        }

        public Builder withStrLookup(Config config) {
            this.lookup = ConfigStrLookup.from(config);
            return this;
        }

        public DefaultConfigLoader build() {
            if (this.loaders.isEmpty()) {
                this.loaders.add(new PropertiesConfigReader());
            }
            return new DefaultConfigLoader(this);
        }
    }
}

