/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.DefaultDecoder;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.StrInterpolator;
import com.netflix.archaius.config.PrefixedViewConfig;
import com.netflix.archaius.exceptions.ParseException;
import com.netflix.archaius.interpolate.CommonsStrInterpolator;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

public abstract class AbstractConfig
implements Config {
    private final CopyOnWriteArrayList<ConfigListener> listeners = new CopyOnWriteArrayList();
    private final StrInterpolator.Lookup lookup;
    private Decoder decoder = DefaultDecoder.INSTANCE;
    private StrInterpolator interpolator = CommonsStrInterpolator.INSTANCE;
    private String listDelimiter = ",";
    private final String name;
    private static final AtomicInteger idCounter = new AtomicInteger();

    protected static String generateUniqueName(String prefix) {
        return prefix + idCounter.incrementAndGet();
    }

    public AbstractConfig(String name2) {
        this.lookup = ConfigStrLookup.from(this);
        this.name = name2 == null ? AbstractConfig.generateUniqueName("unnamed-") : name2;
    }

    public AbstractConfig() {
        this(AbstractConfig.generateUniqueName("unnamed-"));
    }

    protected CopyOnWriteArrayList<ConfigListener> getListeners() {
        return this.listeners;
    }

    protected StrInterpolator.Lookup getLookup() {
        return this.lookup;
    }

    public String getListDelimiter() {
        return this.listDelimiter;
    }

    public void setListDelimiter(String delimiter) {
        this.listDelimiter = delimiter;
    }

    @Override
    public final Decoder getDecoder() {
        return this.decoder;
    }

    @Override
    public void setDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public final StrInterpolator getStrInterpolator() {
        return this.interpolator;
    }

    @Override
    public void setStrInterpolator(StrInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    @Override
    public void addListener(ConfigListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ConfigListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyConfigUpdated(Config child) {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigUpdated(child);
        }
    }

    protected void notifyError(Throwable t, Config child) {
        for (ConfigListener listener : this.listeners) {
            listener.onError(t, child);
        }
    }

    protected void notifyConfigAdded(Config child) {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigAdded(child);
        }
    }

    protected void notifyConfigRemoved(Config child) {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigRemoved(child);
        }
    }

    @Override
    public String getString(String key2, String defaultValue) {
        Object value = this.getRawProperty(key2);
        if (value == null) {
            return this.notFound(key2, defaultValue != null ? this.interpolator.create(this.getLookup()).resolve(defaultValue) : null);
        }
        if (value instanceof String) {
            return this.resolve((String)value);
        }
        return value.toString();
    }

    @Override
    public String getString(String key2) {
        Object value = this.getRawProperty(key2);
        if (value == null) {
            return (String)this.notFound(key2);
        }
        if (value instanceof String) {
            return this.resolve(value.toString());
        }
        return value.toString();
    }

    protected <T> T notFound(String key2, T defaultValue) {
        return defaultValue;
    }

    protected <T> T notFound(String key2) {
        throw new NoSuchElementException("'" + key2 + "' not found");
    }

    @Override
    @Deprecated
    public Iterator<String> getKeys(final String prefix) {
        return new Iterator<String>(){
            Iterator<String> iter;
            String next;
            {
                this.iter = AbstractConfig.this.getKeys();
                while (this.iter.hasNext()) {
                    this.next = this.iter.next();
                    if (this.next.startsWith(prefix)) break;
                    this.next = null;
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public String next() {
                if (this.next == null) {
                    throw new IllegalStateException();
                }
                String current = this.next;
                this.next = null;
                while (this.iter.hasNext()) {
                    this.next = this.iter.next();
                    if (this.next.startsWith(prefix)) break;
                    this.next = null;
                }
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Config getPrefixedView(String prefix) {
        if (prefix == null || prefix.isEmpty() || prefix.equals(".")) {
            return this;
        }
        return new PrefixedViewConfig(prefix, this);
    }

    @Override
    public <T> T accept(Config.Visitor<T> visitor) {
        Object result = null;
        this.forEachProperty((k, v) -> visitor.visitKey((String)k, v));
        return null;
    }

    protected <T> T getValue(Type type2, String key2) {
        T value = this.getValueWithDefault(type2, key2, null);
        if (value == null) {
            return this.notFound(key2);
        }
        return value;
    }

    protected <T> T getValueWithDefault(Type type2, String key2, T defaultValue) {
        Class cls;
        Object rawProp = this.getRawProperty(key2);
        if (rawProp == null) {
            return defaultValue;
        }
        if (rawProp instanceof String) {
            try {
                String value = this.resolve(rawProp.toString());
                return this.decoder.decode(type2, value);
            }
            catch (NumberFormatException e2) {
                return this.parseError(key2, rawProp.toString(), e2);
            }
        }
        if (type2 instanceof Class && ((cls = (Class)type2).isInstance(rawProp) || cls.isPrimitive())) {
            return (T)rawProp;
        }
        return this.parseError(key2, rawProp.toString(), new NumberFormatException("Property " + rawProp.toString() + " is of wrong format " + type2.getTypeName()));
    }

    @Override
    public String resolve(String value) {
        return this.interpolator.create(this.getLookup()).resolve(value);
    }

    @Override
    public <T> T resolve(String value, Class<T> type2) {
        return this.getDecoder().decode(type2, this.resolve(value));
    }

    @Override
    public Long getLong(String key2) {
        return (Long)this.getValue((Type)((Object)Long.class), key2);
    }

    @Override
    public Long getLong(String key2, Long defaultValue) {
        return this.getValueWithDefault((Type)((Object)Long.class), key2, (Object)defaultValue);
    }

    @Override
    public Double getDouble(String key2) {
        return (Double)this.getValue((Type)((Object)Double.class), key2);
    }

    @Override
    public Double getDouble(String key2, Double defaultValue) {
        return this.getValueWithDefault((Type)((Object)Double.class), key2, (Object)defaultValue);
    }

    @Override
    public Integer getInteger(String key2) {
        return (Integer)this.getValue((Type)((Object)Integer.class), key2);
    }

    @Override
    public Integer getInteger(String key2, Integer defaultValue) {
        return this.getValueWithDefault((Type)((Object)Integer.class), key2, (Object)defaultValue);
    }

    @Override
    public Boolean getBoolean(String key2) {
        return (Boolean)this.getValue((Type)((Object)Boolean.class), key2);
    }

    @Override
    public Boolean getBoolean(String key2, Boolean defaultValue) {
        return this.getValueWithDefault((Type)((Object)Boolean.class), key2, (Object)defaultValue);
    }

    @Override
    public Short getShort(String key2) {
        return (Short)this.getValue((Type)((Object)Short.class), key2);
    }

    @Override
    public Short getShort(String key2, Short defaultValue) {
        return this.getValueWithDefault((Type)((Object)Short.class), key2, (Object)defaultValue);
    }

    @Override
    public BigInteger getBigInteger(String key2) {
        return (BigInteger)this.getValue((Type)((Object)BigInteger.class), key2);
    }

    @Override
    public BigInteger getBigInteger(String key2, BigInteger defaultValue) {
        return this.getValueWithDefault((Type)((Object)BigInteger.class), key2, (Object)defaultValue);
    }

    @Override
    public BigDecimal getBigDecimal(String key2) {
        return (BigDecimal)this.getValue((Type)((Object)BigDecimal.class), key2);
    }

    @Override
    public BigDecimal getBigDecimal(String key2, BigDecimal defaultValue) {
        return this.getValueWithDefault((Type)((Object)BigDecimal.class), key2, (Object)defaultValue);
    }

    @Override
    public Float getFloat(String key2) {
        return (Float)this.getValue((Type)((Object)Float.class), key2);
    }

    @Override
    public Float getFloat(String key2, Float defaultValue) {
        return this.getValueWithDefault((Type)((Object)Float.class), key2, (Object)defaultValue);
    }

    @Override
    public Byte getByte(String key2) {
        return (Byte)this.getValue((Type)((Object)Byte.class), key2);
    }

    @Override
    public Byte getByte(String key2, Byte defaultValue) {
        return this.getValueWithDefault((Type)((Object)Byte.class), key2, (Object)defaultValue);
    }

    @Override
    public <T> List<T> getList(String key2, Class<T> type2) {
        String value = this.getString(key2);
        if (value == null) {
            return (List)this.notFound(key2);
        }
        String[] parts = value.split(this.getListDelimiter());
        ArrayList<T> result = new ArrayList<T>();
        for (String part : parts) {
            result.add(this.decoder.decode(type2, part));
        }
        return result;
    }

    public List getList(String key2) {
        String value = this.getString(key2);
        if (value == null) {
            return (List)this.notFound(key2);
        }
        String[] parts = value.split(this.getListDelimiter());
        return Arrays.asList(parts);
    }

    public List getList(String key2, List defaultValue) {
        String value = this.getString(key2, null);
        if (value == null) {
            return this.notFound(key2, defaultValue);
        }
        String[] parts = value.split(",");
        return Arrays.asList(parts);
    }

    @Override
    public <T> T get(Class<T> type2, String key2) {
        return this.getValue(type2, key2);
    }

    @Override
    public <T> T get(Class<T> type2, String key2, T defaultValue) {
        return this.getValueWithDefault(type2, key2, defaultValue);
    }

    @Override
    public <T> T get(Type type2, String key2) {
        return this.getValue(type2, key2);
    }

    @Override
    public <T> T get(Type type2, String key2, T defaultValue) {
        return this.getValueWithDefault(type2, key2, defaultValue);
    }

    private <T> T parseError(String key2, String value, Exception e2) {
        throw new ParseException("Error parsing value '" + value + "' for property '" + key2 + "'", e2);
    }

    @Override
    public void forEachProperty(BiConsumer<String, Object> consumer) {
        Iterator<String> keys2 = this.getKeys();
        while (keys2.hasNext()) {
            String key2 = keys2.next();
            Object value = this.getRawProperty(key2);
            if (value == null) continue;
            consumer.accept(key2, value);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

