/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.config.SettableConfig;
import com.netflix.archaius.config.AbstractConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class DefaultSettableConfig
extends AbstractConfig
implements SettableConfig {
    private volatile Map<String, Object> props = Collections.emptyMap();

    public DefaultSettableConfig(String name2) {
        super(name2);
    }

    public DefaultSettableConfig() {
        super(DefaultSettableConfig.generateUniqueName("settable-"));
    }

    @Override
    public synchronized <T> void setProperty(String propName, T propValue) {
        HashMap<String, Object> copy2 = new HashMap<String, Object>(this.props.size() + 1);
        copy2.putAll(this.props);
        copy2.put(propName, propValue);
        this.props = copy2;
        this.notifyConfigUpdated(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearProperty(String propName) {
        if (this.props.containsKey(propName)) {
            DefaultSettableConfig defaultSettableConfig = this;
            synchronized (defaultSettableConfig) {
                HashMap<String, Object> copy2 = new HashMap<String, Object>(this.props);
                copy2.remove(propName);
                this.props = copy2;
                this.notifyConfigUpdated(this);
            }
        }
    }

    @Override
    public boolean containsKey(String key2) {
        return this.props.containsKey(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    @Override
    public Object getRawProperty(String key2) {
        return this.props.get(key2);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.props.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(Properties src) {
        if (null != src) {
            DefaultSettableConfig defaultSettableConfig = this;
            synchronized (defaultSettableConfig) {
                HashMap<String, Object> copy2 = new HashMap<String, Object>(this.props.size() + src.size());
                copy2.putAll(this.props);
                for (Map.Entry<Object, Object> prop : src.entrySet()) {
                    copy2.put(prop.getKey().toString(), prop.getValue());
                }
                this.props = copy2;
                this.notifyConfigUpdated(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(Config src) {
        if (null != src) {
            DefaultSettableConfig defaultSettableConfig = this;
            synchronized (defaultSettableConfig) {
                HashMap<String, Object> copy2 = new HashMap<String, Object>(this.props);
                src.forEachProperty(copy2::put);
                this.props = copy2;
                this.notifyConfigUpdated(this);
            }
        }
    }

    @Override
    public void forEachProperty(BiConsumer<String, Object> consumer) {
        this.props.forEach(consumer);
    }
}

