/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.mantis.discovery.proto;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class StreamJobClusterMap {
    public static final String DEFAULT_STREAM_KEY = "__default__";
    private String appName;
    private Map<String, String> mappings;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public StreamJobClusterMap(String appName, Map<String, String> mappings) {
        this.appName = appName;
        this.mappings = mappings;
    }

    public StreamJobClusterMap() {
    }

    public String getAppName() {
        return this.appName;
    }

    @JsonIgnore
    public String getJobCluster(String streamName) {
        return this.mappings.getOrDefault(streamName, this.mappings.get(DEFAULT_STREAM_KEY));
    }

    public Map<String, String> getStreamJobClusterMap() {
        return Collections.unmodifiableMap(this.mappings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamJobClusterMap that = (StreamJobClusterMap)o;
        return Objects.equals(this.appName, that.appName) && Objects.equals(this.mappings, that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.appName, this.mappings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StreamJobClusterMap{");
        sb.append("appName='").append(this.appName).append('\'');
        sb.append(", mappings=").append(this.mappings);
        sb.append('}');
        return sb.toString();
    }
}

