/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.channel.kqueue;

import io.mantisrx.shaded.io.netty.channel.Channel;
import io.mantisrx.shaded.io.netty.channel.EventLoop;
import io.mantisrx.shaded.io.netty.channel.kqueue.AbstractKQueueServerChannel;
import io.mantisrx.shaded.io.netty.channel.kqueue.BsdSocket;
import io.mantisrx.shaded.io.netty.channel.kqueue.KQueueEventLoop;
import io.mantisrx.shaded.io.netty.channel.kqueue.KQueueServerSocketChannelConfig;
import io.mantisrx.shaded.io.netty.channel.kqueue.KQueueSocketChannel;
import io.mantisrx.shaded.io.netty.channel.socket.ServerSocketChannel;
import io.mantisrx.shaded.io.netty.channel.unix.NativeInetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class KQueueServerSocketChannel
extends AbstractKQueueServerChannel
implements ServerSocketChannel {
    private final KQueueServerSocketChannelConfig config = new KQueueServerSocketChannelConfig(this);

    public KQueueServerSocketChannel() {
        super(BsdSocket.newSocketStream(), false);
    }

    public KQueueServerSocketChannel(int fd) {
        this(new BsdSocket(fd));
    }

    KQueueServerSocketChannel(BsdSocket fd) {
        super(fd);
    }

    KQueueServerSocketChannel(BsdSocket fd, boolean active) {
        super(fd, active);
    }

    @Override
    protected boolean isCompatible(EventLoop loop2) {
        return loop2 instanceof KQueueEventLoop;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        super.doBind(localAddress);
        this.socket.listen(this.config.getBacklog());
        this.active = true;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public KQueueServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected Channel newChildChannel(int fd, byte[] address, int offset, int len) throws Exception {
        return new KQueueSocketChannel((Channel)this, new BsdSocket(fd), NativeInetAddress.address(address, offset, len));
    }
}

