/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.internal.producers.SingleDelayedProducer;
import rx.plugins.RxJavaHooks;

public final class OperatorAll<T>
implements Observable.Operator<Boolean, T> {
    final Func1<? super T, Boolean> predicate;

    public OperatorAll(Func1<? super T, Boolean> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super Boolean> child) {
        final SingleDelayedProducer<? super Boolean> producer = new SingleDelayedProducer<Boolean>(child);
        Subscriber s = new Subscriber<T>(){
            boolean done;

            @Override
            public void onNext(T t) {
                Boolean result;
                if (this.done) {
                    return;
                }
                try {
                    result = OperatorAll.this.predicate.call(t);
                }
                catch (Throwable e2) {
                    Exceptions.throwOrReport(e2, this, t);
                    return;
                }
                if (!result.booleanValue()) {
                    this.done = true;
                    producer.setValue(false);
                    this.unsubscribe();
                }
            }

            @Override
            public void onError(Throwable e2) {
                if (!this.done) {
                    this.done = true;
                    child.onError(e2);
                } else {
                    RxJavaHooks.onError(e2);
                }
            }

            @Override
            public void onCompleted() {
                if (!this.done) {
                    this.done = true;
                    producer.setValue(true);
                }
            }
        };
        child.add(s);
        child.setProducer(producer);
        return s;
    }
}

