/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.subscriptions;

import java.util.concurrent.atomic.AtomicReference;
import rx.Subscription;
import rx.internal.subscriptions.Unsubscribed;
import rx.subscriptions.Subscriptions;

public final class SequentialSubscription
extends AtomicReference<Subscription>
implements Subscription {
    private static final long serialVersionUID = 995205034283130269L;

    public SequentialSubscription() {
    }

    public SequentialSubscription(Subscription initial) {
        this.lazySet(initial);
    }

    public Subscription current() {
        Subscription current = (Subscription)super.get();
        if (current == Unsubscribed.INSTANCE) {
            return Subscriptions.unsubscribed();
        }
        return current;
    }

    public boolean update(Subscription next2) {
        Subscription current;
        do {
            if ((current = (Subscription)this.get()) != Unsubscribed.INSTANCE) continue;
            if (next2 != null) {
                next2.unsubscribe();
            }
            return false;
        } while (!this.compareAndSet(current, next2));
        if (current != null) {
            current.unsubscribe();
        }
        return true;
    }

    public boolean replace(Subscription next2) {
        Subscription current;
        do {
            if ((current = (Subscription)this.get()) != Unsubscribed.INSTANCE) continue;
            if (next2 != null) {
                next2.unsubscribe();
            }
            return false;
        } while (!this.compareAndSet(current, next2));
        return true;
    }

    public boolean updateWeak(Subscription next2) {
        Subscription current = (Subscription)this.get();
        if (current == Unsubscribed.INSTANCE) {
            if (next2 != null) {
                next2.unsubscribe();
            }
            return false;
        }
        if (this.compareAndSet(current, next2)) {
            return true;
        }
        current = (Subscription)this.get();
        if (next2 != null) {
            next2.unsubscribe();
        }
        return current == Unsubscribed.INSTANCE;
    }

    public boolean replaceWeak(Subscription next2) {
        Subscription current = (Subscription)this.get();
        if (current == Unsubscribed.INSTANCE) {
            if (next2 != null) {
                next2.unsubscribe();
            }
            return false;
        }
        if (this.compareAndSet(current, next2)) {
            return true;
        }
        current = (Subscription)this.get();
        if (current == Unsubscribed.INSTANCE) {
            if (next2 != null) {
                next2.unsubscribe();
            }
            return false;
        }
        return true;
    }

    @Override
    public void unsubscribe() {
        Subscription current = (Subscription)this.get();
        if (current != Unsubscribed.INSTANCE && (current = (Subscription)this.getAndSet(Unsubscribed.INSTANCE)) != null && current != Unsubscribed.INSTANCE) {
            current.unsubscribe();
        }
    }

    @Override
    public boolean isUnsubscribed() {
        return this.get() == Unsubscribed.INSTANCE;
    }
}

