/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.TypeConverter;
import com.netflix.archaius.converters.ArrayTypeConverterFactory;
import com.netflix.archaius.converters.DefaultCollectionsTypeConverterFactory;
import com.netflix.archaius.converters.DefaultTypeConverterFactory;
import com.netflix.archaius.converters.EnumTypeConverterFactory;
import com.netflix.archaius.exceptions.ParseException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.inject.Singleton;

@Singleton
public class DefaultDecoder
implements Decoder,
TypeConverter.Registry {
    private final Map<Type, TypeConverter> cache = new ConcurrentHashMap<Type, TypeConverter>();
    private final List<TypeConverter.Factory> factories = new ArrayList<TypeConverter.Factory>();
    public static DefaultDecoder INSTANCE = new DefaultDecoder();

    private DefaultDecoder() {
        this.factories.add(DefaultTypeConverterFactory.INSTANCE);
        this.factories.add(DefaultCollectionsTypeConverterFactory.INSTANCE);
        this.factories.add(ArrayTypeConverterFactory.INSTANCE);
        this.factories.add(EnumTypeConverterFactory.INSTANCE);
    }

    @Override
    public <T> T decode(Class<T> type2, String encoded) {
        return this.decode((Type)type2, encoded);
    }

    @Override
    public <T> T decode(Type type2, String encoded) {
        try {
            if (encoded == null) {
                return null;
            }
            return (T)this.getOrCreateConverter(type2).convert(encoded);
        }
        catch (Exception e2) {
            throw new ParseException("Error decoding type `" + type2.getTypeName() + "`", e2);
        }
    }

    @Override
    public Optional<TypeConverter<?>> get(Type type2) {
        return Optional.ofNullable(this.getOrCreateConverter(type2));
    }

    private TypeConverter<?> getOrCreateConverter(Type type2) {
        TypeConverter<?> converter = this.cache.get(type2);
        if (converter == null) {
            converter = this.resolve(type2);
            if (converter == null) {
                throw new RuntimeException("No converter found for type '" + type2 + "'");
            }
            this.cache.put(type2, converter);
        }
        return converter;
    }

    private TypeConverter<?> resolve(Type type2) {
        return this.factories.stream().flatMap(factory -> factory.get(type2, this).map(Stream::of).orElseGet(Stream::empty)).findFirst().orElseGet(() -> DefaultDecoder.findValueOfTypeConverter(type2));
    }

    private static <T> TypeConverter<T> findValueOfTypeConverter(Type type2) {
        if (!(type2 instanceof Class)) {
            return null;
        }
        Class cls = (Class)type2;
        try {
            Method method = cls.getMethod("valueOf", String.class);
            return value -> {
                try {
                    return method.invoke(null, value);
                }
                catch (Exception e2) {
                    throw new ParseException("Error converting value '" + value + "' to '" + type2.getTypeName() + "'", e2);
                }
            };
        }
        catch (NoSuchMethodException e1) {
            try {
                Constructor c = cls.getConstructor(String.class);
                return value -> {
                    try {
                        return c.newInstance(value);
                    }
                    catch (Exception e2) {
                        throw new ParseException("Error converting value", e2);
                    }
                };
            }
            catch (NoSuchMethodException e2) {
                return null;
            }
        }
    }
}

