/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.PropertyDetails;
import com.netflix.archaius.api.StrInterpolator;
import com.netflix.archaius.config.AbstractDependentConfig;
import com.netflix.archaius.config.CachedState;
import com.netflix.archaius.config.DependentConfigListener;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import java.util.LinkedHashMap;
import java.util.Map;

public class PrefixedViewConfig
extends AbstractDependentConfig {
    private final Config config;
    private final String prefix;
    private final StrInterpolator.Lookup nonPrefixedLookup;
    private volatile CachedState state;

    public PrefixedViewConfig(String prefix, Config config) {
        this.config = config;
        this.prefix = prefix.endsWith(".") ? prefix : prefix + ".";
        this.nonPrefixedLookup = ConfigStrLookup.from(config);
        this.state = this.createState(config);
        this.config.addListener(new PrefixedViewConfigListener(this));
    }

    private void updateState(Config config) {
        this.state = this.createState(config);
    }

    private CachedState createState(Config config) {
        LinkedHashMap<String, Object> data2 = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Config> instrumentedKeys = new LinkedHashMap<String, Config>();
        boolean instrumented = config.instrumentationEnabled();
        config.forEachPropertyUninstrumented((k, v) -> {
            if (k.startsWith(this.prefix)) {
                String key2 = k.substring(this.prefix.length());
                data2.put(key2, v);
                if (instrumented) {
                    instrumentedKeys.put(key2, config);
                }
            }
        });
        return new CachedState(data2, instrumentedKeys);
    }

    @Override
    public CachedState getState() {
        return this.state;
    }

    @Override
    public <T> T accept(Config.Visitor<T> visitor) {
        T t = null;
        for (Map.Entry<String, Object> entry : this.state.getData().entrySet()) {
            t = visitor.visitKey(entry.getKey(), entry.getValue());
        }
        return t;
    }

    @Override
    protected StrInterpolator.Lookup getLookup() {
        return this.nonPrefixedLookup;
    }

    @Override
    public synchronized void setDecoder(Decoder decoder) {
        super.setDecoder(decoder);
        this.config.setDecoder(decoder);
    }

    @Override
    public synchronized void setStrInterpolator(StrInterpolator interpolator) {
        super.setStrInterpolator(interpolator);
        this.config.setStrInterpolator(interpolator);
    }

    @Override
    public synchronized void addListener(ConfigListener listener) {
        super.addListener(listener);
        this.config.addListener(listener);
    }

    @Override
    public synchronized void removeListener(ConfigListener listener) {
        super.removeListener(listener);
        this.config.removeListener(listener);
    }

    @Override
    protected PropertyDetails createPropertyDetails(String key2, Object value) {
        return new PropertyDetails(this.prefix + key2, null, value);
    }

    private static class PrefixedViewConfigListener
    extends DependentConfigListener<PrefixedViewConfig> {
        private PrefixedViewConfigListener(PrefixedViewConfig pvc) {
            super(pvc);
        }

        @Override
        public void onSourceConfigAdded(PrefixedViewConfig pvc, Config config) {
            pvc.updateState(config);
        }

        @Override
        public void onSourceConfigRemoved(PrefixedViewConfig pvc, Config config) {
            pvc.updateState(config);
        }

        @Override
        public void onSourceConfigUpdated(PrefixedViewConfig pvc, Config config) {
            pvc.updateState(config);
        }

        @Override
        public void onSourceError(Throwable error, PrefixedViewConfig pvc, Config config) {
        }
    }
}

